/*
 * Decompiled with CFR 0.152.
 */
package au.csiro.pathling.sql.udf;

import au.csiro.pathling.fhirpath.encoding.CodingEncoding;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.hadoop.shaded.org.apache.curator.shaded.com.google.common.collect.Streams;
import org.apache.spark.sql.Row;
import org.hl7.fhir.r4.model.Coding;
import scala.collection.JavaConverters;
import scala.collection.mutable.WrappedArray;

public final class TerminologyUdfHelpers {
    private TerminologyUdfHelpers() {
    }

    @Nullable
    static Row[] encodeMany(@Nullable Stream<Coding> codings) {
        return codings != null ? (Row[])codings.map(CodingEncoding::encode).toArray(Row[]::new) : null;
    }

    @Nullable
    public static Stream<Coding> decodeOneOrMany(@Nullable Object codingRowOrArray, int argumentIndex) {
        if (codingRowOrArray instanceof WrappedArray) {
            return TerminologyUdfHelpers.decodeMany((WrappedArray<Row>)((WrappedArray)codingRowOrArray));
        }
        if (codingRowOrArray instanceof Row || codingRowOrArray == null) {
            return TerminologyUdfHelpers.decodeOne((Row)codingRowOrArray);
        }
        throw new IllegalArgumentException(String.format("Row or WrappedArray<Row> column expected in argument %s, but given: %s,", argumentIndex, codingRowOrArray.getClass()));
    }

    @Nullable
    public static Stream<Coding> decodeOneOrMany(@Nullable Object codingRowOrArray) {
        return TerminologyUdfHelpers.decodeOneOrMany(codingRowOrArray, 0);
    }

    @Nullable
    public static Stream<Coding> decodeOne(@Nullable Row codingRow) {
        return codingRow != null ? Stream.of(CodingEncoding.decode(codingRow)) : null;
    }

    @Nullable
    public static Stream<Coding> decodeMany(@Nullable WrappedArray<Row> codingsRow) {
        return codingsRow != null ? Streams.stream((Iterable)JavaConverters.asJavaIterable(codingsRow)).filter(Objects::nonNull).map(CodingEncoding::decode) : null;
    }

    public static boolean isValidCoding(@Nullable Coding coding) {
        return Objects.nonNull(coding) && Objects.nonNull(coding.getSystem()) && Objects.nonNull(coding.getCode());
    }

    @Nonnull
    public static Stream<Coding> validCodings(@Nonnull Stream<Coding> codings) {
        return codings.filter(TerminologyUdfHelpers::isValidCoding);
    }
}

