/*
 * Decompiled with CFR 0.152.
 */
package au.csiro.pathling.sql.udf;

import au.csiro.pathling.sql.udf.SqlFunction;
import au.csiro.pathling.sql.udf.SqlFunction3;
import au.csiro.pathling.sql.udf.TerminologyUdfHelpers;
import au.csiro.pathling.terminology.TerminologyService;
import au.csiro.pathling.terminology.TerminologyServiceFactory;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.codesystems.ConceptSubsumptionOutcome;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubsumesUdf
implements SqlFunction,
SqlFunction3<Object, Object, Boolean, Boolean> {
    private static final Logger log = LoggerFactory.getLogger(SubsumesUdf.class);
    private static final long serialVersionUID = 7605853352299165569L;
    public static final String FUNCTION_NAME = "subsumes";
    public static final DataType RETURN_TYPE = DataTypes.BooleanType;
    public static final boolean PARAM_INVERTED_DEFAULT = false;
    @Nonnull
    private final TerminologyServiceFactory terminologyServiceFactory;

    public SubsumesUdf(@Nonnull TerminologyServiceFactory terminologyServiceFactory) {
        this.terminologyServiceFactory = terminologyServiceFactory;
    }

    @Override
    public String getName() {
        return FUNCTION_NAME;
    }

    @Override
    public DataType getReturnType() {
        return RETURN_TYPE;
    }

    @Nullable
    protected Boolean doCall(@Nullable Stream<Coding> codingsA, @Nullable Stream<Coding> codingsB, @Nullable Boolean inverted) {
        if (codingsA == null || codingsB == null) {
            return null;
        }
        boolean resolvedInverted = inverted != null ? inverted : false;
        TerminologyService terminologyService = this.terminologyServiceFactory.build();
        List validCodingsB = TerminologyUdfHelpers.validCodings(codingsB).collect(Collectors.toUnmodifiableList());
        return TerminologyUdfHelpers.validCodings(codingsA).anyMatch(codingA -> validCodingsB.stream().filter(codingB -> codingA.getSystem().equals(codingB.getSystem())).anyMatch(codingB -> SubsumesUdf.isSubsumes(terminologyService.subsumes((Coding)codingA, (Coding)codingB), resolvedInverted)));
    }

    @Nullable
    public Boolean call(@Nullable Object codingRowOrArrayA, @Nullable Object codingRowOrArrayB, @Nullable Boolean inverted) {
        return this.doCall(TerminologyUdfHelpers.decodeOneOrMany(codingRowOrArrayA), TerminologyUdfHelpers.decodeOneOrMany(codingRowOrArrayB, 1), inverted);
    }

    private static boolean isSubsumes(@Nonnull ConceptSubsumptionOutcome outcome, boolean inverted) {
        return ConceptSubsumptionOutcome.EQUIVALENT.equals((Object)outcome) || (inverted ? ConceptSubsumptionOutcome.SUBSUMEDBY : ConceptSubsumptionOutcome.SUBSUMES).equals((Object)outcome);
    }
}

