/*
 * Decompiled with CFR 0.152.
 */
package au.csiro.pathling.sql.udf;

import au.csiro.pathling.fhirpath.CodingHelpers;
import au.csiro.pathling.fhirpath.encoding.CodingEncoding;
import au.csiro.pathling.sql.udf.SqlFunction;
import au.csiro.pathling.sql.udf.SqlFunction3;
import au.csiro.pathling.sql.udf.TerminologyUdfHelpers;
import au.csiro.pathling.terminology.TerminologyService;
import au.csiro.pathling.terminology.TerminologyServiceFactory;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.hl7.fhir.r4.model.Coding;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DesignationUdf
implements SqlFunction,
SqlFunction3<Row, Row, String, String[]> {
    private static final Logger log = LoggerFactory.getLogger(DesignationUdf.class);
    private static final long serialVersionUID = -4123584679085357391L;
    public static final String FUNCTION_NAME = "designation";
    public static final DataType RETURN_TYPE = DataTypes.createArrayType((DataType)DataTypes.StringType);
    public static final String DESIGNATION_PROPERTY_CODE = "designation";
    private static final String[] EMPTY_RESULT = new String[0];
    @Nonnull
    private final TerminologyServiceFactory terminologyServiceFactory;

    DesignationUdf(@Nonnull TerminologyServiceFactory terminologyServiceFactory) {
        this.terminologyServiceFactory = terminologyServiceFactory;
    }

    @Override
    public String getName() {
        return "designation";
    }

    @Override
    public DataType getReturnType() {
        return RETURN_TYPE;
    }

    @Nullable
    protected String[] doCall(@Nullable Coding coding, @Nullable Coding use, @Nullable String language) {
        if (coding == null) {
            return null;
        }
        if (!TerminologyUdfHelpers.isValidCoding(coding) || Objects.nonNull(use) && !TerminologyUdfHelpers.isValidCoding(use)) {
            return EMPTY_RESULT;
        }
        TerminologyService terminologyService = this.terminologyServiceFactory.build();
        return (String[])terminologyService.lookup(coding, "designation").stream().filter(TerminologyService.Designation.class::isInstance).map(TerminologyService.Designation.class::cast).filter(designation -> Objects.isNull(language) || language.equals(designation.getLanguage())).filter(designation -> Objects.isNull(use) || CodingHelpers.codingEquals(use, designation.getUse())).map(TerminologyService.Designation::getValue).toArray(String[]::new);
    }

    @Nullable
    public String[] call(@Nullable Row codingRow, @Nullable Row use, @Nullable String language) {
        return this.doCall(CodingEncoding.decode(codingRow), CodingEncoding.decode(use), language);
    }
}

