/*
 * Decompiled with CFR 0.152.
 */
package au.csiro.pathling.fhir;

import au.csiro.pathling.PathlingVersion;
import ca.uhn.fhir.interceptor.api.Hook;
import ca.uhn.fhir.interceptor.api.Interceptor;
import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.rest.client.api.IHttpRequest;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@Interceptor
public class UserAgentInterceptor {
    public static final String PRODUCT_IDENTIFIER = "pathling";
    @Nonnull
    private final PathlingVersion version = new PathlingVersion();

    @Hook(value=Pointcut.CLIENT_REQUEST)
    public void handleClientRequest(@Nullable IHttpRequest httpRequest) {
        if (httpRequest != null) {
            String userAgent = this.version.getDescriptiveVersion().map(version -> "pathling/" + version).orElse(PRODUCT_IDENTIFIER);
            httpRequest.removeHeaders("User-Agent");
            httpRequest.addHeader("User-Agent", userAgent);
        }
    }
}

