/*
 * Decompiled with CFR 0.152.
 */
package au.csiro.pathling.config;

import java.io.Serializable;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

public class HttpClientConfiguration
implements Serializable {
    private static final long serialVersionUID = -1624276800166930462L;
    @NotNull
    @Min(value=0L)
    private @NotNull @Min(value=0L) int socketTimeout;
    @NotNull
    @Min(value=0L)
    private @NotNull @Min(value=0L) int maxConnectionsTotal;
    @Min(value=0L)
    private @Min(value=0L) int maxConnectionsPerRoute;
    @NotNull
    private boolean retryEnabled;
    @NotNull
    @Min(value=1L)
    private @NotNull @Min(value=1L) int retryCount;

    private static int $default$socketTimeout() {
        return 60000;
    }

    private static int $default$maxConnectionsTotal() {
        return 32;
    }

    private static int $default$maxConnectionsPerRoute() {
        return 16;
    }

    private static boolean $default$retryEnabled() {
        return true;
    }

    private static int $default$retryCount() {
        return 2;
    }

    HttpClientConfiguration(int socketTimeout, int maxConnectionsTotal, int maxConnectionsPerRoute, boolean retryEnabled, int retryCount) {
        this.socketTimeout = socketTimeout;
        this.maxConnectionsTotal = maxConnectionsTotal;
        this.maxConnectionsPerRoute = maxConnectionsPerRoute;
        this.retryEnabled = retryEnabled;
        this.retryCount = retryCount;
    }

    public static HttpClientConfigurationBuilder builder() {
        return new HttpClientConfigurationBuilder();
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public int getMaxConnectionsTotal() {
        return this.maxConnectionsTotal;
    }

    public int getMaxConnectionsPerRoute() {
        return this.maxConnectionsPerRoute;
    }

    public boolean isRetryEnabled() {
        return this.retryEnabled;
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    public void setSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
    }

    public void setMaxConnectionsTotal(int maxConnectionsTotal) {
        this.maxConnectionsTotal = maxConnectionsTotal;
    }

    public void setMaxConnectionsPerRoute(int maxConnectionsPerRoute) {
        this.maxConnectionsPerRoute = maxConnectionsPerRoute;
    }

    public void setRetryEnabled(boolean retryEnabled) {
        this.retryEnabled = retryEnabled;
    }

    public void setRetryCount(int retryCount) {
        this.retryCount = retryCount;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HttpClientConfiguration)) {
            return false;
        }
        HttpClientConfiguration other = (HttpClientConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getSocketTimeout() != other.getSocketTimeout()) {
            return false;
        }
        if (this.getMaxConnectionsTotal() != other.getMaxConnectionsTotal()) {
            return false;
        }
        if (this.getMaxConnectionsPerRoute() != other.getMaxConnectionsPerRoute()) {
            return false;
        }
        if (this.isRetryEnabled() != other.isRetryEnabled()) {
            return false;
        }
        return this.getRetryCount() == other.getRetryCount();
    }

    protected boolean canEqual(Object other) {
        return other instanceof HttpClientConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getSocketTimeout();
        result = result * 59 + this.getMaxConnectionsTotal();
        result = result * 59 + this.getMaxConnectionsPerRoute();
        result = result * 59 + (this.isRetryEnabled() ? 79 : 97);
        result = result * 59 + this.getRetryCount();
        return result;
    }

    public String toString() {
        return "HttpClientConfiguration(socketTimeout=" + this.getSocketTimeout() + ", maxConnectionsTotal=" + this.getMaxConnectionsTotal() + ", maxConnectionsPerRoute=" + this.getMaxConnectionsPerRoute() + ", retryEnabled=" + this.isRetryEnabled() + ", retryCount=" + this.getRetryCount() + ")";
    }

    public static class HttpClientConfigurationBuilder {
        private boolean socketTimeout$set;
        private int socketTimeout$value;
        private boolean maxConnectionsTotal$set;
        private int maxConnectionsTotal$value;
        private boolean maxConnectionsPerRoute$set;
        private int maxConnectionsPerRoute$value;
        private boolean retryEnabled$set;
        private boolean retryEnabled$value;
        private boolean retryCount$set;
        private int retryCount$value;

        HttpClientConfigurationBuilder() {
        }

        public HttpClientConfigurationBuilder socketTimeout(int socketTimeout) {
            this.socketTimeout$value = socketTimeout;
            this.socketTimeout$set = true;
            return this;
        }

        public HttpClientConfigurationBuilder maxConnectionsTotal(int maxConnectionsTotal) {
            this.maxConnectionsTotal$value = maxConnectionsTotal;
            this.maxConnectionsTotal$set = true;
            return this;
        }

        public HttpClientConfigurationBuilder maxConnectionsPerRoute(int maxConnectionsPerRoute) {
            this.maxConnectionsPerRoute$value = maxConnectionsPerRoute;
            this.maxConnectionsPerRoute$set = true;
            return this;
        }

        public HttpClientConfigurationBuilder retryEnabled(boolean retryEnabled) {
            this.retryEnabled$value = retryEnabled;
            this.retryEnabled$set = true;
            return this;
        }

        public HttpClientConfigurationBuilder retryCount(int retryCount) {
            this.retryCount$value = retryCount;
            this.retryCount$set = true;
            return this;
        }

        public HttpClientConfiguration build() {
            int socketTimeout$value = this.socketTimeout$value;
            if (!this.socketTimeout$set) {
                socketTimeout$value = HttpClientConfiguration.$default$socketTimeout();
            }
            int maxConnectionsTotal$value = this.maxConnectionsTotal$value;
            if (!this.maxConnectionsTotal$set) {
                maxConnectionsTotal$value = HttpClientConfiguration.$default$maxConnectionsTotal();
            }
            int maxConnectionsPerRoute$value = this.maxConnectionsPerRoute$value;
            if (!this.maxConnectionsPerRoute$set) {
                maxConnectionsPerRoute$value = HttpClientConfiguration.$default$maxConnectionsPerRoute();
            }
            boolean retryEnabled$value = this.retryEnabled$value;
            if (!this.retryEnabled$set) {
                retryEnabled$value = HttpClientConfiguration.$default$retryEnabled();
            }
            int retryCount$value = this.retryCount$value;
            if (!this.retryCount$set) {
                retryCount$value = HttpClientConfiguration.$default$retryCount();
            }
            return new HttpClientConfiguration(socketTimeout$value, maxConnectionsTotal$value, maxConnectionsPerRoute$value, retryEnabled$value, retryCount$value);
        }

        public String toString() {
            return "HttpClientConfiguration.HttpClientConfigurationBuilder(socketTimeout$value=" + this.socketTimeout$value + ", maxConnectionsTotal$value=" + this.maxConnectionsTotal$value + ", maxConnectionsPerRoute$value=" + this.maxConnectionsPerRoute$value + ", retryEnabled$value=" + this.retryEnabled$value + ", retryCount$value=" + this.retryCount$value + ")";
        }
    }
}

