/*
 * Decompiled with CFR 0.152.
 */
package au.csiro.pathling.config;

import java.util.Objects;
import javax.annotation.Nonnull;

public enum HttpClientCachingStorageType {
    MEMORY("memory"),
    DISK("disk");

    @Nonnull
    private final String code;

    private HttpClientCachingStorageType(String code) {
        this.code = Objects.requireNonNull(code);
    }

    public String toString() {
        return this.code;
    }

    @Nonnull
    public static HttpClientCachingStorageType fromCode(@Nonnull String code) {
        for (HttpClientCachingStorageType storageType : HttpClientCachingStorageType.values()) {
            if (!storageType.code.equals(code)) continue;
            return storageType;
        }
        throw new IllegalArgumentException("Unknown storage type: " + code);
    }
}

