/*
 * Decompiled with CFR 0.152.
 */
package main;

import blbutil.BGZIPOutputStream;
import blbutil.Utilities;
import imp.ImpData;
import imp.ImputedVcfWriter;
import imp.StateProbs;
import ints.IntList;
import ints.UnsignedByteArray;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.stream.IntStream;
import main.Par;
import vcf.GT;
import vcf.Samples;
import vcf.VcfWriter;

public class WindowWriter
implements Closeable {
    private final Samples samples;
    private final String outPrefix;
    private final File vcfOutFile;

    public WindowWriter(Par par, Samples samples) {
        if (samples == null) {
            throw new NullPointerException("samples==null");
        }
        this.outPrefix = par.out();
        this.vcfOutFile = new File(this.outPrefix + ".vcf.gz");
        this.samples = samples;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try (Closeable closeable = new PrintWriter(new BGZIPOutputStream(byteArrayOutputStream, false));){
            boolean bl = true;
            boolean bl2 = par.ap();
            boolean bl3 = par.gp();
            boolean bl4 = false;
            VcfWriter.writeMetaLines(samples.ids(), "beagle.28Jun21.220.jar", bl, bl2, bl3, bl4, (PrintWriter)closeable);
        }
        try {
            closeable = new FileOutputStream(this.vcfOutFile);
            var5_6 = null;
            try {
                ((FileOutputStream)closeable).write(byteArrayOutputStream.toByteArray());
            }
            catch (Throwable throwable) {
                var5_6 = throwable;
                throw throwable;
            }
            finally {
                if (closeable != null) {
                    if (var5_6 != null) {
                        try {
                            ((FileOutputStream)closeable).close();
                        }
                        catch (Throwable throwable) {
                            var5_6.addSuppressed(throwable);
                        }
                    } else {
                        ((FileOutputStream)closeable).close();
                    }
                }
            }
        }
        catch (IOException iOException) {
            WindowWriter.fileOutputError(this.vcfOutFile, iOException);
        }
    }

    public String outPrefix() {
        return this.outPrefix;
    }

    public Samples samples() {
        return this.samples;
    }

    public void printImputed(ImpData impData, int n, int n2, AtomicReferenceArray<StateProbs> atomicReferenceArray) {
        if (atomicReferenceArray.length() != impData.nTargHaps()) {
            throw new IllegalArgumentException("inconsistent data:");
        }
        UnsignedByteArray[] unsignedByteArrayArray = (UnsignedByteArray[])IntStream.range(0, impData.nClusters()).parallel().mapToObj(n3 -> WindowWriter.toByteArray(impData, n, n2, atomicReferenceArray, n3)).toArray(UnsignedByteArray[]::new);
        WindowWriter.print(unsignedByteArrayArray, this.vcfOutFile);
    }

    private static UnsignedByteArray toByteArray(ImpData impData, int n, int n2, AtomicReferenceArray<StateProbs> atomicReferenceArray, int n3) {
        ImputedVcfWriter imputedVcfWriter = new ImputedVcfWriter(impData, n, n2, n3);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try (PrintWriter printWriter = new PrintWriter(new BGZIPOutputStream(byteArrayOutputStream, false));){
            imputedVcfWriter.appendRecords(atomicReferenceArray, printWriter);
        }
        return new UnsignedByteArray(byteArrayOutputStream);
    }

    public void printPhased(GT gT, int n2, int n3, int n4) {
        int n5 = 20;
        int[] nArray = WindowWriter.starts(n2, n3, n5);
        UnsignedByteArray[] unsignedByteArrayArray = (UnsignedByteArray[])IntStream.range(0, nArray.length - 1).parallel().mapToObj(n -> WindowWriter.toByteArray(gT, nArray[n], nArray[n + 1])).toArray(UnsignedByteArray[]::new);
        WindowWriter.print(unsignedByteArrayArray, this.vcfOutFile);
    }

    private static int[] starts(int n, int n2, int n3) {
        IntList intList = new IntList(2 + (n2 - n) / n3);
        for (int i = n; i < n2; i += n3) {
            intList.add(i);
        }
        intList.add(n2);
        return intList.toArray();
    }

    private static UnsignedByteArray toByteArray(GT gT, int n, int n2) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try (PrintWriter printWriter = new PrintWriter(new BGZIPOutputStream(byteArrayOutputStream, false));){
            VcfWriter.appendRecords(gT, n, n2, printWriter);
        }
        return new UnsignedByteArray(byteArrayOutputStream);
    }

    private static void print(UnsignedByteArray[] unsignedByteArrayArray, File file) {
        boolean bl = true;
        try (BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file, bl));){
            for (UnsignedByteArray unsignedByteArray : unsignedByteArrayArray) {
                unsignedByteArray.write(bufferedOutputStream);
            }
        }
        catch (IOException iOException) {
            WindowWriter.fileOutputError(file, iOException);
        }
    }

    @Override
    public void close() {
        boolean bl = true;
        try (FileOutputStream fileOutputStream = new FileOutputStream(this.vcfOutFile, bl);
             BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);){
            BGZIPOutputStream bGZIPOutputStream = new BGZIPOutputStream(bufferedOutputStream, true);
            Throwable throwable = null;
            if (bGZIPOutputStream != null) {
                if (throwable != null) {
                    try {
                        bGZIPOutputStream.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                } else {
                    bGZIPOutputStream.close();
                }
            }
        }
        catch (IOException iOException) {
            Utilities.exit("Error closing file: " + this.vcfOutFile, iOException);
        }
    }

    private static void fileOutputError(File file, Exception exception) {
        Utilities.exit("Error writing to file: " + file, exception);
    }
}

