### THIS FILE IS AUTOGENERATED. DO NOT EDIT THIS FILE DIRECTLY ###
import minknow_api
from minknow_api.instance_pb2_grpc import *
import minknow_api.instance_pb2 as instance_pb2
from minknow_api.instance_pb2 import *
from minknow_api._support import MessageWrapper, ArgumentError
import time
import logging
import sys

__all__ = [
    "InstanceService",
    "GetVersionInfoRequest",
    "GetVersionInfoResponse",
    "GetOutputDirectoriesRequest",
    "OutputDirectories",
    "GetDefaultOutputDirectoriesRequest",
    "SetOutputDirectoryRequest",
    "SetOutputDirectoryResponse",
    "SetReadsDirectoryRequest",
    "SetReadsDirectoryResponse",
    "FilesystemDiskSpaceInfo",
    "GetDiskSpaceInfoRequest",
    "StreamDiskSpaceInfoRequest",
    "GetDiskSpaceInfoResponse",
    "GetMachineIdRequest",
    "GetMachineIdResponse",
    "StreamInstanceActivityRequest",
    "DeviceInfo",
    "BasecallSpeed",
    "N50",
    "StreamInstanceActivityResponse",
]

def run_with_retry(method, message, timeout, unwraps, full_name):
    retry_count = 20
    error = None
    for i in range(retry_count):
        try:
            result = MessageWrapper(method(message, timeout=timeout), unwraps=unwraps)
            return result
        except grpc.RpcError as e:
            # Retrying unidentified grpc errors to keep clients from crashing
            retryable_error = (e.code() == grpc.StatusCode.UNKNOWN and "Stream removed" in e.details() or \
                                (e.code() == grpc.StatusCode.INTERNAL and "RST_STREAM" in e.details()))
            if retryable_error:
                logging.info('Bypassed ({}: {}) error for grpc: {}. Attempt {}.'.format(e.code(), e.details(), full_name, i))
            else:
                raise
            error = e
        time.sleep(1)
    raise error


class InstanceService(object):
    def __init__(self, channel):
        self._stub = InstanceServiceStub(channel)
        self._pb = instance_pb2
    def get_version_info(self, _message=None, _timeout=None, **kwargs):
        """Current version information includes:
        - Minknow version
        - Protocols version
        - Distribution version

        This RPC has no side effects. Calling it will have no effect on the state of the
        system. It is safe to call repeatedly, or to retry on failure, although there is no
        guarantee it will return the same information each time.

        Args:
            _message (minknow_api.instance_pb2.GetVersionInfoRequest, optional): The message to send.
                This can be passed instead of the keyword arguments.
            _timeout (float, optional): The call will be cancelled after this number of seconds
                if it has not been completed.

        Returns:
            minknow_api.instance_pb2.GetVersionInfoResponse

        Note that the returned messages are actually wrapped in a type that collapses
        submessages for fields marked with ``[rpc_unwrap]``.
        """
        if _message is not None:
            if isinstance(_message, MessageWrapper):
                _message = _message._message
            return run_with_retry(self._stub.get_version_info,
                                  _message, _timeout,
                                  [],
                                  "minknow_api.instance.InstanceService")

        unused_args = set(kwargs.keys())

        _message = GetVersionInfoRequest()

        if len(unused_args) > 0:
            raise ArgumentError("Unexpected keyword arguments to get_version_info: '{}'".format(", ".join(unused_args)))

        return run_with_retry(self._stub.get_version_info,
                              _message, _timeout,
                              [],
                              "minknow_api.instance.InstanceService")
    def get_output_directories(self, _message=None, _timeout=None, **kwargs):
        """Returns various directory locations where minknow is outputting data. The paths are absolute paths, 
        local to the machine where minknow is installed

        the `output` base directory can be changed internally
        the `logs` directory will not be changed and can be stored
        the `reads` directory is determined  by the read writer config

        This RPC has no side effects. Calling it will have no effect on the state of the
        system. It is safe to call repeatedly, or to retry on failure, although there is no
        guarantee it will return the same information each time.

        Args:
            _message (minknow_api.instance_pb2.GetOutputDirectoriesRequest, optional): The message to send.
                This can be passed instead of the keyword arguments.
            _timeout (float, optional): The call will be cancelled after this number of seconds
                if it has not been completed.

        Returns:
            minknow_api.instance_pb2.OutputDirectories

        Note that the returned messages are actually wrapped in a type that collapses
        submessages for fields marked with ``[rpc_unwrap]``.
        """
        if _message is not None:
            if isinstance(_message, MessageWrapper):
                _message = _message._message
            return run_with_retry(self._stub.get_output_directories,
                                  _message, _timeout,
                                  [],
                                  "minknow_api.instance.InstanceService")

        unused_args = set(kwargs.keys())

        _message = GetOutputDirectoriesRequest()

        if len(unused_args) > 0:
            raise ArgumentError("Unexpected keyword arguments to get_output_directories: '{}'".format(", ".join(unused_args)))

        return run_with_retry(self._stub.get_output_directories,
                              _message, _timeout,
                              [],
                              "minknow_api.instance.InstanceService")
    def get_default_output_directories(self, _message=None, _timeout=None, **kwargs):
        """See `get_output_directories`, but this will always return the paths that are defined in the config when the instance
        of minknow has started

        Since 1.11

        This RPC has no side effects. Calling it will have no effect on the state of the
        system. It is safe to call repeatedly, or to retry on failure, although there is no
        guarantee it will return the same information each time.

        Args:
            _message (minknow_api.instance_pb2.GetDefaultOutputDirectoriesRequest, optional): The message to send.
                This can be passed instead of the keyword arguments.
            _timeout (float, optional): The call will be cancelled after this number of seconds
                if it has not been completed.

        Returns:
            minknow_api.instance_pb2.OutputDirectories

        Note that the returned messages are actually wrapped in a type that collapses
        submessages for fields marked with ``[rpc_unwrap]``.
        """
        if _message is not None:
            if isinstance(_message, MessageWrapper):
                _message = _message._message
            return run_with_retry(self._stub.get_default_output_directories,
                                  _message, _timeout,
                                  [],
                                  "minknow_api.instance.InstanceService")

        unused_args = set(kwargs.keys())

        _message = GetDefaultOutputDirectoriesRequest()

        if len(unused_args) > 0:
            raise ArgumentError("Unexpected keyword arguments to get_default_output_directories: '{}'".format(", ".join(unused_args)))

        return run_with_retry(self._stub.get_default_output_directories,
                              _message, _timeout,
                              [],
                              "minknow_api.instance.InstanceService")
    def set_output_directory(self, _message=None, _timeout=None, **kwargs):
        """Set the base directory to where all data will be output. Must be an absolute directory

        Fails with INVALID_ARGUMENT if `value` is not absolute.
        Fails with FAILED_PRECONDITION if this is called during acquisition

        Since 1.11

        This RPC is idempotent. It may change the state of the system, but if the requested
        change has already happened, it will not fail because of this, make any additional
        changes or return a different value.

        Args:
            _message (minknow_api.instance_pb2.SetOutputDirectoryRequest, optional): The message to send.
                This can be passed instead of the keyword arguments.
            _timeout (float, optional): The call will be cancelled after this number of seconds
                if it has not been completed.
            path (str, optional): 

        Returns:
            minknow_api.instance_pb2.SetOutputDirectoryResponse

        Note that the returned messages are actually wrapped in a type that collapses
        submessages for fields marked with ``[rpc_unwrap]``.
        """
        if _message is not None:
            if isinstance(_message, MessageWrapper):
                _message = _message._message
            return run_with_retry(self._stub.set_output_directory,
                                  _message, _timeout,
                                  [],
                                  "minknow_api.instance.InstanceService")

        unused_args = set(kwargs.keys())

        _message = SetOutputDirectoryRequest()

        if "path" in kwargs:
            unused_args.remove("path")
            _message.path = kwargs['path']

        if len(unused_args) > 0:
            raise ArgumentError("Unexpected keyword arguments to set_output_directory: '{}'".format(", ".join(unused_args)))

        return run_with_retry(self._stub.set_output_directory,
                              _message, _timeout,
                              [],
                              "minknow_api.instance.InstanceService")
    def set_reads_directory(self, _message=None, _timeout=None, **kwargs):
        """Set the reads directory where read files (hdf5, fastq, protobuf) will be output

        Fails with INVALID_ARGUMENT if `value` is not absolute.
        Fails with FAILED_PRECONDITION if this is called during acquisition

        Since 1.12

        This RPC is idempotent. It may change the state of the system, but if the requested
        change has already happened, it will not fail because of this, make any additional
        changes or return a different value.

        Args:
            _message (minknow_api.instance_pb2.SetReadsDirectoryRequest, optional): The message to send.
                This can be passed instead of the keyword arguments.
            _timeout (float, optional): The call will be cancelled after this number of seconds
                if it has not been completed.
            path (str, optional): 

        Returns:
            minknow_api.instance_pb2.SetReadsDirectoryResponse

        Note that the returned messages are actually wrapped in a type that collapses
        submessages for fields marked with ``[rpc_unwrap]``.
        """
        if _message is not None:
            if isinstance(_message, MessageWrapper):
                _message = _message._message
            return run_with_retry(self._stub.set_reads_directory,
                                  _message, _timeout,
                                  [],
                                  "minknow_api.instance.InstanceService")

        unused_args = set(kwargs.keys())

        _message = SetReadsDirectoryRequest()

        if "path" in kwargs:
            unused_args.remove("path")
            _message.path = kwargs['path']

        if len(unused_args) > 0:
            raise ArgumentError("Unexpected keyword arguments to set_reads_directory: '{}'".format(", ".join(unused_args)))

        return run_with_retry(self._stub.set_reads_directory,
                              _message, _timeout,
                              [],
                              "minknow_api.instance.InstanceService")
    def get_disk_space_info(self, _message=None, _timeout=None, **kwargs):
        """Returns information about the amount of disk space available, how much
        space is needed to stop an experiment cleanly and if MinKNOW thinks
        that the free disk-space is approaching or past this limit

        Since 1.11

        This RPC has no side effects. Calling it will have no effect on the state of the
        system. It is safe to call repeatedly, or to retry on failure, although there is no
        guarantee it will return the same information each time.

        Args:
            _message (minknow_api.instance_pb2.GetDiskSpaceInfoRequest, optional): The message to send.
                This can be passed instead of the keyword arguments.
            _timeout (float, optional): The call will be cancelled after this number of seconds
                if it has not been completed.

        Returns:
            minknow_api.instance_pb2.GetDiskSpaceInfoResponse

        Note that the returned messages are actually wrapped in a type that collapses
        submessages for fields marked with ``[rpc_unwrap]``.
        """
        if _message is not None:
            if isinstance(_message, MessageWrapper):
                _message = _message._message
            return run_with_retry(self._stub.get_disk_space_info,
                                  _message, _timeout,
                                  [],
                                  "minknow_api.instance.InstanceService")

        unused_args = set(kwargs.keys())

        _message = GetDiskSpaceInfoRequest()

        if len(unused_args) > 0:
            raise ArgumentError("Unexpected keyword arguments to get_disk_space_info: '{}'".format(", ".join(unused_args)))

        return run_with_retry(self._stub.get_disk_space_info,
                              _message, _timeout,
                              [],
                              "minknow_api.instance.InstanceService")
    def stream_disk_space_info(self, _message=None, _timeout=None, **kwargs):
        """Stream information about the amount of disk space available, how quickly
        it is being used, how much space is needed to stop an experiment cleanly
        and if MinKNOW thinks that the free disk-space is approaching or past
        this limit

        Since 4.0

        This RPC has no side effects. Calling it will have no effect on the state of the
        system. It is safe to call repeatedly, or to retry on failure, although there is no
        guarantee it will return the same information each time.

        Args:
            _message (minknow_api.instance_pb2.StreamDiskSpaceInfoRequest, optional): The message to send.
                This can be passed instead of the keyword arguments.
            _timeout (float, optional): The call will be cancelled after this number of seconds
                if it has not been completed.
                Note that this is the time until the call ends, not the time between returned
                messages.
            period (int, optional): Disk space information will be streamed with this value determining the
                period in seconds between updates.
                A period of 0 is invalid

        Returns:
            iter of minknow_api.instance_pb2.GetDiskSpaceInfoResponse

        Note that the returned messages are actually wrapped in a type that collapses
        submessages for fields marked with ``[rpc_unwrap]``.
        """
        if _message is not None:
            if isinstance(_message, MessageWrapper):
                _message = _message._message
            return run_with_retry(self._stub.stream_disk_space_info,
                                  _message, _timeout,
                                  [],
                                  "minknow_api.instance.InstanceService")

        unused_args = set(kwargs.keys())

        _message = StreamDiskSpaceInfoRequest()

        if "period" in kwargs:
            unused_args.remove("period")
            _message.period = kwargs['period']

        if len(unused_args) > 0:
            raise ArgumentError("Unexpected keyword arguments to stream_disk_space_info: '{}'".format(", ".join(unused_args)))

        return run_with_retry(self._stub.stream_disk_space_info,
                              _message, _timeout,
                              [],
                              "minknow_api.instance.InstanceService")
    def get_machine_id(self, _message=None, _timeout=None, **kwargs):
        """Find the machine id MinKNOW uses for this machine.

        This is expected to be a descriptive string for the machine, MinKNOW currently uses the network hostname.

        note: This is the identifier used when sending telemetry data for this instance.

        Since 1.11

        This RPC has no side effects. Calling it will have no effect on the state of the
        system. It is safe to call repeatedly, or to retry on failure, although there is no
        guarantee it will return the same information each time.

        Args:
            _message (minknow_api.instance_pb2.GetMachineIdRequest, optional): The message to send.
                This can be passed instead of the keyword arguments.
            _timeout (float, optional): The call will be cancelled after this number of seconds
                if it has not been completed.

        Returns:
            minknow_api.instance_pb2.GetMachineIdResponse

        Note that the returned messages are actually wrapped in a type that collapses
        submessages for fields marked with ``[rpc_unwrap]``.
        """
        if _message is not None:
            if isinstance(_message, MessageWrapper):
                _message = _message._message
            return run_with_retry(self._stub.get_machine_id,
                                  _message, _timeout,
                                  [],
                                  "minknow_api.instance.InstanceService")

        unused_args = set(kwargs.keys())

        _message = GetMachineIdRequest()

        if len(unused_args) > 0:
            raise ArgumentError("Unexpected keyword arguments to get_machine_id: '{}'".format(", ".join(unused_args)))

        return run_with_retry(self._stub.get_machine_id,
                              _message, _timeout,
                              [],
                              "minknow_api.instance.InstanceService")
    def stream_instance_activity(self, _message=None, _timeout=None, **kwargs):
        """Find a summary of activity on the instance.

        The information available from this request is also available from other rpc's - this call is intended
        as a performance improvement for users who watch a large number of streams (specifically over
        web socket transport).

        Use this request to find information about the current device, flow cell, protocol and acquisition state.

        Since 3.2

        This RPC has no side effects. Calling it will have no effect on the state of the
        system. It is safe to call repeatedly, or to retry on failure, although there is no
        guarantee it will return the same information each time.

        Args:
            _message (minknow_api.instance_pb2.StreamInstanceActivityRequest, optional): The message to send.
                This can be passed instead of the keyword arguments.
            _timeout (float, optional): The call will be cancelled after this number of seconds
                if it has not been completed.
                Note that this is the time until the call ends, not the time between returned
                messages.

        Returns:
            iter of minknow_api.instance_pb2.StreamInstanceActivityResponse

        Note that the returned messages are actually wrapped in a type that collapses
        submessages for fields marked with ``[rpc_unwrap]``.
        """
        if _message is not None:
            if isinstance(_message, MessageWrapper):
                _message = _message._message
            return run_with_retry(self._stub.stream_instance_activity,
                                  _message, _timeout,
                                  [],
                                  "minknow_api.instance.InstanceService")

        unused_args = set(kwargs.keys())

        _message = StreamInstanceActivityRequest()

        if len(unused_args) > 0:
            raise ArgumentError("Unexpected keyword arguments to stream_instance_activity: '{}'".format(", ".join(unused_args)))

        return run_with_retry(self._stub.stream_instance_activity,
                              _message, _timeout,
                              [],
                              "minknow_api.instance.InstanceService")
