### THIS FILE IS AUTOGENERATED. DO NOT EDIT THIS FILE DIRECTLY ###
import minknow_api
from minknow_api.data_pb2_grpc import *
import minknow_api.data_pb2 as data_pb2
from minknow_api.data_pb2 import *
from minknow_api._support import MessageWrapper, ArgumentError
import time
import logging
import sys

__all__ = [
    "DataService",
    "GetChannelStatesRequest",
    "GetChannelStatesResponse",
    "GetDataTypesRequest",
    "GetDataTypesResponse",
    "GetSignalBytesRequest",
    "GetSignalBytesResponse",
    "GetSignalMinMaxRequest",
    "GetSignalMinMaxResponse",
    "GetLiveReadsRequest",
    "GetLiveReadsResponse",
    "ResetChannelStatesRequest",
    "ResetChannelStatesResponse",
    "GetReadStatisticsRequest",
    "GetReadStatisticsResponse",
    "LockChannelStatesRequest",
    "LockChannelStatesResponse",
    "UnlockChannelStatesRequest",
    "UnlockChannelStatesResponse",
    "GetExperimentYieldInfoRequest",
    "GetExperimentYieldInfoResponse",
]

def run_with_retry(method, message, timeout, unwraps, full_name):
    retry_count = 20
    error = None
    for i in range(retry_count):
        try:
            result = MessageWrapper(method(message, timeout=timeout), unwraps=unwraps)
            return result
        except grpc.RpcError as e:
            # Retrying unidentified grpc errors to keep clients from crashing
            retryable_error = (e.code() == grpc.StatusCode.UNKNOWN and "Stream removed" in e.details() or \
                                (e.code() == grpc.StatusCode.INTERNAL and "RST_STREAM" in e.details()))
            if retryable_error:
                logging.info('Bypassed ({}: {}) error for grpc: {}. Attempt {}.'.format(e.code(), e.details(), full_name, i))
            else:
                raise
            error = e
        time.sleep(1)
    raise error


class DataService(object):
    def __init__(self, channel):
        self._stub = DataServiceStub(channel)
        self._pb = data_pb2
    def get_channel_states(self, _message=None, _timeout=None, **kwargs):
        """Get the channel states for all channels from the device.

        This will return all the channel states from the moment of calling until the rpc is
        closed by the user. If the user stops acquisition, the rpc will return with the
        ABORTED status. If the user cancels the rpc, the status will be CANCELLED.

        The first messages returned will retrieve the current channel state for all channels
        On the MinION, the current state for all channels will be included in the first message.
        For PromethION, it will be split on multiple messages.

        To determine which channels have been returned, please check the channel member in the
        messages returned in the response.

        The response will be streamed, and we will provide a message as soon as there are channel
        state changes (though note that some channels could stay in the same state for a long time),
        so there is no guaranteed frequency of the messages returned. However, because a response
        message includes multiple channels, it is very likely that we have messages every few seconds.
        As in, it is likely that at least some of the channels will change every so often, therefore
        messages will be generated. For example, if 5 out of 512 channels change the state in the
        same time, there will be a message containing all 5 changes. Later on, if other channels
        change their state we will receive another message containing those and so on. Note that
        MinKNOW tries to group as many channel state changes in a single message, up to the message
        limit size, which is currently set to 32kB.

        This RPC has no side effects. Calling it will have no effect on the state of the
        system. It is safe to call repeatedly, or to retry on failure, although there is no
        guarantee it will return the same information each time.

        Args:
            _message (minknow_api.data_pb2.GetChannelStatesRequest, optional): The message to send.
                This can be passed instead of the keyword arguments.
            _timeout (float, optional): The call will be cancelled after this number of seconds
                if it has not been completed.
                Note that this is the time until the call ends, not the time between returned
                messages.
            first_channel (int): The first channel (inclusive) to return data for.

                Note that channel numbering starts at 1.
            last_channel (int): The last channel (inclusive) to return data for.

                Note that channel numbering starts at 1.
            use_channel_states_ids (google.protobuf.wrappers_pb2.BoolValue, optional): If this is true, the returned messages will contain the
                channel state id as opposed to the name. By default,
                the response will contain channel states names.
            wait_for_processing (bool, optional): If `wait_for_processing` is true, then get_channel_states will wait until minknow starts
                acquiring data instead of returning with an error

                Defaults to false
            heartbeat (google.protobuf.duration_pb2.Duration, optional): Ensure the stream sends a message at least this often.

                There will usually be multiple channel updates a second, but in some circumstances (eg: a
                flow cell with no sample loaded) there can be long periods of time without updates.

                Setting this value will ensure that if this period of time passes without there being any
                channel state changes to report, an empty message will be sent. This can be useful to force a
                minimum wakeup interval in the client code.

        Returns:
            iter of minknow_api.data_pb2.GetChannelStatesResponse

        Note that the returned messages are actually wrapped in a type that collapses
        submessages for fields marked with ``[rpc_unwrap]``.
        """
        if _message is not None:
            if isinstance(_message, MessageWrapper):
                _message = _message._message
            return run_with_retry(self._stub.get_channel_states,
                                  _message, _timeout,
                                  [],
                                  "minknow_api.data.DataService")

        unused_args = set(kwargs.keys())

        _message = GetChannelStatesRequest()

        if "first_channel" in kwargs:
            unused_args.remove("first_channel")
            _message.first_channel = kwargs['first_channel']
        else:
            raise ArgumentError("get_channel_states requires a 'first_channel' argument")

        if "last_channel" in kwargs:
            unused_args.remove("last_channel")
            _message.last_channel = kwargs['last_channel']
        else:
            raise ArgumentError("get_channel_states requires a 'last_channel' argument")

        if "use_channel_states_ids" in kwargs:
            unused_args.remove("use_channel_states_ids")
            _message.use_channel_states_ids.value = kwargs['use_channel_states_ids']

        if "wait_for_processing" in kwargs:
            unused_args.remove("wait_for_processing")
            _message.wait_for_processing = kwargs['wait_for_processing']

        if "heartbeat" in kwargs:
            unused_args.remove("heartbeat")
            _message.heartbeat.CopyFrom(kwargs['heartbeat'])

        if len(unused_args) > 0:
            raise ArgumentError("Unexpected keyword arguments to get_channel_states: '{}'".format(", ".join(unused_args)))

        return run_with_retry(self._stub.get_channel_states,
                              _message, _timeout,
                              [],
                              "minknow_api.data.DataService")
    def get_data_types(self, _message=None, _timeout=None, **kwargs):
        """Get the data types of data items produced by this service.

        In order to allow clients to efficiently deal with large volumes of data in languages such as
        Python, this service can provide data as raw bytes. This call can be used to determine how to
        interpret those bytes. This can be used to construct an appropriate numpy dtype, for example.

        This RPC has no side effects. Calling it will have no effect on the state of the
        system. It is safe to call repeatedly, or to retry on failure, although there is no
        guarantee it will return the same information each time.

        Args:
            _message (minknow_api.data_pb2.GetDataTypesRequest, optional): The message to send.
                This can be passed instead of the keyword arguments.
            _timeout (float, optional): The call will be cancelled after this number of seconds
                if it has not been completed.

        Returns:
            minknow_api.data_pb2.GetDataTypesResponse

        Note that the returned messages are actually wrapped in a type that collapses
        submessages for fields marked with ``[rpc_unwrap]``.
        """
        if _message is not None:
            if isinstance(_message, MessageWrapper):
                _message = _message._message
            return run_with_retry(self._stub.get_data_types,
                                  _message, _timeout,
                                  [],
                                  "minknow_api.data.DataService")

        unused_args = set(kwargs.keys())

        _message = GetDataTypesRequest()

        if len(unused_args) > 0:
            raise ArgumentError("Unexpected keyword arguments to get_data_types: '{}'".format(", ".join(unused_args)))

        return run_with_retry(self._stub.get_data_types,
                              _message, _timeout,
                              [],
                              "minknow_api.data.DataService")
    def get_signal_bytes(self, _message=None, _timeout=None, **kwargs):
        """Get signal data from the device.

        This can be used to sample the signal being produced by the device. The signal can be
        returned as raw ADC values or as calibrated picoamp (pA) values; see ``set_calibration`` on
        the device service for the values used in this conversion.

        In addition to the signal, this can return the associated channel configuration and/or bias
        voltage information, to help analyse the data.

        If bias voltage information is requested, one bias voltage sample will be provided for each
        signal sample (on any given channel). So if you request 20 samples of signal data and also
        bias voltages, you will get 20 signal samples on each channel and also 20 bias voltage
        samples. Bias voltages are always given in millivolts, and no corrections need to be applied
        (for example, the 5x amplifier on a MinION is already accounted for).

        If channel configuration information is requested, each channel will have the starting
        channel configuration (with offset 0 to indicate it applies to the first sample on that
        channel), as well as any configuration changes that affect any of the returned samples.

        If a device settings change RPC has completed before this method is called, the data returned
        is guaranteed to have been generated by the device after those settings were applied.
        However, note that no guarantee is made about how device settings changes that overlap with
        this request will affect the returned data.

        The response will be streamed. In order to limit the size of each response message, any given
        message may include data from only a subset of the requested channels.

        Note that the data is returned as bytes fields. See the GetSignalBytesResponse documentation
        for more details about how to interpret the value. In Python code, the minknow.Device class
        provides a convenience wrapper method to convert the data into numpy arrays.

        This RPC has no side effects. Calling it will have no effect on the state of the
        system. It is safe to call repeatedly, or to retry on failure, although there is no
        guarantee it will return the same information each time.

        Args:
            _message (minknow_api.data_pb2.GetSignalBytesRequest, optional): The message to send.
                This can be passed instead of the keyword arguments.
            _timeout (float, optional): The call will be cancelled after this number of seconds
                if it has not been completed.
                Note that this is the time until the call ends, not the time between returned
                messages.
            seconds (float, optional): The amount of data to return in seconds.

                The number of samples returned will be just enough to cover this period of time. Cannot
                be specified at the same time as ``samples``.
            samples (int, optional): The amount of data to return in samples.

                The result will contain exactly this many samples. If this is not possible, the call will
                fail. Cannot be specified at the same time as ``seconds``.
            first_channel (int): The first channel (inclusive) to return data for.

                Note that channel numbering starts at 1.
            last_channel (int): The last channel (inclusive) to return data for.

                Note that channel numbering starts at 1.
            include_channel_configs (bool, optional): Whether to include channel configuration settings.
            include_bias_voltages (bool, optional): Whether to include bias voltage information.
            calibrated_data (bool, optional): Whether the data should be calibrated.
            return_when_listening (bool, optional): When this value is set to true, then an empty message will be sent back
                to the client to indicate that the backend has acknowleged the request,
                and that any calls made that will affect the signal after that initial 
                response will be reflected in the next messages

        Returns:
            iter of minknow_api.data_pb2.GetSignalBytesResponse

        Note that the returned messages are actually wrapped in a type that collapses
        submessages for fields marked with ``[rpc_unwrap]``.
        """
        if _message is not None:
            if isinstance(_message, MessageWrapper):
                _message = _message._message
            return run_with_retry(self._stub.get_signal_bytes,
                                  _message, _timeout,
                                  [],
                                  "minknow_api.data.DataService")

        unused_args = set(kwargs.keys())

        # check oneof group 'length'
        oneof_fields = set([
            "seconds",
            "samples",
        ])

        if len(unused_args & oneof_fields) > 1:
            raise ArgumentError("get_signal_bytes given multiple conflicting arguments: '{}'".format(", ".join(unused_args & oneof_fields)))

        _message = GetSignalBytesRequest()

        if "seconds" in kwargs:
            unused_args.remove("seconds")
            _message.seconds = kwargs['seconds']

        if "samples" in kwargs:
            unused_args.remove("samples")
            _message.samples = kwargs['samples']

        if "first_channel" in kwargs:
            unused_args.remove("first_channel")
            _message.first_channel = kwargs['first_channel']
        else:
            raise ArgumentError("get_signal_bytes requires a 'first_channel' argument")

        if "last_channel" in kwargs:
            unused_args.remove("last_channel")
            _message.last_channel = kwargs['last_channel']
        else:
            raise ArgumentError("get_signal_bytes requires a 'last_channel' argument")

        if "include_channel_configs" in kwargs:
            unused_args.remove("include_channel_configs")
            _message.include_channel_configs = kwargs['include_channel_configs']

        if "include_bias_voltages" in kwargs:
            unused_args.remove("include_bias_voltages")
            _message.include_bias_voltages = kwargs['include_bias_voltages']

        if "calibrated_data" in kwargs:
            unused_args.remove("calibrated_data")
            _message.calibrated_data = kwargs['calibrated_data']

        if "return_when_listening" in kwargs:
            unused_args.remove("return_when_listening")
            _message.return_when_listening = kwargs['return_when_listening']

        if len(unused_args) > 0:
            raise ArgumentError("Unexpected keyword arguments to get_signal_bytes: '{}'".format(", ".join(unused_args)))

        return run_with_retry(self._stub.get_signal_bytes,
                              _message, _timeout,
                              [],
                              "minknow_api.data.DataService")
    def get_signal_min_max(self, _message=None, _timeout=None, **kwargs):
        """Get summarised signal data from the device.

        This provides signal data from the device, like get_signal_bytes, but instead of all the
        data, it divides the data up into windows, and provides the minimum and maximum values for
        each window.

        This call is aimed at visualisations of data (ie: a traceviewer interface). As such, it does
        not provide most of the guarantees and options that get_signal_bytes() does. No bias voltage
        or channel configuration data is provided, it is not possible to set the number of samples
        desired up front (just cancel the call when no further data is required) and no guarantees
        are made about whether particular commands have been applied to the returned data.

        Also unlike get_signal_bytes(), the returned data is in native types, and does not require
        any further interpretation based on get_data_types(). This can be done performantly because
        of the reduced amount of data transmitted.

        The response will be streamed. In order to limit the size of each response message, any given
        message may include data from only a subset of the requested channels.

        This RPC has no side effects. Calling it will have no effect on the state of the
        system. It is safe to call repeatedly, or to retry on failure, although there is no
        guarantee it will return the same information each time.

        Args:
            _message (minknow_api.data_pb2.GetSignalMinMaxRequest, optional): The message to send.
                This can be passed instead of the keyword arguments.
            _timeout (float, optional): The call will be cancelled after this number of seconds
                if it has not been completed.
                Note that this is the time until the call ends, not the time between returned
                messages.
            first_channel (int): The first channel (inclusive) to return data for.

                Note that channel numbering starts at 1.
            last_channel (int): The last channel (inclusive) to return data for.

                Note that channel numbering starts at 1.
            window_size (int): The size of window to summarise.

                A value of zero will be rejected; there is no default.
            calibrated_data (bool, optional): Whether the data should be calibrated.

        Returns:
            iter of minknow_api.data_pb2.GetSignalMinMaxResponse

        Note that the returned messages are actually wrapped in a type that collapses
        submessages for fields marked with ``[rpc_unwrap]``.
        """
        if _message is not None:
            if isinstance(_message, MessageWrapper):
                _message = _message._message
            return run_with_retry(self._stub.get_signal_min_max,
                                  _message, _timeout,
                                  [],
                                  "minknow_api.data.DataService")

        unused_args = set(kwargs.keys())

        _message = GetSignalMinMaxRequest()

        if "first_channel" in kwargs:
            unused_args.remove("first_channel")
            _message.first_channel = kwargs['first_channel']
        else:
            raise ArgumentError("get_signal_min_max requires a 'first_channel' argument")

        if "last_channel" in kwargs:
            unused_args.remove("last_channel")
            _message.last_channel = kwargs['last_channel']
        else:
            raise ArgumentError("get_signal_min_max requires a 'last_channel' argument")

        if "window_size" in kwargs:
            unused_args.remove("window_size")
            _message.window_size = kwargs['window_size']
        else:
            raise ArgumentError("get_signal_min_max requires a 'window_size' argument")

        if "calibrated_data" in kwargs:
            unused_args.remove("calibrated_data")
            _message.calibrated_data = kwargs['calibrated_data']

        if len(unused_args) > 0:
            raise ArgumentError("Unexpected keyword arguments to get_signal_min_max: '{}'".format(", ".join(unused_args)))

        return run_with_retry(self._stub.get_signal_min_max,
                              _message, _timeout,
                              [],
                              "minknow_api.data.DataService")
    def reset_channel_states(self, _message=None, _timeout=None, **kwargs):
        """Call this to force re-evaluating the channel states. This will make sure the next
        channel state evaluated will be 'unclassified_following_reset'. If the analyser is behind,
        and older data will come for evaluation, it will result in changing the state to 'pending_manual_reset'.
        So tipically, after a resetting the channel states, the user would see in the bulk file
        'unclassified_following_reset', 'pending_manual_reset', 'pending_manual_reset', until the relevant data
        comes through to the analyser and it will start outputting the normal channel states again.
        If the analyser is not behind, the user should ideally see just the 'unclassified_following_reset' state.

        This call is blocking - it will return from the rpc when it would have processed the
        'unclassified_following_reset' in the analyser. If the rpc takes more than 1 minute
        it will exit with the ABORTED status. This can happen if the analyser is more than 1 minute behind
        for example (in practice it shouldn't be the case). If the RPC exits with the ABORT status, it means
        the channels are to be reset in the future, but the analyser did not reach that point yet.

        Only one of these can be executed at a given time. If multiple threads call this simultaneously,
        it will execute the first request and it will exit with FAILED_PRECONDITION for the rest. If an RPC
        exited with the ABORT status, another RPC can immediately be started. The failed RPC would have not
        reset the channel states, and the user could try again. The second RPC will return as soon as the first
        reset happens, so this will not be necessarily waiting for the second acquisition index to be
        processed.

        

        Args:
            _message (minknow_api.data_pb2.ResetChannelStatesRequest, optional): The message to send.
                This can be passed instead of the keyword arguments.
            _timeout (float, optional): The call will be cancelled after this number of seconds
                if it has not been completed.

        Returns:
            minknow_api.data_pb2.ResetChannelStatesResponse

        Note that the returned messages are actually wrapped in a type that collapses
        submessages for fields marked with ``[rpc_unwrap]``.
        """
        if _message is not None:
            if isinstance(_message, MessageWrapper):
                _message = _message._message
            return run_with_retry(self._stub.reset_channel_states,
                                  _message, _timeout,
                                  [],
                                  "minknow_api.data.DataService")

        unused_args = set(kwargs.keys())

        _message = ResetChannelStatesRequest()

        if len(unused_args) > 0:
            raise ArgumentError("Unexpected keyword arguments to reset_channel_states: '{}'".format(", ".join(unused_args)))

        return run_with_retry(self._stub.reset_channel_states,
                              _message, _timeout,
                              [],
                              "minknow_api.data.DataService")
    def lock_channel_states(self, _message=None, _timeout=None, **kwargs):
        """Forces channels to be fixed on a custom channel state. The channels will not be re-evaluated until
        they are activated using unlock_channel_states.
        To create a channel state that will never be entered unless manually set using this call,
        use the "never_evaluated" criteria:
        "9": { "group": {...},
               "logic": {
                   "rank": 0,
                   "criteria": "never_evaluated"
                    },
                "name": "custom_name_picked_by_the_user"
              }

        While the this RPC has the power of forcing a channel to any valid state other than 'unclassified',
        it is intended to be used with channel states that are designed for this functionality (i.e. that
        are never evaluated).
        Has to be called while acquiring data, fails otherwise.
        The forced channels are reset (reset = every channel back to being evaluated) every time a
        new acquisition sequence is started.

        NOTE:
        Calls to lock_channel_states and unlock_channel_states cannot be done in the same time.
        If any of these two is called while any of these is already running, the grpc will return
        with an error.

        

        Args:
            _message (minknow_api.data_pb2.LockChannelStatesRequest, optional): The message to send.
                This can be passed instead of the keyword arguments.
            _timeout (float, optional): The call will be cancelled after this number of seconds
                if it has not been completed.
            channels (int): The channels that we want to 'deactivate' = set them to the given state until we re-activate them
                with unlock_channel_states
                If the channels are already deactivated, it will update the state to the new forced state given (if different).
                Channels are indexed from 1.
            state_name (str): Channel state name as specified in the channel state configuration.
                It HAS to be different to 'unclassified', which denotes that the channel is active, but had not met
                any successful criteria yet.

        Returns:
            minknow_api.data_pb2.LockChannelStatesResponse

        Note that the returned messages are actually wrapped in a type that collapses
        submessages for fields marked with ``[rpc_unwrap]``.
        """
        if _message is not None:
            if isinstance(_message, MessageWrapper):
                _message = _message._message
            return run_with_retry(self._stub.lock_channel_states,
                                  _message, _timeout,
                                  [],
                                  "minknow_api.data.DataService")

        unused_args = set(kwargs.keys())

        _message = LockChannelStatesRequest()

        if "channels" in kwargs:
            unused_args.remove("channels")
            _message.channels.extend(kwargs['channels'])
        else:
            raise ArgumentError("lock_channel_states requires a 'channels' argument")

        if "state_name" in kwargs:
            unused_args.remove("state_name")
            _message.state_name = kwargs['state_name']
        else:
            raise ArgumentError("lock_channel_states requires a 'state_name' argument")

        if len(unused_args) > 0:
            raise ArgumentError("Unexpected keyword arguments to lock_channel_states: '{}'".format(", ".join(unused_args)))

        return run_with_retry(self._stub.lock_channel_states,
                              _message, _timeout,
                              [],
                              "minknow_api.data.DataService")
    def unlock_channel_states(self, _message=None, _timeout=None, **kwargs):
        """Re-activates channels that have been turned-off with force_channels_to_state.
        Note that 'turning off' refers to channel states only, everything else is still applied on the channel
        (e.g. mux changes, saturation, commands etc)
        No action is taken if the channel is already active.
        Has to be called while acquiring data, fails otherwise.
        NOTE:
        Calls to lock_channel_states and unlock_channel_states cannot be done in the same time.
        If any of these two is called while any of these is already running, the grpc will return
        with an error.

        

        Args:
            _message (minknow_api.data_pb2.UnlockChannelStatesRequest, optional): The message to send.
                This can be passed instead of the keyword arguments.
            _timeout (float, optional): The call will be cancelled after this number of seconds
                if it has not been completed.
            channels (int): The channels to activate (active = they will be considered for channel state evaluation in the future).
                Channels are indexed from 1.

        Returns:
            minknow_api.data_pb2.UnlockChannelStatesResponse

        Note that the returned messages are actually wrapped in a type that collapses
        submessages for fields marked with ``[rpc_unwrap]``.
        """
        if _message is not None:
            if isinstance(_message, MessageWrapper):
                _message = _message._message
            return run_with_retry(self._stub.unlock_channel_states,
                                  _message, _timeout,
                                  [],
                                  "minknow_api.data.DataService")

        unused_args = set(kwargs.keys())

        _message = UnlockChannelStatesRequest()

        if "channels" in kwargs:
            unused_args.remove("channels")
            _message.channels.extend(kwargs['channels'])
        else:
            raise ArgumentError("unlock_channel_states requires a 'channels' argument")

        if len(unused_args) > 0:
            raise ArgumentError("Unexpected keyword arguments to unlock_channel_states: '{}'".format(", ".join(unused_args)))

        return run_with_retry(self._stub.unlock_channel_states,
                              _message, _timeout,
                              [],
                              "minknow_api.data.DataService")
    def get_live_reads(self, iterator):
        """Get live reads sent in order to control sequencing behaviour.

        This method sends current reads (reads that are currently in the sequencer) to the user along
        with live analysis data in order for real time decisions to be made.

        The method provides two streams:

        GetLiveReadsRequest stream:
             Sent by the user, provides MinKNOW with actions to take on current reads, actions
             taken are sumarised and sent back to the user in the GetLiveReadsResponse stream.
        GetLiveReadsResponse stream:
             Sent to the user, contains a stream of ongoing sequencing information, sent as
             regularly as possible, with information on reads in progress, and feedback on actions
             taken on the data.

        note: This method operates on read chunks in MinKNOW, and will send at minimum, 1 read
        chunk to the user. In order to reduce latency on the method, tune the following options:

        The raw chunk size data is processed in minknow (specified in samples):
             app_conf/hyperstream.raw_data_intermediate.size
             app_conf/hyperstream.raw_meta_data_intermediate.size

        The maximum read chunk size - changing the size read chunks are processed in minknow:
             analysis_conf/read_detection.break_reads_after_seconds

        This RPC has no side effects. Calling it will have no effect on the state of the
        system. It is safe to call repeatedly, or to retry on failure, although there is no
        guarantee it will return the same information each time.

        Args:
            iterator (iter of minknow_api.data_pb2.GetLiveReadsRequest): An interable that
                yields the messages to send.

        Returns:
            iter of minknow_api.data_pb2.GetLiveReadsResponse

        Note that the returned messages are actually wrapped in a type that collapses
        submessages for fields marked with ``[rpc_unwrap]``.
        """
        return self._stub.get_live_reads(iterator)
    def get_read_statistics(self, _message=None, _timeout=None, **kwargs):
        """Collects statistics about read (chunk) lengths and signal, split by channel, channel
        configuration and read (chunk) classification.

        This RPC has no side effects. Calling it will have no effect on the state of the
        system. It is safe to call repeatedly, or to retry on failure, although there is no
        guarantee it will return the same information each time.

        Args:
            _message (minknow_api.data_pb2.GetReadStatisticsRequest, optional): The message to send.
                This can be passed instead of the keyword arguments.
            _timeout (float, optional): The call will be cancelled after this number of seconds
                if it has not been completed.
            channels (int, optional): List of channels required, indexed from 1.
            seconds (float, optional): 
            samples (int, optional): 
            read_split (minknow_api.data_pb2.GetReadStatisticsRequest.ReadSplit): 
            no_current_statistics (bool, optional): Disable current_statistics results in returned data.

                Intended for use when the consumer doesn't need specific fields
                allowing the implementation to be more efficient.
            no_chunk_statistics (bool, optional): Disable chunk_statistics results in returned data.

                Intended for use when the consumer doesn't need specific fields
                allowing the implementation to be more efficient.
            required_classifications (str, optional): Specify classifications which the user wants information about.

                The default behaviour (when empty) is to return information on all classifications.

                Specifying which classifications the user needs information about may allow
                the implementation to be more efficient.

        Returns:
            minknow_api.data_pb2.GetReadStatisticsResponse

        Note that the returned messages are actually wrapped in a type that collapses
        submessages for fields marked with ``[rpc_unwrap]``.
        """
        if _message is not None:
            if isinstance(_message, MessageWrapper):
                _message = _message._message
            return run_with_retry(self._stub.get_read_statistics,
                                  _message, _timeout,
                                  [],
                                  "minknow_api.data.DataService")

        unused_args = set(kwargs.keys())

        # check oneof group 'duration'
        oneof_fields = set([
            "seconds",
            "samples",
        ])

        if len(unused_args & oneof_fields) > 1:
            raise ArgumentError("get_read_statistics given multiple conflicting arguments: '{}'".format(", ".join(unused_args & oneof_fields)))

        _message = GetReadStatisticsRequest()

        if "channels" in kwargs:
            unused_args.remove("channels")
            _message.channels.extend(kwargs['channels'])

        if "seconds" in kwargs:
            unused_args.remove("seconds")
            _message.seconds = kwargs['seconds']

        if "samples" in kwargs:
            unused_args.remove("samples")
            _message.samples = kwargs['samples']

        if "read_split" in kwargs:
            unused_args.remove("read_split")
            _message.read_split = kwargs['read_split']
        else:
            raise ArgumentError("get_read_statistics requires a 'read_split' argument")

        if "no_current_statistics" in kwargs:
            unused_args.remove("no_current_statistics")
            _message.no_current_statistics = kwargs['no_current_statistics']

        if "no_chunk_statistics" in kwargs:
            unused_args.remove("no_chunk_statistics")
            _message.no_chunk_statistics = kwargs['no_chunk_statistics']

        if "required_classifications" in kwargs:
            unused_args.remove("required_classifications")
            _message.required_classifications.extend(kwargs['required_classifications'])

        if len(unused_args) > 0:
            raise ArgumentError("Unexpected keyword arguments to get_read_statistics: '{}'".format(", ".join(unused_args)))

        return run_with_retry(self._stub.get_read_statistics,
                              _message, _timeout,
                              [],
                              "minknow_api.data.DataService")
    def get_experiment_yield_info(self, _message=None, _timeout=None, **kwargs):
        """Returns various points of yield information for the ongoing experiment, such as complete
        read information and basecaller progress.

        This RPC has no side effects. Calling it will have no effect on the state of the
        system. It is safe to call repeatedly, or to retry on failure, although there is no
        guarantee it will return the same information each time.

        Args:
            _message (minknow_api.data_pb2.GetExperimentYieldInfoRequest, optional): The message to send.
                This can be passed instead of the keyword arguments.
            _timeout (float, optional): The call will be cancelled after this number of seconds
                if it has not been completed.

        Returns:
            minknow_api.data_pb2.GetExperimentYieldInfoResponse

        Note that the returned messages are actually wrapped in a type that collapses
        submessages for fields marked with ``[rpc_unwrap]``.
        """
        if _message is not None:
            if isinstance(_message, MessageWrapper):
                _message = _message._message
            return run_with_retry(self._stub.get_experiment_yield_info,
                                  _message, _timeout,
                                  [],
                                  "minknow_api.data.DataService")

        unused_args = set(kwargs.keys())

        _message = GetExperimentYieldInfoRequest()

        if len(unused_args) > 0:
            raise ArgumentError("Unexpected keyword arguments to get_experiment_yield_info: '{}'".format(", ".join(unused_args)))

        return run_with_retry(self._stub.get_experiment_yield_info,
                              _message, _timeout,
                              [],
                              "minknow_api.data.DataService")
