### THIS FILE IS AUTOGENERATED. DO NOT EDIT THIS FILE DIRECTLY ###
import minknow_api
from minknow_api.analysis_configuration_pb2_grpc import *
import minknow_api.analysis_configuration_pb2 as analysis_configuration_pb2
from minknow_api.analysis_configuration_pb2 import *
from minknow_api._support import MessageWrapper, ArgumentError
import time
import logging
import sys

__all__ = [
    "AnalysisConfigurationService",
    "EventDetection",
    "ReadDetectionParams",
    "ReadFilters",
    "ReadClassificationParams",
    "ChannelStates",
    "GetAnalysisConfigurationRequest",
    "AnalysisConfiguration",
    "SetAnalysisConfigurationResponse",
    "ResetAnalysisConfigurationRequest",
    "ResetAnalysisConfigurationResponse",
    "SetAnalysisEnabledStateRequest",
    "SetAnalysisEnabledStateResponse",
    "GetChannelStatesDescRequest",
    "GetChannelStatesDescResponse",
    "GetSummaryRequest",
    "GetSummaryResponse",
    "BarcodingConfiguration",
    "AlignmentConfiguration",
    "LampConfiguration",
    "BasecallerConfiguration",
    "SetBasecallerConfigurationRequest",
    "SetBasecallerConfigurationResponse",
    "GetBasecallerConfigurationRequest",
    "GetPoreTypeConfigurationRequest",
    "PoreTypeConfiguration",
    "SetPoreTypeConfigurationResponse",
    "WriterConfiguration",
    "SetWriterConfigurationResponse",
    "GetWriterConfigurationRequest",
    "GetReadClassificationsRequest",
    "GetReadClassificationsResponse",
]

def run_with_retry(method, message, timeout, unwraps, full_name):
    retry_count = 20
    error = None
    for i in range(retry_count):
        try:
            result = MessageWrapper(method(message, timeout=timeout), unwraps=unwraps)
            return result
        except grpc.RpcError as e:
            # Retrying unidentified grpc errors to keep clients from crashing
            retryable_error = (e.code() == grpc.StatusCode.UNKNOWN and "Stream removed" in e.details() or \
                                (e.code() == grpc.StatusCode.INTERNAL and "RST_STREAM" in e.details()))
            if retryable_error:
                logging.info('Bypassed ({}: {}) error for grpc: {}. Attempt {}.'.format(e.code(), e.details(), full_name, i))
            else:
                raise
            error = e
        time.sleep(1)
    raise error


class AnalysisConfigurationService(object):
    def __init__(self, channel):
        self._stub = AnalysisConfigurationServiceStub(channel)
        self._pb = analysis_configuration_pb2
    def get_analysis_configuration(self, _message=None, _timeout=None, **kwargs):
        """Get the analysis configuration

        This RPC has no side effects. Calling it will have no effect on the state of the
        system. It is safe to call repeatedly, or to retry on failure, although there is no
        guarantee it will return the same information each time.

        Args:
            _message (minknow_api.analysis_configuration_pb2.GetAnalysisConfigurationRequest, optional): The message to send.
                This can be passed instead of the keyword arguments.
            _timeout (float, optional): The call will be cancelled after this number of seconds
                if it has not been completed.

        Returns:
            minknow_api.analysis_configuration_pb2.AnalysisConfiguration

        Note that the returned messages are actually wrapped in a type that collapses
        submessages for fields marked with ``[rpc_unwrap]``.
        """
        if _message is not None:
            if isinstance(_message, MessageWrapper):
                _message = _message._message
            return run_with_retry(self._stub.get_analysis_configuration,
                                  _message, _timeout,
                                  [],
                                  "minknow_api.analysis_configuration.AnalysisConfigurationService")

        unused_args = set(kwargs.keys())

        _message = GetAnalysisConfigurationRequest()

        if len(unused_args) > 0:
            raise ArgumentError("Unexpected keyword arguments to get_analysis_configuration: '{}'".format(", ".join(unused_args)))

        return run_with_retry(self._stub.get_analysis_configuration,
                              _message, _timeout,
                              [],
                              "minknow_api.analysis_configuration.AnalysisConfigurationService")
    def set_analysis_configuration(self, _message=None, _timeout=None, **kwargs):
        """Sets the analysis configuration

        This sets the whole configuration as-is, so you have to specify the whole analysis configuration as any fields
        there previously will be overwritten. To preserve the current analysis configuration, use a get-modify-set
        approach. Use get_analysis_configuration to retrieve the current config and modify the fields on that copy.
        Then use this call to set the modified version.

        The AnalysisConfiguration message is converted to/from json in Minknow, but this will be removed from later
        versions of MinKNOW. The basecaller params are the first ones to move away from the jsn format. The old structure
        has been kept for backwards compatibility, but it will be removed.

        The AnalysisConfiguration message is intended to be used to convert easily from protobuf to json and back again.
        To convert from json to a protobuf message (assuming 'analysis_conf_json' holds the json data:

        >>> import minknow_api
        >>> from google.protobuf import json_format
        >>>
        >>> analysis_conf_pb = minknow_api.analysis_configuration_service.AnalysisConfiguration()
        >>> json_format.Parse(json.dumps(analysis_conf_json), analysis_conf_pb)

        To convert from a protobuf message to json:

        >>> json_data = json_format.MessageToJson(analysis_conf_resp, preserving_proto_field_name=True, including_default_value_fields=True)

        'preserving_proto_field_name' is needed because json_format will try convert keys to json-standard(?) format, like converting
        my_key to myKey, and the key names as seen in the protobuf file are important to minknow

        'including_default_value_fields' is needed because in proto3, primitive values that are default initialised (like a uint32 with value 0)
        will not be sent on the wire, so the value wouldn't appear when converting to json. In practice, most values are wrapper types and this
        field won't have an affect in wrapper types, but it does affect enum types as the default initailised value is the 0th enum.

        NOTE: if the analysis configuration was set using the new parameters (with the filename for basecalling config files), the old parameters
        from jsn will be ignored. So set_analysis_configuration must be used with either the old protobuf message for the basecaller parameters,
        or with the new one, but it cannot be used interleaved!

        This RPC is idempotent. It may change the state of the system, but if the requested
        change has already happened, it will not fail because of this, make any additional
        changes or return a different value.

        Args:
            _message (minknow_api.analysis_configuration_pb2.AnalysisConfiguration, optional): The message to send.
                This can be passed instead of the keyword arguments.
            _timeout (float, optional): The call will be cancelled after this number of seconds
                if it has not been completed.
            event_detection (minknow_api.analysis_configuration_pb2.EventDetection, optional): 
            read_detection (minknow_api.analysis_configuration_pb2.ReadDetectionParams, optional): 
            read_classification (minknow_api.analysis_configuration_pb2.ReadClassificationParams, optional): 
            channel_states (minknow_api.analysis_configuration_pb2.AnalysisConfiguration.ChannelStatesEntry, optional): 

        Returns:
            minknow_api.analysis_configuration_pb2.SetAnalysisConfigurationResponse

        Note that the returned messages are actually wrapped in a type that collapses
        submessages for fields marked with ``[rpc_unwrap]``.
        """
        if _message is not None:
            if isinstance(_message, MessageWrapper):
                _message = _message._message
            return run_with_retry(self._stub.set_analysis_configuration,
                                  _message, _timeout,
                                  [],
                                  "minknow_api.analysis_configuration.AnalysisConfigurationService")

        unused_args = set(kwargs.keys())

        _message = AnalysisConfiguration()

        if "event_detection" in kwargs:
            unused_args.remove("event_detection")
            _message.event_detection.CopyFrom(kwargs['event_detection'])

        if "read_detection" in kwargs:
            unused_args.remove("read_detection")
            _message.read_detection.CopyFrom(kwargs['read_detection'])

        if "read_classification" in kwargs:
            unused_args.remove("read_classification")
            _message.read_classification.CopyFrom(kwargs['read_classification'])

        if "channel_states" in kwargs:
            unused_args.remove("channel_states")
            for key, value in kwargs['channel_states'].items():
                _message.channel_states[key].CopyFrom(value)

        if len(unused_args) > 0:
            raise ArgumentError("Unexpected keyword arguments to set_analysis_configuration: '{}'".format(", ".join(unused_args)))

        return run_with_retry(self._stub.set_analysis_configuration,
                              _message, _timeout,
                              [],
                              "minknow_api.analysis_configuration.AnalysisConfigurationService")
    def reset_analysis_configuration(self, _message=None, _timeout=None, **kwargs):
        """Reset the analysis configuration

        The configuration will be set to the initial default configuration that was set on boot

        Since 3.0

        This RPC is idempotent. It may change the state of the system, but if the requested
        change has already happened, it will not fail because of this, make any additional
        changes or return a different value.

        Args:
            _message (minknow_api.analysis_configuration_pb2.ResetAnalysisConfigurationRequest, optional): The message to send.
                This can be passed instead of the keyword arguments.
            _timeout (float, optional): The call will be cancelled after this number of seconds
                if it has not been completed.

        Returns:
            minknow_api.analysis_configuration_pb2.ResetAnalysisConfigurationResponse

        Note that the returned messages are actually wrapped in a type that collapses
        submessages for fields marked with ``[rpc_unwrap]``.
        """
        if _message is not None:
            if isinstance(_message, MessageWrapper):
                _message = _message._message
            return run_with_retry(self._stub.reset_analysis_configuration,
                                  _message, _timeout,
                                  [],
                                  "minknow_api.analysis_configuration.AnalysisConfigurationService")

        unused_args = set(kwargs.keys())

        _message = ResetAnalysisConfigurationRequest()

        if len(unused_args) > 0:
            raise ArgumentError("Unexpected keyword arguments to reset_analysis_configuration: '{}'".format(", ".join(unused_args)))

        return run_with_retry(self._stub.reset_analysis_configuration,
                              _message, _timeout,
                              [],
                              "minknow_api.analysis_configuration.AnalysisConfigurationService")
    def set_analysis_enabled_state(self, _message=None, _timeout=None, **kwargs):
        """Enable or disable analysis entirely.

        This RPC is idempotent. It may change the state of the system, but if the requested
        change has already happened, it will not fail because of this, make any additional
        changes or return a different value.

        Args:
            _message (minknow_api.analysis_configuration_pb2.SetAnalysisEnabledStateRequest, optional): The message to send.
                This can be passed instead of the keyword arguments.
            _timeout (float, optional): The call will be cancelled after this number of seconds
                if it has not been completed.
            enable (bool): 

        Returns:
            minknow_api.analysis_configuration_pb2.SetAnalysisEnabledStateResponse

        Note that the returned messages are actually wrapped in a type that collapses
        submessages for fields marked with ``[rpc_unwrap]``.
        """
        if _message is not None:
            if isinstance(_message, MessageWrapper):
                _message = _message._message
            return run_with_retry(self._stub.set_analysis_enabled_state,
                                  _message, _timeout,
                                  [],
                                  "minknow_api.analysis_configuration.AnalysisConfigurationService")

        unused_args = set(kwargs.keys())

        _message = SetAnalysisEnabledStateRequest()

        if "enable" in kwargs:
            unused_args.remove("enable")
            _message.enable = kwargs['enable']
        else:
            raise ArgumentError("set_analysis_enabled_state requires a 'enable' argument")

        if len(unused_args) > 0:
            raise ArgumentError("Unexpected keyword arguments to set_analysis_enabled_state: '{}'".format(", ".join(unused_args)))

        return run_with_retry(self._stub.set_analysis_enabled_state,
                              _message, _timeout,
                              [],
                              "minknow_api.analysis_configuration.AnalysisConfigurationService")
    def get_channel_states_desc(self, _message=None, _timeout=None, **kwargs):
        """Get a description of the possible channel states.

        This is a subset of the information included in the channel states section of the analysis
        configuration. It will change when the analysis configuration changes.

        This RPC has no side effects. Calling it will have no effect on the state of the
        system. It is safe to call repeatedly, or to retry on failure, although there is no
        guarantee it will return the same information each time.

        Args:
            _message (minknow_api.analysis_configuration_pb2.GetChannelStatesDescRequest, optional): The message to send.
                This can be passed instead of the keyword arguments.
            _timeout (float, optional): The call will be cancelled after this number of seconds
                if it has not been completed.

        Returns:
            minknow_api.analysis_configuration_pb2.GetChannelStatesDescResponse

        Note that the returned messages are actually wrapped in a type that collapses
        submessages for fields marked with ``[rpc_unwrap]``.
        """
        if _message is not None:
            if isinstance(_message, MessageWrapper):
                _message = _message._message
            return run_with_retry(self._stub.get_channel_states_desc,
                                  _message, _timeout,
                                  [],
                                  "minknow_api.analysis_configuration.AnalysisConfigurationService")

        unused_args = set(kwargs.keys())

        _message = GetChannelStatesDescRequest()

        if len(unused_args) > 0:
            raise ArgumentError("Unexpected keyword arguments to get_channel_states_desc: '{}'".format(", ".join(unused_args)))

        return run_with_retry(self._stub.get_channel_states_desc,
                              _message, _timeout,
                              [],
                              "minknow_api.analysis_configuration.AnalysisConfigurationService")
    def get_summary(self, _message=None, _timeout=None, **kwargs):
        """Get a brief summary of the analysis configuration.

        This is a high-level overview of what major parts of the analysis pipeline are enabled.

        This RPC has no side effects. Calling it will have no effect on the state of the
        system. It is safe to call repeatedly, or to retry on failure, although there is no
        guarantee it will return the same information each time.

        Args:
            _message (minknow_api.analysis_configuration_pb2.GetSummaryRequest, optional): The message to send.
                This can be passed instead of the keyword arguments.
            _timeout (float, optional): The call will be cancelled after this number of seconds
                if it has not been completed.

        Returns:
            minknow_api.analysis_configuration_pb2.GetSummaryResponse

        Note that the returned messages are actually wrapped in a type that collapses
        submessages for fields marked with ``[rpc_unwrap]``.
        """
        if _message is not None:
            if isinstance(_message, MessageWrapper):
                _message = _message._message
            return run_with_retry(self._stub.get_summary,
                                  _message, _timeout,
                                  [],
                                  "minknow_api.analysis_configuration.AnalysisConfigurationService")

        unused_args = set(kwargs.keys())

        _message = GetSummaryRequest()

        if len(unused_args) > 0:
            raise ArgumentError("Unexpected keyword arguments to get_summary: '{}'".format(", ".join(unused_args)))

        return run_with_retry(self._stub.get_summary,
                              _message, _timeout,
                              [],
                              "minknow_api.analysis_configuration.AnalysisConfigurationService")
    def set_basecaller_configuration(self, _message=None, _timeout=None, **kwargs):
        """Configure the basecaller which will run during acquisition.

        This rpc will result in an error if invoked during acquisition.

        By default no basecalling is performed (enable = false).

        Since 3.0

        This RPC is idempotent. It may change the state of the system, but if the requested
        change has already happened, it will not fail because of this, make any additional
        changes or return a different value.

        Args:
            _message (minknow_api.analysis_configuration_pb2.SetBasecallerConfigurationRequest, optional): The message to send.
                This can be passed instead of the keyword arguments.
            _timeout (float, optional): The call will be cancelled after this number of seconds
                if it has not been completed.
            enable (bool, optional): Choose if guppy is enabled or disabled.

                If set to false then no basecalling will take place, and the rest of the config is ignored.
            config_filename (str, optional): The Guppy cfg file with all the settings.

                Filename can be absolute, or a basename (eg dna_r9.4_450bps.cfg)
                which guppy should locate (see guppy application config entry: "data_path")
            read_filtering (minknow_api.analysis_configuration_pb2.BasecallerConfiguration.ReadFiltering, optional): Control how read filtering is applied to output of basecaller.

                If no filtering parameters are provided then reads will not
                be filtered.
            barcoding_configuration (minknow_api.analysis_configuration_pb2.BarcodingConfiguration, optional): Control the barcoding configuration.
                If no barcoding configuration is supplied, barcoding is disabled.

                Since 3.5
            target_filtering (minknow_api.analysis_configuration_pb2.BasecallerConfiguration.TargetFiltering, optional): Control how target filtering is applied to output of basecaller.

                If no filtering parameters are provided then reads will not
                be target-filtered.

                Since 3.7
            alignment_configuration (minknow_api.analysis_configuration_pb2.AlignmentConfiguration, optional): Alignment configuration parameters.
                If no configuration is specified alignment is disabled.

                Since 4.0
            lamp_configuration (minknow_api.analysis_configuration_pb2.LampConfiguration, optional): Lamp configuration parameters.
                If no configuration is specified lamp is disabled.

                Since 4.1
            enable_read_splitting (bool, optional): Enable read splitting in guppy.

                Since 4.5
            min_score_read_splitting (google.protobuf.wrappers_pb2.FloatValue, optional): Override score to use for guppy read splitting. If not specified a default value
                is used from guppy.

                Since 4.5

        Returns:
            minknow_api.analysis_configuration_pb2.SetBasecallerConfigurationResponse

        Note that the returned messages are actually wrapped in a type that collapses
        submessages for fields marked with ``[rpc_unwrap]``.
        """
        if _message is not None:
            if isinstance(_message, MessageWrapper):
                _message = _message._message
            return run_with_retry(self._stub.set_basecaller_configuration,
                                  _message, _timeout,
                                  [],
                                  "minknow_api.analysis_configuration.AnalysisConfigurationService")

        unused_args = set(kwargs.keys())

        _message = SetBasecallerConfigurationRequest()

        if "enable" in kwargs:
            unused_args.remove("enable")
            _message.configs.enable = kwargs['enable']

        if "config_filename" in kwargs:
            unused_args.remove("config_filename")
            _message.configs.config_filename = kwargs['config_filename']

        if "read_filtering" in kwargs:
            unused_args.remove("read_filtering")
            _message.configs.read_filtering.CopyFrom(kwargs['read_filtering'])

        if "barcoding_configuration" in kwargs:
            unused_args.remove("barcoding_configuration")
            _message.configs.barcoding_configuration.CopyFrom(kwargs['barcoding_configuration'])

        if "target_filtering" in kwargs:
            unused_args.remove("target_filtering")
            _message.configs.target_filtering.CopyFrom(kwargs['target_filtering'])

        if "alignment_configuration" in kwargs:
            unused_args.remove("alignment_configuration")
            _message.configs.alignment_configuration.CopyFrom(kwargs['alignment_configuration'])

        if "lamp_configuration" in kwargs:
            unused_args.remove("lamp_configuration")
            _message.configs.lamp_configuration.CopyFrom(kwargs['lamp_configuration'])

        if "enable_read_splitting" in kwargs:
            unused_args.remove("enable_read_splitting")
            _message.configs.enable_read_splitting = kwargs['enable_read_splitting']

        if "min_score_read_splitting" in kwargs:
            unused_args.remove("min_score_read_splitting")
            _message.configs.min_score_read_splitting.value = kwargs['min_score_read_splitting']

        if len(unused_args) > 0:
            raise ArgumentError("Unexpected keyword arguments to set_basecaller_configuration: '{}'".format(", ".join(unused_args)))

        return run_with_retry(self._stub.set_basecaller_configuration,
                              _message, _timeout,
                              [],
                              "minknow_api.analysis_configuration.AnalysisConfigurationService")
    def preload_basecaller_configuration(self, _message=None, _timeout=None, **kwargs):
        """Inform MinKNOW the passed basecall configuration will be used at some point in the future, and could be loaded now
        to reduce wait time in the future.

        This rpc will result in an error if invoked during acquisition.

        The call will block until any previous call to preload configs is complete, but does not block while the config
        is loaded, no errors are reported to the caller if the config is invalid.

        Since 4.1

        This RPC is idempotent. It may change the state of the system, but if the requested
        change has already happened, it will not fail because of this, make any additional
        changes or return a different value.

        Args:
            _message (minknow_api.analysis_configuration_pb2.SetBasecallerConfigurationRequest, optional): The message to send.
                This can be passed instead of the keyword arguments.
            _timeout (float, optional): The call will be cancelled after this number of seconds
                if it has not been completed.
            enable (bool, optional): Choose if guppy is enabled or disabled.

                If set to false then no basecalling will take place, and the rest of the config is ignored.
            config_filename (str, optional): The Guppy cfg file with all the settings.

                Filename can be absolute, or a basename (eg dna_r9.4_450bps.cfg)
                which guppy should locate (see guppy application config entry: "data_path")
            read_filtering (minknow_api.analysis_configuration_pb2.BasecallerConfiguration.ReadFiltering, optional): Control how read filtering is applied to output of basecaller.

                If no filtering parameters are provided then reads will not
                be filtered.
            barcoding_configuration (minknow_api.analysis_configuration_pb2.BarcodingConfiguration, optional): Control the barcoding configuration.
                If no barcoding configuration is supplied, barcoding is disabled.

                Since 3.5
            target_filtering (minknow_api.analysis_configuration_pb2.BasecallerConfiguration.TargetFiltering, optional): Control how target filtering is applied to output of basecaller.

                If no filtering parameters are provided then reads will not
                be target-filtered.

                Since 3.7
            alignment_configuration (minknow_api.analysis_configuration_pb2.AlignmentConfiguration, optional): Alignment configuration parameters.
                If no configuration is specified alignment is disabled.

                Since 4.0
            lamp_configuration (minknow_api.analysis_configuration_pb2.LampConfiguration, optional): Lamp configuration parameters.
                If no configuration is specified lamp is disabled.

                Since 4.1
            enable_read_splitting (bool, optional): Enable read splitting in guppy.

                Since 4.5
            min_score_read_splitting (google.protobuf.wrappers_pb2.FloatValue, optional): Override score to use for guppy read splitting. If not specified a default value
                is used from guppy.

                Since 4.5

        Returns:
            minknow_api.analysis_configuration_pb2.SetBasecallerConfigurationResponse

        Note that the returned messages are actually wrapped in a type that collapses
        submessages for fields marked with ``[rpc_unwrap]``.
        """
        if _message is not None:
            if isinstance(_message, MessageWrapper):
                _message = _message._message
            return run_with_retry(self._stub.preload_basecaller_configuration,
                                  _message, _timeout,
                                  [],
                                  "minknow_api.analysis_configuration.AnalysisConfigurationService")

        unused_args = set(kwargs.keys())

        _message = SetBasecallerConfigurationRequest()

        if "enable" in kwargs:
            unused_args.remove("enable")
            _message.configs.enable = kwargs['enable']

        if "config_filename" in kwargs:
            unused_args.remove("config_filename")
            _message.configs.config_filename = kwargs['config_filename']

        if "read_filtering" in kwargs:
            unused_args.remove("read_filtering")
            _message.configs.read_filtering.CopyFrom(kwargs['read_filtering'])

        if "barcoding_configuration" in kwargs:
            unused_args.remove("barcoding_configuration")
            _message.configs.barcoding_configuration.CopyFrom(kwargs['barcoding_configuration'])

        if "target_filtering" in kwargs:
            unused_args.remove("target_filtering")
            _message.configs.target_filtering.CopyFrom(kwargs['target_filtering'])

        if "alignment_configuration" in kwargs:
            unused_args.remove("alignment_configuration")
            _message.configs.alignment_configuration.CopyFrom(kwargs['alignment_configuration'])

        if "lamp_configuration" in kwargs:
            unused_args.remove("lamp_configuration")
            _message.configs.lamp_configuration.CopyFrom(kwargs['lamp_configuration'])

        if "enable_read_splitting" in kwargs:
            unused_args.remove("enable_read_splitting")
            _message.configs.enable_read_splitting = kwargs['enable_read_splitting']

        if "min_score_read_splitting" in kwargs:
            unused_args.remove("min_score_read_splitting")
            _message.configs.min_score_read_splitting.value = kwargs['min_score_read_splitting']

        if len(unused_args) > 0:
            raise ArgumentError("Unexpected keyword arguments to preload_basecaller_configuration: '{}'".format(", ".join(unused_args)))

        return run_with_retry(self._stub.preload_basecaller_configuration,
                              _message, _timeout,
                              [],
                              "minknow_api.analysis_configuration.AnalysisConfigurationService")
    def get_basecaller_configuration(self, _message=None, _timeout=None, **kwargs):
        """Find the current basecaller configuration (see #set_basecaller_configuration)

        Since 3.0

        This RPC has no side effects. Calling it will have no effect on the state of the
        system. It is safe to call repeatedly, or to retry on failure, although there is no
        guarantee it will return the same information each time.

        Args:
            _message (minknow_api.analysis_configuration_pb2.GetBasecallerConfigurationRequest, optional): The message to send.
                This can be passed instead of the keyword arguments.
            _timeout (float, optional): The call will be cancelled after this number of seconds
                if it has not been completed.

        Returns:
            minknow_api.analysis_configuration_pb2.BasecallerConfiguration

        Note that the returned messages are actually wrapped in a type that collapses
        submessages for fields marked with ``[rpc_unwrap]``.
        """
        if _message is not None:
            if isinstance(_message, MessageWrapper):
                _message = _message._message
            return run_with_retry(self._stub.get_basecaller_configuration,
                                  _message, _timeout,
                                  [],
                                  "minknow_api.analysis_configuration.AnalysisConfigurationService")

        unused_args = set(kwargs.keys())

        _message = GetBasecallerConfigurationRequest()

        if len(unused_args) > 0:
            raise ArgumentError("Unexpected keyword arguments to get_basecaller_configuration: '{}'".format(", ".join(unused_args)))

        return run_with_retry(self._stub.get_basecaller_configuration,
                              _message, _timeout,
                              [],
                              "minknow_api.analysis_configuration.AnalysisConfigurationService")
    def get_pore_type_configuration(self, _message=None, _timeout=None, **kwargs):
        """Get the pore type configuration

        Since 3.2

        This RPC has no side effects. Calling it will have no effect on the state of the
        system. It is safe to call repeatedly, or to retry on failure, although there is no
        guarantee it will return the same information each time.

        Args:
            _message (minknow_api.analysis_configuration_pb2.GetPoreTypeConfigurationRequest, optional): The message to send.
                This can be passed instead of the keyword arguments.
            _timeout (float, optional): The call will be cancelled after this number of seconds
                if it has not been completed.

        Returns:
            minknow_api.analysis_configuration_pb2.PoreTypeConfiguration

        Note that the returned messages are actually wrapped in a type that collapses
        submessages for fields marked with ``[rpc_unwrap]``.
        """
        if _message is not None:
            if isinstance(_message, MessageWrapper):
                _message = _message._message
            return run_with_retry(self._stub.get_pore_type_configuration,
                                  _message, _timeout,
                                  [],
                                  "minknow_api.analysis_configuration.AnalysisConfigurationService")

        unused_args = set(kwargs.keys())

        _message = GetPoreTypeConfigurationRequest()

        if len(unused_args) > 0:
            raise ArgumentError("Unexpected keyword arguments to get_pore_type_configuration: '{}'".format(", ".join(unused_args)))

        return run_with_retry(self._stub.get_pore_type_configuration,
                              _message, _timeout,
                              [],
                              "minknow_api.analysis_configuration.AnalysisConfigurationService")
    def set_pore_type_configuration(self, _message=None, _timeout=None, **kwargs):
        """Set the pore type configuration

        By default, the configuration for all wells is "not_set"
        (global_pore_type set to "not_set")

        This rpc will result in an error if new pore types are defined during acquisition.
        The pore type which is active on specific channel/well may be changed during acquisition.

        If an invalid PoreTypeConfiguration is supplied, an error will be returned
        Invalid PoreTypeConfiguration include those where:

         - No pore_type_config is set
         - A pore type is set to an empty string
         - A pore type is set to "invalid"

        If an error is returned, the pore type configuration is not updated.

        Since 3.2

        This RPC is idempotent. It may change the state of the system, but if the requested
        change has already happened, it will not fail because of this, make any additional
        changes or return a different value.

        Args:
            _message (minknow_api.analysis_configuration_pb2.PoreTypeConfiguration, optional): The message to send.
                This can be passed instead of the keyword arguments.
            _timeout (float, optional): The call will be cancelled after this number of seconds
                if it has not been completed.
            global_pore_type (str, optional): Set all channel/wells to one pore type.
            channel_well_pore_types (minknow_api.analysis_configuration_pb2.PoreTypeConfiguration.ChannelWellPoreTypeConfigurations, optional): Set channel/wells to different pore types.

                Pore types can be created without being used by adding an empty
                entry.

        Returns:
            minknow_api.analysis_configuration_pb2.SetPoreTypeConfigurationResponse

        Note that the returned messages are actually wrapped in a type that collapses
        submessages for fields marked with ``[rpc_unwrap]``.
        """
        if _message is not None:
            if isinstance(_message, MessageWrapper):
                _message = _message._message
            return run_with_retry(self._stub.set_pore_type_configuration,
                                  _message, _timeout,
                                  [],
                                  "minknow_api.analysis_configuration.AnalysisConfigurationService")

        unused_args = set(kwargs.keys())

        # check oneof group 'pore_type_config'
        oneof_fields = set([
            "global_pore_type",
            "channel_well_pore_types",
        ])

        if len(unused_args & oneof_fields) > 1:
            raise ArgumentError("set_pore_type_configuration given multiple conflicting arguments: '{}'".format(", ".join(unused_args & oneof_fields)))

        _message = PoreTypeConfiguration()

        if "global_pore_type" in kwargs:
            unused_args.remove("global_pore_type")
            _message.global_pore_type = kwargs['global_pore_type']

        if "channel_well_pore_types" in kwargs:
            unused_args.remove("channel_well_pore_types")
            _message.channel_well_pore_types.CopyFrom(kwargs['channel_well_pore_types'])

        if len(unused_args) > 0:
            raise ArgumentError("Unexpected keyword arguments to set_pore_type_configuration: '{}'".format(", ".join(unused_args)))

        return run_with_retry(self._stub.set_pore_type_configuration,
                              _message, _timeout,
                              [],
                              "minknow_api.analysis_configuration.AnalysisConfigurationService")
    def set_writer_configuration(self, _message=None, _timeout=None, **kwargs):
        """Set the writer configuration.

        Note: Calling this method overrides any previous settings stored for the writers.
        In order to preserve settings, you should call #get_writer_configuration, mutate
        the config, then call this method.

        Will fail with FAILED_PRECONDITION if acquisition is running.

        The default writer config is to write nothing to disk.

        Since 3.3

        This RPC is idempotent. It may change the state of the system, but if the requested
        change has already happened, it will not fail because of this, make any additional
        changes or return a different value.

        Args:
            _message (minknow_api.analysis_configuration_pb2.WriterConfiguration, optional): The message to send.
                This can be passed instead of the keyword arguments.
            _timeout (float, optional): The call will be cancelled after this number of seconds
                if it has not been completed.
            read_fast5 (minknow_api.analysis_configuration_pb2.WriterConfiguration.ReadFast5Configuration, optional): Configuration for the fast5 writer.

                If not specified, no multi fast5 outputs are generated.
            read_fastq (minknow_api.analysis_configuration_pb2.WriterConfiguration.ReadFastqConfiguration, optional): Configuration for the fastq writer.

                If not specified, no fastq outputs are generated.
            read_bam (minknow_api.analysis_configuration_pb2.WriterConfiguration.ReadBamConfiguration, optional): Configuration for the BAM writer.

                If not specified, no BAM outputs are generated.
            read_protobuf (minknow_api.analysis_configuration_pb2.WriterConfiguration.ReadProtobufConfiguration, optional): Configuration for the protobuf writer.

                If not specified, no protobuf outputs are generated.
            sequencing_summary (minknow_api.analysis_configuration_pb2.WriterConfiguration.SequencingSummaryConfiguration, optional): Configuration for Sequencing Summary file

                If not specified, no summary file is generated.
            bulk (minknow_api.analysis_configuration_pb2.WriterConfiguration.BulkConfiguration, optional): Configuration for the bulk writer.

                If not specified, a basic bulk output is generated.
            report (minknow_api.analysis_configuration_pb2.WriterConfiguration.ReportConfiguration, optional): Configuration for the report writer

                If acquisition.StartRequest.generate_report is set for the
                acquisition period, and empty paths (or no report config) are supplied
                for reports default paths are used.
            read_filters (minknow_api.analysis_configuration_pb2.ReadFilters, optional): Parameters for filtering reads for writing.  If not present, then
                no filtering will be applied, so no reads will be excluded.

        Returns:
            minknow_api.analysis_configuration_pb2.SetWriterConfigurationResponse

        Note that the returned messages are actually wrapped in a type that collapses
        submessages for fields marked with ``[rpc_unwrap]``.
        """
        if _message is not None:
            if isinstance(_message, MessageWrapper):
                _message = _message._message
            return run_with_retry(self._stub.set_writer_configuration,
                                  _message, _timeout,
                                  [],
                                  "minknow_api.analysis_configuration.AnalysisConfigurationService")

        unused_args = set(kwargs.keys())

        _message = WriterConfiguration()

        if "read_fast5" in kwargs:
            unused_args.remove("read_fast5")
            _message.read_fast5.CopyFrom(kwargs['read_fast5'])

        if "read_fastq" in kwargs:
            unused_args.remove("read_fastq")
            _message.read_fastq.CopyFrom(kwargs['read_fastq'])

        if "read_bam" in kwargs:
            unused_args.remove("read_bam")
            _message.read_bam.CopyFrom(kwargs['read_bam'])

        if "read_protobuf" in kwargs:
            unused_args.remove("read_protobuf")
            _message.read_protobuf.CopyFrom(kwargs['read_protobuf'])

        if "sequencing_summary" in kwargs:
            unused_args.remove("sequencing_summary")
            _message.sequencing_summary.CopyFrom(kwargs['sequencing_summary'])

        if "bulk" in kwargs:
            unused_args.remove("bulk")
            _message.bulk.CopyFrom(kwargs['bulk'])

        if "report" in kwargs:
            unused_args.remove("report")
            _message.report.CopyFrom(kwargs['report'])

        if "read_filters" in kwargs:
            unused_args.remove("read_filters")
            _message.read_filters.CopyFrom(kwargs['read_filters'])

        if len(unused_args) > 0:
            raise ArgumentError("Unexpected keyword arguments to set_writer_configuration: '{}'".format(", ".join(unused_args)))

        return run_with_retry(self._stub.set_writer_configuration,
                              _message, _timeout,
                              [],
                              "minknow_api.analysis_configuration.AnalysisConfigurationService")
    def get_writer_configuration(self, _message=None, _timeout=None, **kwargs):
        """Get the currently active writer configuration.

        Since 3.3

        This RPC has no side effects. Calling it will have no effect on the state of the
        system. It is safe to call repeatedly, or to retry on failure, although there is no
        guarantee it will return the same information each time.

        Args:
            _message (minknow_api.analysis_configuration_pb2.GetWriterConfigurationRequest, optional): The message to send.
                This can be passed instead of the keyword arguments.
            _timeout (float, optional): The call will be cancelled after this number of seconds
                if it has not been completed.

        Returns:
            minknow_api.analysis_configuration_pb2.WriterConfiguration

        Note that the returned messages are actually wrapped in a type that collapses
        submessages for fields marked with ``[rpc_unwrap]``.
        """
        if _message is not None:
            if isinstance(_message, MessageWrapper):
                _message = _message._message
            return run_with_retry(self._stub.get_writer_configuration,
                                  _message, _timeout,
                                  [],
                                  "minknow_api.analysis_configuration.AnalysisConfigurationService")

        unused_args = set(kwargs.keys())

        _message = GetWriterConfigurationRequest()

        if len(unused_args) > 0:
            raise ArgumentError("Unexpected keyword arguments to get_writer_configuration: '{}'".format(", ".join(unused_args)))

        return run_with_retry(self._stub.get_writer_configuration,
                              _message, _timeout,
                              [],
                              "minknow_api.analysis_configuration.AnalysisConfigurationService")
    def get_read_classifications(self, _message=None, _timeout=None, **kwargs):
        """Get a map of read classifications mapped to id (used internally in analysis).

        This will change when the analysis configuration changes.

        This RPC has no side effects. Calling it will have no effect on the state of the
        system. It is safe to call repeatedly, or to retry on failure, although there is no
        guarantee it will return the same information each time.

        Args:
            _message (minknow_api.analysis_configuration_pb2.GetReadClassificationsRequest, optional): The message to send.
                This can be passed instead of the keyword arguments.
            _timeout (float, optional): The call will be cancelled after this number of seconds
                if it has not been completed.

        Returns:
            minknow_api.analysis_configuration_pb2.GetReadClassificationsResponse

        Note that the returned messages are actually wrapped in a type that collapses
        submessages for fields marked with ``[rpc_unwrap]``.
        """
        if _message is not None:
            if isinstance(_message, MessageWrapper):
                _message = _message._message
            return run_with_retry(self._stub.get_read_classifications,
                                  _message, _timeout,
                                  [],
                                  "minknow_api.analysis_configuration.AnalysisConfigurationService")

        unused_args = set(kwargs.keys())

        _message = GetReadClassificationsRequest()

        if len(unused_args) > 0:
            raise ArgumentError("Unexpected keyword arguments to get_read_classifications: '{}'".format(", ".join(unused_args)))

        return run_with_retry(self._stub.get_read_classifications,
                              _message, _timeout,
                              [],
                              "minknow_api.analysis_configuration.AnalysisConfigurationService")
