import * as cxschema from '@aws-cdk/cloud-assembly-schema';
import { CloudArtifact } from '../cloud-artifact';
import { CloudAssembly } from '../cloud-assembly';
import { Environment } from '../environment';
/**
 * @stability stable
 */
export declare class CloudFormationStackArtifact extends CloudArtifact {
    /**
     * The file name of the template.
     *
     * @stability stable
     */
    readonly templateFile: string;
    /**
     * The original name as defined in the CDK app.
     *
     * @stability stable
     */
    readonly originalName: string;
    /**
     * Any assets associated with this stack.
     *
     * @stability stable
     */
    readonly assets: cxschema.AssetMetadataEntry[];
    /**
     * CloudFormation parameters to pass to the stack.
     *
     * @stability stable
     */
    readonly parameters: {
        [id: string]: string;
    };
    /**
     * CloudFormation tags to pass to the stack.
     *
     * @stability stable
     */
    readonly tags: {
        [id: string]: string;
    };
    /**
     * The physical name of this stack.
     *
     * @stability stable
     */
    readonly stackName: string;
    /**
     * A string that represents this stack.
     *
     * Should only be used in user interfaces.
     * If the stackName and artifactId are the same, it will just return that. Otherwise,
     * it will return something like "<artifactId> (<stackName>)"
     *
     * @stability stable
     */
    readonly displayName: string;
    /**
     * (deprecated) The physical name of this stack.
     *
     * @deprecated renamed to `stackName`
     */
    readonly name: string;
    /**
     * The environment into which to deploy this artifact.
     *
     * @stability stable
     */
    readonly environment: Environment;
    /**
     * The role that needs to be assumed to deploy the stack.
     *
     * @default - No role is assumed (current credentials are used)
     * @stability stable
     */
    readonly assumeRoleArn?: string;
    /**
     * External ID to use when assuming role for cloudformation deployments.
     *
     * @default - No external ID
     * @stability stable
     */
    readonly assumeRoleExternalId?: string;
    /**
     * The role that is passed to CloudFormation to execute the change set.
     *
     * @default - No role is passed (currently assumed role/credentials are used)
     * @stability stable
     */
    readonly cloudFormationExecutionRoleArn?: string;
    /**
     * If the stack template has already been included in the asset manifest, its asset URL.
     *
     * @default - Not uploaded yet, upload just before deploying
     * @stability stable
     */
    readonly stackTemplateAssetObjectUrl?: string;
    /**
     * Version of bootstrap stack required to deploy this stack.
     *
     * @default - No bootstrap stack required
     * @stability stable
     */
    readonly requiresBootstrapStackVersion?: number;
    /**
     * Name of SSM parameter with bootstrap stack version.
     *
     * @default - Discover SSM parameter by reading stack
     * @stability stable
     */
    readonly bootstrapStackVersionSsmParameter?: string;
    /**
     * Whether termination protection is enabled for this stack.
     *
     * @stability stable
     */
    readonly terminationProtection?: boolean;
    /**
     * Whether this stack should be validated by the CLI after synthesis.
     *
     * @default - false
     * @stability stable
     */
    readonly validateOnSynth?: boolean;
    private _template;
    /**
     * @stability stable
     */
    constructor(assembly: CloudAssembly, artifactId: string, artifact: cxschema.ArtifactManifest);
    /**
     * Full path to the template file.
     *
     * @stability stable
     */
    get templateFullPath(): string;
    /**
     * The CloudFormation template for this stack.
     *
     * @stability stable
     */
    get template(): any;
    private tagsFromMetadata;
}
