import * as cxschema from '@aws-cdk/cloud-assembly-schema';
import { CloudArtifact } from '../cloud-artifact';
import { CloudAssembly } from '../cloud-assembly';
/**
 * Asset manifest is a description of a set of assets which need to be built and published.
 *
 * @stability stable
 */
export declare class AssetManifestArtifact extends CloudArtifact {
    /**
     * The file name of the asset manifest.
     *
     * @stability stable
     */
    readonly file: string;
    /**
     * Version of bootstrap stack required to deploy this stack.
     *
     * @stability stable
     */
    readonly requiresBootstrapStackVersion: number;
    /**
     * Name of SSM parameter with bootstrap stack version.
     *
     * @default - Discover SSM parameter by reading stack
     * @stability stable
     */
    readonly bootstrapStackVersionSsmParameter?: string;
    /**
     * @stability stable
     */
    constructor(assembly: CloudAssembly, name: string, artifact: cxschema.ArtifactManifest);
}
