import { Construct } from 'constructs';
import { CfnElement } from './cfn-element';
import { IResolvable, IResolveContext } from './resolvable';
/**
 * @stability stable
 */
export interface CfnParameterProps {
    /**
     * The data type for the parameter (DataType).
     *
     * @default String
     * @stability stable
     */
    readonly type?: string;
    /**
     * A value of the appropriate type for the template to use if no value is specified when a stack is created.
     *
     * If you define constraints for the parameter, you must specify
     * a value that adheres to those constraints.
     *
     * @default - No default value for parameter.
     * @stability stable
     */
    readonly default?: any;
    /**
     * A regular expression that represents the patterns to allow for String types.
     *
     * @default - No constraints on patterns allowed for parameter.
     * @stability stable
     */
    readonly allowedPattern?: string;
    /**
     * An array containing the list of values allowed for the parameter.
     *
     * @default - No constraints on values allowed for parameter.
     * @stability stable
     */
    readonly allowedValues?: string[];
    /**
     * A string that explains a constraint when the constraint is violated.
     *
     * For example, without a constraint description, a parameter that has an allowed
     * pattern of [A-Za-z0-9]+ displays the following error message when the user specifies
     * an invalid value:
     *
     * @default - No description with customized error message when user specifies invalid values.
     * @stability stable
     */
    readonly constraintDescription?: string;
    /**
     * A string of up to 4000 characters that describes the parameter.
     *
     * @default - No description for the parameter.
     * @stability stable
     */
    readonly description?: string;
    /**
     * An integer value that determines the largest number of characters you want to allow for String types.
     *
     * @default - None.
     * @stability stable
     */
    readonly maxLength?: number;
    /**
     * A numeric value that determines the largest numeric value you want to allow for Number types.
     *
     * @default - None.
     * @stability stable
     */
    readonly maxValue?: number;
    /**
     * An integer value that determines the smallest number of characters you want to allow for String types.
     *
     * @default - None.
     * @stability stable
     */
    readonly minLength?: number;
    /**
     * A numeric value that determines the smallest numeric value you want to allow for Number types.
     *
     * @default - None.
     * @stability stable
     */
    readonly minValue?: number;
    /**
     * Whether to mask the parameter value when anyone makes a call that describes the stack.
     *
     * If you set the value to ``true``, the parameter value is masked with asterisks (``*****``).
     *
     * @default - Parameter values are not masked.
     * @stability stable
     */
    readonly noEcho?: boolean;
}
/**
 * A CloudFormation parameter.
 *
 * Use the optional Parameters section to customize your templates.
 * Parameters enable you to input custom values to your template each time you create or
 * update a stack.
 *
 * @stability stable
 */
export declare class CfnParameter extends CfnElement {
    private _type;
    private _default?;
    private _allowedPattern?;
    private _allowedValues?;
    private _constraintDescription?;
    private _description?;
    private _maxLength?;
    private _maxValue?;
    private _minLength?;
    private _minValue?;
    private _noEcho?;
    /**
     * Creates a parameter construct.
     *
     * Note that the name (logical ID) of the parameter will derive from it's `coname` and location
     * within the stack. Therefore, it is recommended that parameters are defined at the stack level.
     *
     * @param scope The parent construct.
     * @param props The parameter properties.
     * @stability stable
     */
    constructor(scope: Construct, id: string, props?: CfnParameterProps);
    /**
     * The data type for the parameter (DataType).
     *
     * @default String
     * @stability stable
     */
    get type(): string;
    /**
     * The data type for the parameter (DataType).
     *
     * @default String
     * @stability stable
     */
    set type(type: string);
    /**
     * A value of the appropriate type for the template to use if no value is specified when a stack is created.
     *
     * If you define constraints for the parameter, you must specify
     * a value that adheres to those constraints.
     *
     * @default - No default value for parameter.
     * @stability stable
     */
    get default(): any;
    /**
     * A value of the appropriate type for the template to use if no value is specified when a stack is created.
     *
     * If you define constraints for the parameter, you must specify
     * a value that adheres to those constraints.
     *
     * @default - No default value for parameter.
     * @stability stable
     */
    set default(value: any);
    /**
     * A regular expression that represents the patterns to allow for String types.
     *
     * @default - No constraints on patterns allowed for parameter.
     * @stability stable
     */
    get allowedPattern(): string | undefined;
    /**
     * A regular expression that represents the patterns to allow for String types.
     *
     * @default - No constraints on patterns allowed for parameter.
     * @stability stable
     */
    set allowedPattern(pattern: string | undefined);
    /**
     * An array containing the list of values allowed for the parameter.
     *
     * @default - No constraints on values allowed for parameter.
     * @stability stable
     */
    get allowedValues(): string[] | undefined;
    /**
     * An array containing the list of values allowed for the parameter.
     *
     * @default - No constraints on values allowed for parameter.
     * @stability stable
     */
    set allowedValues(values: string[] | undefined);
    /**
     * A string that explains a constraint when the constraint is violated.
     *
     * For example, without a constraint description, a parameter that has an allowed
     * pattern of [A-Za-z0-9]+ displays the following error message when the user specifies
     * an invalid value:
     *
     * @default - No description with customized error message when user specifies invalid values.
     * @stability stable
     */
    get constraintDescription(): string | undefined;
    /**
     * A string that explains a constraint when the constraint is violated.
     *
     * For example, without a constraint description, a parameter that has an allowed
     * pattern of [A-Za-z0-9]+ displays the following error message when the user specifies
     * an invalid value:
     *
     * @default - No description with customized error message when user specifies invalid values.
     * @stability stable
     */
    set constraintDescription(desc: string | undefined);
    /**
     * A string of up to 4000 characters that describes the parameter.
     *
     * @default - No description for the parameter.
     * @stability stable
     */
    get description(): string | undefined;
    /**
     * A string of up to 4000 characters that describes the parameter.
     *
     * @default - No description for the parameter.
     * @stability stable
     */
    set description(desc: string | undefined);
    /**
     * An integer value that determines the largest number of characters you want to allow for String types.
     *
     * @default - None.
     * @stability stable
     */
    get maxLength(): number | undefined;
    /**
     * An integer value that determines the largest number of characters you want to allow for String types.
     *
     * @default - None.
     * @stability stable
     */
    set maxLength(len: number | undefined);
    /**
     * An integer value that determines the smallest number of characters you want to allow for String types.
     *
     * @default - None.
     * @stability stable
     */
    get minLength(): number | undefined;
    /**
     * An integer value that determines the smallest number of characters you want to allow for String types.
     *
     * @default - None.
     * @stability stable
     */
    set minLength(len: number | undefined);
    /**
     * A numeric value that determines the largest numeric value you want to allow for Number types.
     *
     * @default - None.
     * @stability stable
     */
    get maxValue(): number | undefined;
    /**
     * A numeric value that determines the largest numeric value you want to allow for Number types.
     *
     * @default - None.
     * @stability stable
     */
    set maxValue(len: number | undefined);
    /**
     * A numeric value that determines the smallest numeric value you want to allow for Number types.
     *
     * @default - None.
     * @stability stable
     */
    get minValue(): number | undefined;
    /**
     * A numeric value that determines the smallest numeric value you want to allow for Number types.
     *
     * @default - None.
     * @stability stable
     */
    set minValue(len: number | undefined);
    /**
     * Indicates if this parameter is configured with "NoEcho" enabled.
     *
     * @stability stable
     */
    get noEcho(): boolean;
    /**
     * Indicates if this parameter is configured with "NoEcho" enabled.
     *
     * @stability stable
     */
    set noEcho(echo: boolean);
    /**
     * The parameter value as a Token.
     *
     * @stability stable
     */
    get value(): IResolvable;
    /**
     * The parameter value, if it represents a string.
     *
     * @stability stable
     */
    get valueAsString(): string;
    /**
     * The parameter value, if it represents a string list.
     *
     * @stability stable
     */
    get valueAsList(): string[];
    /**
     * The parameter value, if it represents a number.
     *
     * @stability stable
     */
    get valueAsNumber(): number;
    /**
     * @internal
     */
    _toCloudFormation(): object;
    /**
     * @stability stable
     */
    resolve(_context: IResolveContext): any;
}
