import numpy as np
from torch import nn

boost_locations = [
    (0.0, -4240.0, 70.0),
    (-1792.0, -4184.0, 70.0),
    (1792.0, -4184.0, 70.0),
    (-3072.0, -4096.0, 73.0),
    (3072.0, -4096.0, 73.0),
    (- 940.0, -3308.0, 70.0),
    (940.0, -3308.0, 70.0),
    (0.0, -2816.0, 70.0),
    (-3584.0, -2484.0, 70.0),
    (3584.0, -2484.0, 70.0),
    (-1788.0, -2300.0, 70.0),
    (1788.0, -2300.0, 70.0),
    (-2048.0, -1036.0, 70.0),
    (0.0, -1024.0, 70.0),
    (2048.0, -1036.0, 70.0),
    (-3584.0, 0.0, 73.0),
    (-1024.0, 0.0, 70.0),
    (1024.0, 0.0, 70.0),
    (3584.0, 0.0, 73.0),
    (-2048.0, 1036.0, 70.0),
    (0.0, 1024.0, 70.0),
    (2048.0, 1036.0, 70.0),
    (-1788.0, 2300.0, 70.0),
    (1788.0, 2300.0, 70.0),
    (-3584.0, 2484.0, 70.0),
    (3584.0, 2484.0, 70.0),
    (0.0, 2816.0, 70.0),
    (- 940.0, 3310.0, 70.0),
    (940.0, 3308.0, 70.0),
    (-3072.0, 4096.0, 73.0),
    (3072.0, 4096.0, 73.0),
    (-1792.0, 4184.0, 70.0),
    (1792.0, 4184.0, 70.0),
    (0.0, 4240.0, 70.0),
]


def rotator_to_matrix(yaw, pitch, roll):
    cr = np.cos(roll)
    sr = np.sin(roll)
    cp = np.cos(pitch)
    sp = np.sin(pitch)
    cy = np.cos(yaw)
    sy = np.sin(yaw)

    forward = [cp * cy, cp * sy, sp]
    left = [cy * sp * sr - cr * sy, sy * sp * sr + cr * cy, -cp * sr]
    up = [-cr * cy * sp - sr * sy, -cr * sy * sp + sr * cy, cp * cr]

    # forward = [cp * cy, cy * sp * sr - cr * sy, -cr * cy * sp - sr * sy]
    # right = [cp * sy, sy * sp * sr + cr * cy, -cr * sy * sp + sr * cy]
    # up = [sp, -cp * sr, cp * cr]
    return forward, up


class NGPModel(nn.Module):
    def __init__(self, earl):
        super().__init__()
        self.earl = earl
        self.score = nn.Linear(earl.n_dims, 2)

    def forward(self, *args, **kwargs):
        o = self.earl(*args, **kwargs)
        return self.score(o[:, 0, :])


def mlp(in_features, hidden_features, hidden_layers, out_features=None, activation=nn.ReLU):
    layers = [nn.Linear(in_features, hidden_features), activation()]
    for _ in range(hidden_layers):
        layers.extend([
            nn.Linear(hidden_features, hidden_features),
            activation()
        ])
    if out_features is not None:
        layers.append(nn.Linear(hidden_features, out_features))
    return nn.Sequential(*layers)
