"""Code complexity checking."""
from mccabe import McCabeChecker

from pylava.lint import Linter as Abstract
import ast


class Linter(Abstract):

    """Run complexity checking."""

    @staticmethod
    def run(path, code=None, params=None, **meta):
        """MCCabe code checking.

        :return list: List of errors.
        """
        tree = compile(code, path, "exec", ast.PyCF_ONLY_AST)

        McCabeChecker.max_complexity = int(params.get('complexity', 10))
        return [
            {'lnum': lineno, 'offset': offset, 'text': text, 'type': McCabeChecker._code}
            for lineno, offset, text, _ in McCabeChecker(tree, path).run()
        ]

#  pylava:ignore=W0212
