# coding: utf-8

"""


    Generated by: https://openapi-generator.tech
"""

from dataclasses import dataclass
import typing_extensions
import urllib3
from urllib3._collections import HTTPHeaderDict

from collibra_core import api_client, exceptions
from datetime import date, datetime  # noqa: F401
import decimal  # noqa: F401
import functools  # noqa: F401
import io  # noqa: F401
import re  # noqa: F401
import typing  # noqa: F401
import typing_extensions  # noqa: F401
import uuid  # noqa: F401

import frozendict  # noqa: F401

from collibra_core import schemas  # noqa: F401

from collibra_core.model.attribute_type_paged_response import AttributeTypePagedResponse

from . import path

# Query params
OffsetSchema = schemas.Int32Schema
LimitSchema = schemas.Int32Schema
CountLimitSchema = schemas.Int32Schema
NameSchema = schemas.StrSchema


class NameMatchModeSchema(
    schemas.EnumBase,
    schemas.StrSchema
):


    class MetaOapg:
        enum_value_to_name = {
            "START": "START",
            "END": "END",
            "ANYWHERE": "ANYWHERE",
            "EXACT": "EXACT",
        }
    
    @schemas.classproperty
    def START(cls):
        return cls("START")
    
    @schemas.classproperty
    def END(cls):
        return cls("END")
    
    @schemas.classproperty
    def ANYWHERE(cls):
        return cls("ANYWHERE")
    
    @schemas.classproperty
    def EXACT(cls):
        return cls("EXACT")


class KindSchema(
    schemas.EnumBase,
    schemas.StrSchema
):


    class MetaOapg:
        enum_value_to_name = {
            "BOOLEAN": "BOOLEAN",
            "STRING": "STRING",
            "NUMERIC": "NUMERIC",
            "DATE": "DATE",
            "SINGLE_VALUE_LIST": "SINGLE_VALUE_LIST",
            "MULTI_VALUE_LIST": "MULTI_VALUE_LIST",
            "SCRIPT": "SCRIPT",
        }
    
    @schemas.classproperty
    def BOOLEAN(cls):
        return cls("BOOLEAN")
    
    @schemas.classproperty
    def STRING(cls):
        return cls("STRING")
    
    @schemas.classproperty
    def NUMERIC(cls):
        return cls("NUMERIC")
    
    @schemas.classproperty
    def DATE(cls):
        return cls("DATE")
    
    @schemas.classproperty
    def SINGLE_VALUE_LIST(cls):
        return cls("SINGLE_VALUE_LIST")
    
    @schemas.classproperty
    def MULTI_VALUE_LIST(cls):
        return cls("MULTI_VALUE_LIST")
    
    @schemas.classproperty
    def SCRIPT(cls):
        return cls("SCRIPT")
LanguageSchema = schemas.StrSchema
StatisticsEnabledSchema = schemas.BoolSchema
IsIntegerSchema = schemas.BoolSchema


class SortFieldSchema(
    schemas.EnumBase,
    schemas.StrSchema
):


    class MetaOapg:
        enum_value_to_name = {
            "NAME": "NAME",
            "KIND": "KIND",
            "STATISTICS_ENABLED": "STATISTICS_ENABLED",
            "IS_INTEGER": "IS_INTEGER",
            "ALLOWED_VALUES": "ALLOWED_VALUES",
        }
    
    @schemas.classproperty
    def NAME(cls):
        return cls("NAME")
    
    @schemas.classproperty
    def KIND(cls):
        return cls("KIND")
    
    @schemas.classproperty
    def STATISTICS_ENABLED(cls):
        return cls("STATISTICS_ENABLED")
    
    @schemas.classproperty
    def IS_INTEGER(cls):
        return cls("IS_INTEGER")
    
    @schemas.classproperty
    def ALLOWED_VALUES(cls):
        return cls("ALLOWED_VALUES")


class SortOrderSchema(
    schemas.EnumBase,
    schemas.StrSchema
):


    class MetaOapg:
        enum_value_to_name = {
            "ASC": "ASC",
            "DESC": "DESC",
        }
    
    @schemas.classproperty
    def ASC(cls):
        return cls("ASC")
    
    @schemas.classproperty
    def DESC(cls):
        return cls("DESC")
RequestRequiredQueryParams = typing_extensions.TypedDict(
    'RequestRequiredQueryParams',
    {
    }
)
RequestOptionalQueryParams = typing_extensions.TypedDict(
    'RequestOptionalQueryParams',
    {
        'offset': typing.Union[OffsetSchema, decimal.Decimal, int, ],
        'limit': typing.Union[LimitSchema, decimal.Decimal, int, ],
        'countLimit': typing.Union[CountLimitSchema, decimal.Decimal, int, ],
        'name': typing.Union[NameSchema, str, ],
        'nameMatchMode': typing.Union[NameMatchModeSchema, str, ],
        'kind': typing.Union[KindSchema, str, ],
        'language': typing.Union[LanguageSchema, str, ],
        'statisticsEnabled': typing.Union[StatisticsEnabledSchema, bool, ],
        'isInteger': typing.Union[IsIntegerSchema, bool, ],
        'sortField': typing.Union[SortFieldSchema, str, ],
        'sortOrder': typing.Union[SortOrderSchema, str, ],
    },
    total=False
)


class RequestQueryParams(RequestRequiredQueryParams, RequestOptionalQueryParams):
    pass


request_query_offset = api_client.QueryParameter(
    name="offset",
    style=api_client.ParameterStyle.FORM,
    schema=OffsetSchema,
    explode=True,
)
request_query_limit = api_client.QueryParameter(
    name="limit",
    style=api_client.ParameterStyle.FORM,
    schema=LimitSchema,
    explode=True,
)
request_query_count_limit = api_client.QueryParameter(
    name="countLimit",
    style=api_client.ParameterStyle.FORM,
    schema=CountLimitSchema,
    explode=True,
)
request_query_name = api_client.QueryParameter(
    name="name",
    style=api_client.ParameterStyle.FORM,
    schema=NameSchema,
    explode=True,
)
request_query_name_match_mode = api_client.QueryParameter(
    name="nameMatchMode",
    style=api_client.ParameterStyle.FORM,
    schema=NameMatchModeSchema,
    explode=True,
)
request_query_kind = api_client.QueryParameter(
    name="kind",
    style=api_client.ParameterStyle.FORM,
    schema=KindSchema,
    explode=True,
)
request_query_language = api_client.QueryParameter(
    name="language",
    style=api_client.ParameterStyle.FORM,
    schema=LanguageSchema,
    explode=True,
)
request_query_statistics_enabled = api_client.QueryParameter(
    name="statisticsEnabled",
    style=api_client.ParameterStyle.FORM,
    schema=StatisticsEnabledSchema,
    explode=True,
)
request_query_is_integer = api_client.QueryParameter(
    name="isInteger",
    style=api_client.ParameterStyle.FORM,
    schema=IsIntegerSchema,
    explode=True,
)
request_query_sort_field = api_client.QueryParameter(
    name="sortField",
    style=api_client.ParameterStyle.FORM,
    schema=SortFieldSchema,
    explode=True,
)
request_query_sort_order = api_client.QueryParameter(
    name="sortOrder",
    style=api_client.ParameterStyle.FORM,
    schema=SortOrderSchema,
    explode=True,
)
_auth = [
    'basicAuth',
    'bearerAuth',
]
SchemaFor200ResponseBodyApplicationJson = AttributeTypePagedResponse


@dataclass
class ApiResponseFor200(api_client.ApiResponse):
    response: urllib3.HTTPResponse
    body: typing.Union[
        SchemaFor200ResponseBodyApplicationJson,
    ]
    headers: schemas.Unset = schemas.unset


_response_for_200 = api_client.OpenApiResponse(
    response_cls=ApiResponseFor200,
    content={
        'application/json': api_client.MediaType(
            schema=SchemaFor200ResponseBodyApplicationJson),
    },
)
_status_code_to_response = {
    '200': _response_for_200,
}
_all_accept_content_types = (
    'application/json',
)


class BaseApi(api_client.Api):
    @typing.overload
    def _find_attribute_types_oapg(
        self,
        query_params: RequestQueryParams = frozendict.frozendict(),
        accept_content_types: typing.Tuple[str] = _all_accept_content_types,
        stream: bool = False,
        timeout: typing.Optional[typing.Union[int, typing.Tuple]] = None,
        skip_deserialization: typing_extensions.Literal[False] = ...,
    ) -> typing.Union[
        ApiResponseFor200,
    ]: ...

    @typing.overload
    def _find_attribute_types_oapg(
        self,
        skip_deserialization: typing_extensions.Literal[True],
        query_params: RequestQueryParams = frozendict.frozendict(),
        accept_content_types: typing.Tuple[str] = _all_accept_content_types,
        stream: bool = False,
        timeout: typing.Optional[typing.Union[int, typing.Tuple]] = None,
    ) -> api_client.ApiResponseWithoutDeserialization: ...

    @typing.overload
    def _find_attribute_types_oapg(
        self,
        query_params: RequestQueryParams = frozendict.frozendict(),
        accept_content_types: typing.Tuple[str] = _all_accept_content_types,
        stream: bool = False,
        timeout: typing.Optional[typing.Union[int, typing.Tuple]] = None,
        skip_deserialization: bool = ...,
    ) -> typing.Union[
        ApiResponseFor200,
        api_client.ApiResponseWithoutDeserialization,
    ]: ...

    def _find_attribute_types_oapg(
        self,
        query_params: RequestQueryParams = frozendict.frozendict(),
        accept_content_types: typing.Tuple[str] = _all_accept_content_types,
        stream: bool = False,
        timeout: typing.Optional[typing.Union[int, typing.Tuple]] = None,
        skip_deserialization: bool = False,
    ):
        """
        Returns attribute types matching the given search criteria.
        :param skip_deserialization: If true then api_response.response will be set but
            api_response.body and api_response.headers will not be deserialized into schema
            class instances
        """
        self._verify_typed_dict_inputs_oapg(RequestQueryParams, query_params)
        used_path = path.value

        prefix_separator_iterator = None
        for parameter in (
            request_query_offset,
            request_query_limit,
            request_query_count_limit,
            request_query_name,
            request_query_name_match_mode,
            request_query_kind,
            request_query_language,
            request_query_statistics_enabled,
            request_query_is_integer,
            request_query_sort_field,
            request_query_sort_order,
        ):
            parameter_data = query_params.get(parameter.name, schemas.unset)
            if parameter_data is schemas.unset:
                continue
            if prefix_separator_iterator is None:
                prefix_separator_iterator = parameter.get_prefix_separator_iterator()
            serialized_data = parameter.serialize(parameter_data, prefix_separator_iterator)
            for serialized_value in serialized_data.values():
                used_path += serialized_value

        _headers = HTTPHeaderDict()
        # TODO add cookie handling
        if accept_content_types:
            for accept_content_type in accept_content_types:
                _headers.add('Accept', accept_content_type)

        response = self.api_client.call_api(
            resource_path=used_path,
            method='get'.upper(),
            headers=_headers,
            auth_settings=_auth,
            stream=stream,
            timeout=timeout,
        )

        if skip_deserialization:
            api_response = api_client.ApiResponseWithoutDeserialization(response=response)
        else:
            response_for_status = _status_code_to_response.get(str(response.status))
            if response_for_status:
                api_response = response_for_status.deserialize(response, self.api_client.configuration)
            else:
                api_response = api_client.ApiResponseWithoutDeserialization(response=response)

        if not 200 <= response.status <= 299:
            raise exceptions.ApiException(api_response=api_response)

        return api_response


class FindAttributeTypes(BaseApi):
    # this class is used by api classes that refer to endpoints with operationId fn names

    @typing.overload
    def find_attribute_types(
        self,
        query_params: RequestQueryParams = frozendict.frozendict(),
        accept_content_types: typing.Tuple[str] = _all_accept_content_types,
        stream: bool = False,
        timeout: typing.Optional[typing.Union[int, typing.Tuple]] = None,
        skip_deserialization: typing_extensions.Literal[False] = ...,
    ) -> typing.Union[
        ApiResponseFor200,
    ]: ...

    @typing.overload
    def find_attribute_types(
        self,
        skip_deserialization: typing_extensions.Literal[True],
        query_params: RequestQueryParams = frozendict.frozendict(),
        accept_content_types: typing.Tuple[str] = _all_accept_content_types,
        stream: bool = False,
        timeout: typing.Optional[typing.Union[int, typing.Tuple]] = None,
    ) -> api_client.ApiResponseWithoutDeserialization: ...

    @typing.overload
    def find_attribute_types(
        self,
        query_params: RequestQueryParams = frozendict.frozendict(),
        accept_content_types: typing.Tuple[str] = _all_accept_content_types,
        stream: bool = False,
        timeout: typing.Optional[typing.Union[int, typing.Tuple]] = None,
        skip_deserialization: bool = ...,
    ) -> typing.Union[
        ApiResponseFor200,
        api_client.ApiResponseWithoutDeserialization,
    ]: ...

    def find_attribute_types(
        self,
        query_params: RequestQueryParams = frozendict.frozendict(),
        accept_content_types: typing.Tuple[str] = _all_accept_content_types,
        stream: bool = False,
        timeout: typing.Optional[typing.Union[int, typing.Tuple]] = None,
        skip_deserialization: bool = False,
    ):
        return self._find_attribute_types_oapg(
            query_params=query_params,
            accept_content_types=accept_content_types,
            stream=stream,
            timeout=timeout,
            skip_deserialization=skip_deserialization
        )


class ApiForget(BaseApi):
    # this class is used by api classes that refer to endpoints by path and http method names

    @typing.overload
    def get(
        self,
        query_params: RequestQueryParams = frozendict.frozendict(),
        accept_content_types: typing.Tuple[str] = _all_accept_content_types,
        stream: bool = False,
        timeout: typing.Optional[typing.Union[int, typing.Tuple]] = None,
        skip_deserialization: typing_extensions.Literal[False] = ...,
    ) -> typing.Union[
        ApiResponseFor200,
    ]: ...

    @typing.overload
    def get(
        self,
        skip_deserialization: typing_extensions.Literal[True],
        query_params: RequestQueryParams = frozendict.frozendict(),
        accept_content_types: typing.Tuple[str] = _all_accept_content_types,
        stream: bool = False,
        timeout: typing.Optional[typing.Union[int, typing.Tuple]] = None,
    ) -> api_client.ApiResponseWithoutDeserialization: ...

    @typing.overload
    def get(
        self,
        query_params: RequestQueryParams = frozendict.frozendict(),
        accept_content_types: typing.Tuple[str] = _all_accept_content_types,
        stream: bool = False,
        timeout: typing.Optional[typing.Union[int, typing.Tuple]] = None,
        skip_deserialization: bool = ...,
    ) -> typing.Union[
        ApiResponseFor200,
        api_client.ApiResponseWithoutDeserialization,
    ]: ...

    def get(
        self,
        query_params: RequestQueryParams = frozendict.frozendict(),
        accept_content_types: typing.Tuple[str] = _all_accept_content_types,
        stream: bool = False,
        timeout: typing.Optional[typing.Union[int, typing.Tuple]] = None,
        skip_deserialization: bool = False,
    ):
        return self._find_attribute_types_oapg(
            query_params=query_params,
            accept_content_types=accept_content_types,
            stream=stream,
            timeout=timeout,
            skip_deserialization=skip_deserialization
        )


