# do not import all endpoints into this module because that uses a lot of memory and stack frames
# if you need the ability to import all endpoints from this module, import them with
# from collibra_core.apis.path_to_api import path_to_api

import enum


class PathValues(str, enum.Enum):
    ACTIVITIES = "/activities"
    APPLICATION_INFO = "/application/info"
    ASSIGNMENTS = "/assignments"
    ASSIGNMENTS_ASSIGNMENT_ID = "/assignments/{assignmentId}"
    ASSIGNMENTS_FOR_RESOURCE = "/assignments/forResource"
    ASSIGNMENTS_ASSET_ASSET_ID = "/assignments/asset/{assetId}"
    ASSIGNMENTS_ASSET_TYPE_ASSET_TYPE_ID = "/assignments/assetType/{assetTypeId}"
    ASSIGNMENTS_DOMAIN_DOMAIN_ID_ASSET_TYPES = "/assignments/domain/{domainId}/assetTypes"
    ASSIGNMENTS_ASSET_ASSET_ID_ATTRIBUTE_TYPES = "/assignments/asset/{assetId}/attributeTypes"
    ASSIGNMENTS_ASSET_ASSET_ID_COMPLEX_RELATION_TYPES = "/assignments/asset/{assetId}/complexRelationTypes"
    ASSIGNMENTS_ASSET_ASSET_ID_RELATION_TYPES = "/assignments/asset/{assetId}/relationTypes"
    SCOPES = "/scopes"
    SCOPES_SCOPE_ID = "/scopes/{scopeId}"
    DIAGRAM_PICTURES = "/diagramPictures"
    FILES = "/files"
    FILES_FILE_ID = "/files/{fileId}"
    FILES_FILE_ID_INFO = "/files/{fileId}/info"
    ASSETS = "/assets"
    ASSETS_BULK = "/assets/bulk"
    ASSETS_ASSET_ID_TAGS = "/assets/{assetId}/tags"
    ASSETS_ASSET_ID = "/assets/{assetId}"
    ASSETS_ASSET_ID_BREADCRUMB = "/assets/{assetId}/breadcrumb"
    ASSETS_ASSET_ID_ATTRIBUTES = "/assets/{assetId}/attributes"
    ASSETS_ASSET_ID_RELATIONS = "/assets/{assetId}/relations"
    ASSETS_ASSET_ID_RESPONSIBILITIES = "/assets/{assetId}/responsibilities"
    ATTACHMENTS = "/attachments"
    ATTACHMENTS_ATTACHMENT_ID = "/attachments/{attachmentId}"
    ATTACHMENTS_ATTACHMENT_ID_FILE = "/attachments/{attachmentId}/file"
    ATTRIBUTES = "/attributes"
    ATTRIBUTES_BULK = "/attributes/bulk"
    ATTRIBUTES_ATTRIBUTE_ID = "/attributes/{attributeId}"
    COMMENTS = "/comments"
    COMMENTS_COMMENT_ID = "/comments/{commentId}"
    COMMUNITIES_BULK = "/communities/bulk"
    COMMUNITIES = "/communities"
    COMMUNITIES_COMMUNITY_ID = "/communities/{communityId}"
    COMMUNITIES_COMMUNITY_ID_ROOT = "/communities/{communityId}/root"
    COMMUNITIES_COMMUNITY_ID_BREADCRUMB = "/communities/{communityId}/breadcrumb"
    COMMUNITIES_REMOVAL_JOBS = "/communities/removalJobs"
    COMPLEX_RELATIONS = "/complexRelations"
    COMPLEX_RELATIONS_COMPLEX_RELATION_ID = "/complexRelations/{complexRelationId}"
    COMPLEX_RELATIONS_EXPORT_CSVJOB = "/complexRelations/export/csv-job"
    COMPLEX_RELATIONS_EXPORT_CSV = "/complexRelations/export/csv"
    COMPLEX_RELATIONS_EXPORT_CSVFILE = "/complexRelations/export/csv-file"
    COMPLEX_RELATIONS_EXPORT_EXCELJOB = "/complexRelations/export/excel-job"
    COMPLEX_RELATIONS_EXPORT_EXCELFILE = "/complexRelations/export/excel-file"
    DOMAINS = "/domains"
    DOMAINS_BULK = "/domains/bulk"
    DOMAINS_DOMAIN_ID = "/domains/{domainId}"
    DOMAINS_DOMAIN_ID_BREADCRUMB = "/domains/{domainId}/breadcrumb"
    DOMAINS_REMOVAL_JOBS = "/domains/removalJobs"
    ISSUES = "/issues"
    ISSUES_ISSUE_ID_COMMUNITY_COMMUNITY_ID = "/issues/{issueId}/community/{communityId}"
    JDBC = "/jdbc"
    RATINGS = "/ratings"
    RATINGS_RATING_ID = "/ratings/{ratingId}"
    RELATIONS = "/relations"
    RELATIONS_BULK = "/relations/bulk"
    RELATIONS_RELATION_ID = "/relations/{relationId}"
    RESPONSIBILITIES_BULK = "/responsibilities/bulk"
    RESPONSIBILITIES = "/responsibilities"
    RESPONSIBILITIES_RESPONSIBILITY_ID = "/responsibilities/{responsibilityId}"
    TAGS_TAG_ID = "/tags/{tagId}"
    TAGS_EXISTS_TAG_NAME = "/tags/exists/{tagName}"
    TAGS = "/tags"
    TAGS_ASSET_ASSET_ID = "/tags/asset/{assetId}"
    TAGS_MERGE = "/tags/merge"
    TAGS_BULK = "/tags/bulk"
    JOBS_JOB_ID_CANCELED = "/jobs/{jobId}/canceled"
    JOBS = "/jobs"
    JOBS_JOB_ID = "/jobs/{jobId}"
    MAPPINGS = "/mappings"
    MAPPINGS_BULK = "/mappings/bulk"
    MAPPINGS_MAPPING_ID = "/mappings/{mappingId}"
    MAPPINGS_EXTERNAL_SYSTEM_EXTERNAL_SYSTEM_ID_EXTERNAL_ENTITY_EXTERNAL_ENTITY_ID = "/mappings/externalSystem/{externalSystemId}/externalEntity/{externalEntityId}"
    MAPPINGS_EXTERNAL_SYSTEM_EXTERNAL_SYSTEM_ID_MAPPED_RESOURCE_MAPPED_RESOURCE_ID = "/mappings/externalSystem/{externalSystemId}/mappedResource/{mappedResourceId}"
    MAPPINGS_EXTERNAL_SYSTEM_EXTERNAL_ENTITY_BULK = "/mappings/externalSystem/externalEntity/bulk"
    MAPPINGS_EXTERNAL_SYSTEM_MAPPED_RESOURCE_BULK = "/mappings/externalSystem/mappedResource/bulk"
    MAPPINGS_EXTERNAL_SYSTEM_EXTERNAL_SYSTEM_ID_REMOVAL_JOBS = "/mappings/externalSystem/{externalSystemId}/removalJobs"
    MAPPINGS_REMOVAL_JOBS = "/mappings/removalJobs"
    ASSET_TYPES = "/assetTypes"
    ASSET_TYPES_BULK = "/assetTypes/bulk"
    ASSET_TYPES_ASSET_TYPE_ID = "/assetTypes/{assetTypeId}"
    ASSET_TYPES_ASSET_TYPE_ID_PARENTS = "/assetTypes/{assetTypeId}/parents"
    ASSET_TYPES_ASSET_TYPE_ID_SUB_TYPES = "/assetTypes/{assetTypeId}/subTypes"
    ATTRIBUTE_TYPES = "/attributeTypes"
    ATTRIBUTE_TYPES_BULK = "/attributeTypes/bulk"
    ATTRIBUTE_TYPES_ATTRIBUTE_TYPE_ID = "/attributeTypes/{attributeTypeId}"
    ATTRIBUTE_TYPES_NAME_ATTRIBUTE_TYPE_NAME = "/attributeTypes/name/{attributeTypeName}"
    COMPLEX_RELATION_TYPES = "/complexRelationTypes"
    COMPLEX_RELATION_TYPES_COMPLEX_RELATION_TYPE_ID = "/complexRelationTypes/{complexRelationTypeId}"
    DOMAIN_TYPES = "/domainTypes"
    DOMAIN_TYPES_BULK = "/domainTypes/bulk"
    DOMAIN_TYPES_DOMAIN_TYPE_ID = "/domainTypes/{domainTypeId}"
    DOMAIN_TYPES_DOMAIN_TYPE_ID_SUB_TYPES = "/domainTypes/{domainTypeId}/subTypes"
    RELATION_TYPES = "/relationTypes"
    RELATION_TYPES_BULK = "/relationTypes/bulk"
    RELATION_TYPES_RELATION_TYPE_ID = "/relationTypes/{relationTypeId}"
    STATUSES = "/statuses"
    STATUSES_BULK = "/statuses/bulk"
    STATUSES_STATUS_ID = "/statuses/{statusId}"
    STATUSES_NAME_STATUS_NAME = "/statuses/name/{statusName}"
    NAVIGATION_MOST_VIEWED = "/navigation/most_viewed"
    NAVIGATION_RECENTLY_VIEWED = "/navigation/recently_viewed"
    DATA_QUALITY_RULES = "/dataQualityRules"
    DATA_QUALITY_RULES_DATA_QUALITY_RULE_ID = "/dataQualityRules/{dataQualityRuleId}"
    OUTPUT_MODULE_EXPORT_CSV = "/outputModule/export/csv"
    OUTPUT_MODULE_EXPORT_CSVJOB = "/outputModule/export/csv-job"
    OUTPUT_MODULE_EXPORT_CSVFILE = "/outputModule/export/csv-file"
    OUTPUT_MODULE_EXPORT_EXCELJOB = "/outputModule/export/excel-job"
    OUTPUT_MODULE_EXPORT_EXCELFILE = "/outputModule/export/excel-file"
    OUTPUT_MODULE_EXPORT_JSON = "/outputModule/export/json"
    OUTPUT_MODULE_EXPORT_JSONJOB = "/outputModule/export/json-job"
    OUTPUT_MODULE_EXPORT_JSONFILE = "/outputModule/export/json-file"
    OUTPUT_MODULE_EXPORT_XML = "/outputModule/export/xml"
    OUTPUT_MODULE_EXPORT_XMLJOB = "/outputModule/export/xml-job"
    OUTPUT_MODULE_EXPORT_XMLFILE = "/outputModule/export/xml-file"
    OUTPUT_MODULE_TABLE_VIEW_CONFIGS_VIEW_ID_VIEW_ID = "/outputModule/tableViewConfigs/viewId/{viewId}"
    REPORTING_INSIGHTS_DOWNLOAD = "/reporting/insights/download"
    ROLES = "/roles"
    ROLES_ROLE_ID = "/roles/{roleId}"
    SECURITY_SAML_CERTIFICATE_TYPE = "/security/saml/certificate/{type}"
    SECURITY_SAML = "/security/saml"
    AUTH_SESSIONS_CURRENT = "/auth/sessions/current"
    AUTH_SESSIONS_HEARTBEAT = "/auth/sessions/heartbeat"
    AUTH_SESSIONS = "/auth/sessions"
    USERS = "/users"
    USERS_USER_ID_USER_GROUPS = "/users/{userId}/userGroups"
    USERS_BULK = "/users/bulk"
    USERS_USER_ID = "/users/{userId}"
    USERS_USER_ID_AVATAR = "/users/{userId}/avatar"
    USERS_CURRENT = "/users/current"
    USERS_CURRENT_PERMISSIONS = "/users/current/permissions"
    USERS_EMAIL_EMAIL_ADDRESS = "/users/email/{emailAddress}"
    USERS_USER_ID_LICENSE_TYPE = "/users/{userId}/licenseType"
    USER_GROUPS = "/userGroups"
    USER_GROUPS_USER_GROUP_ID_USERS = "/userGroups/{userGroupId}/users"
    USER_GROUPS_USER_GROUP_ID = "/userGroups/{userGroupId}"
    VALIDATION = "/validation"
    VALIDATION_ASSET_ID = "/validation/{assetId}"
    VALIDATION_BULK = "/validation/bulk"
    VIEW_PERMISSIONS = "/viewPermissions"
    VIEW_PERMISSIONS_VIEW_PERMISSION_ID = "/viewPermissions/{viewPermissionId}"
    WORKFLOW_DEFINITIONS_WORKFLOW_DEFINITION_ID_ASSET_TYPE_ASSIGNMENT_RULES = "/workflowDefinitions/{workflowDefinitionId}/assetTypeAssignmentRules"
    WORKFLOW_DEFINITIONS_WORKFLOW_DEFINITION_ID_DOMAIN_TYPE_ASSIGNMENT_RULES = "/workflowDefinitions/{workflowDefinitionId}/domainTypeAssignmentRules"
    WORKFLOW_DEFINITIONS_WORKFLOW_DEFINITION_ID_ASSET_TYPE_ASSIGNMENT_RULES_RULE_ID = "/workflowDefinitions/{workflowDefinitionId}/assetTypeAssignmentRules/{ruleId}"
    WORKFLOW_DEFINITIONS_WORKFLOW_DEFINITION_ID_DOMAIN_TYPE_ASSIGNMENT_RULES_RULE_ID = "/workflowDefinitions/{workflowDefinitionId}/domainTypeAssignmentRules/{ruleId}"
    WORKFLOW_DEFINITIONS_WORKFLOW_DEFINITION_ID = "/workflowDefinitions/{workflowDefinitionId}"
    WORKFLOW_DEFINITIONS = "/workflowDefinitions"
    WORKFLOW_DEFINITIONS_WORKFLOW_DEFINITION_WORKFLOW_DEFINITION_ID_CONFIGURATION_START_FORM_DATA = "/workflowDefinitions/workflowDefinition/{workflowDefinitionId}/configurationStartFormData"
    WORKFLOW_DEFINITIONS_START_EVENTS = "/workflowDefinitions/startEvents"
    WORKFLOW_DEFINITIONS_WORKFLOW_DEFINITION_WORKFLOW_DEFINITION_ID_START_FORM_DATA = "/workflowDefinitions/workflowDefinition/{workflowDefinitionId}/startFormData"
    WORKFLOW_DEFINITIONS_PROCESS_PROCESS_ID = "/workflowDefinitions/process/{processId}"
    WORKFLOW_DEFINITIONS_WORKFLOW_DEFINITION_ID_DIAGRAM = "/workflowDefinitions/{workflowDefinitionId}/diagram"
    WORKFLOW_DEFINITIONS_WORKFLOW_DEFINITION_ID_XML = "/workflowDefinitions/{workflowDefinitionId}/xml"
    WORKFLOW_DEFINITIONS_WORKFLOW_DEFINITION_ID_ASSIGNMENT_RULES_RULE_ID = "/workflowDefinitions/{workflowDefinitionId}/assignmentRules/{ruleId}"
    WORKFLOW_DEFINITIONS_REMOVAL_JOBS = "/workflowDefinitions/removalJobs"
    WORKFLOW_INSTANCES_WORKFLOW_INSTANCE_ID_CANCELED = "/workflowInstances/{workflowInstanceId}/canceled"
    WORKFLOW_INSTANCES = "/workflowInstances"
    WORKFLOW_INSTANCES_WORKFLOW_INSTANCE_ID_DIAGRAM = "/workflowInstances/{workflowInstanceId}/diagram"
    WORKFLOW_INSTANCES_PROCESS_INSTANCE_ID_MESSAGE_EVENTS_MESSAGE_NAME = "/workflowInstances/{processInstanceId}/messageEvents/{messageName}"
    WORKFLOW_INSTANCES_START_JOBS = "/workflowInstances/startJobs"
    WORKFLOW_TASKS_WORKFLOW_TASK_ID_CANCELED = "/workflowTasks/{workflowTaskId}/canceled"
    WORKFLOW_TASKS_COMPLETED = "/workflowTasks/completed"
    WORKFLOW_TASKS = "/workflowTasks"
    WORKFLOW_TASKS_WORKFLOW_TASK_ID_TASK_FORM_DATA = "/workflowTasks/{workflowTaskId}/taskFormData"
    WORKFLOW_TASKS_WORKFLOW_TASK_ID = "/workflowTasks/{workflowTaskId}"
    WORKFLOW_TASKS_WORKFLOW_TASK_ID_REASSIGN = "/workflowTasks/{workflowTaskId}/reassign"
