# coding: utf-8

"""
    Collibra Data Governance Center Core API

    <p>The Core REST API allows you to create your own integrations with Collibra Data Governance Center.</p><p><i>Create custom applications to help users get access to the right data.</i></p>  # noqa: E501

    The version of the OpenAPI document: 2.0
    Generated by: https://openapi-generator.tech
"""

from datetime import date, datetime  # noqa: F401
import decimal  # noqa: F401
import functools  # noqa: F401
import io  # noqa: F401
import re  # noqa: F401
import typing  # noqa: F401
import typing_extensions  # noqa: F401
import uuid  # noqa: F401

import frozendict  # noqa: F401

from collibra_core import schemas  # noqa: F401


class Job(
    schemas.DictSchema
):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Represents a job. Job is a single atomic task that is to be performed asynchronously
    """


    class MetaOapg:
        required = {
            "id",
            "resourceType",
        }
        
        class properties:
            id = schemas.UUIDSchema
            
            
            class resourceType(
                schemas.EnumBase,
                schemas.StrSchema
            ):
            
            
                class MetaOapg:
                    enum_value_to_name = {
                        "View": "VIEW",
                        "Asset": "ASSET",
                        "Community": "COMMUNITY",
                        "Domain": "DOMAIN",
                        "AssetType": "ASSET_TYPE",
                        "DomainType": "DOMAIN_TYPE",
                        "Status": "STATUS",
                        "User": "USER",
                        "ClassificationMatch": "CLASSIFICATION_MATCH",
                        "UserGroup": "USER_GROUP",
                        "Attribute": "ATTRIBUTE",
                        "StringAttribute": "STRING_ATTRIBUTE",
                        "ScriptAttribute": "SCRIPT_ATTRIBUTE",
                        "BooleanAttribute": "BOOLEAN_ATTRIBUTE",
                        "DateAttribute": "DATE_ATTRIBUTE",
                        "NumericAttribute": "NUMERIC_ATTRIBUTE",
                        "SingleValueListAttribute": "SINGLE_VALUE_LIST_ATTRIBUTE",
                        "MultiValueListAttribute": "MULTI_VALUE_LIST_ATTRIBUTE",
                        "Comment": "COMMENT",
                        "Attachment": "ATTACHMENT",
                        "Responsibility": "RESPONSIBILITY",
                        "Workflow": "WORKFLOW",
                        "Job": "JOB",
                        "Relation": "RELATION",
                        "RelationType": "RELATION_TYPE",
                        "ComplexRelation": "COMPLEX_RELATION",
                        "ComplexRelationType": "COMPLEX_RELATION_TYPE",
                        "ArticulationRule": "ARTICULATION_RULE",
                        "Assignment": "ASSIGNMENT",
                        "Scope": "SCOPE",
                        "RelationTrace": "RELATION_TRACE",
                        "ValidationRule": "VALIDATION_RULE",
                        "DataQualityRule": "DATA_QUALITY_RULE",
                        "DataQualityMetric": "DATA_QUALITY_METRIC",
                        "Address": "ADDRESS",
                        "InstantMessagingAccount": "INSTANT_MESSAGING_ACCOUNT",
                        "Email": "EMAIL",
                        "PhoneNumber": "PHONE_NUMBER",
                        "Website": "WEBSITE",
                        "Activity": "ACTIVITY",
                        "FormProperty": "FORM_PROPERTY",
                        "WorkflowTask": "WORKFLOW_TASK",
                        "ActivityChange": "ACTIVITY_CHANGE",
                        "WorkflowInstance": "WORKFLOW_INSTANCE",
                        "Role": "ROLE",
                        "AttributeType": "ATTRIBUTE_TYPE",
                        "BooleanAttributeType": "BOOLEAN_ATTRIBUTE_TYPE",
                        "DateAttributeType": "DATE_ATTRIBUTE_TYPE",
                        "DateTimeAttributeType": "DATE_TIME_ATTRIBUTE_TYPE",
                        "MultiValueListAttributeType": "MULTI_VALUE_LIST_ATTRIBUTE_TYPE",
                        "NumericAttributeType": "NUMERIC_ATTRIBUTE_TYPE",
                        "ScriptAttributeType": "SCRIPT_ATTRIBUTE_TYPE",
                        "SingleValueListAttributeType": "SINGLE_VALUE_LIST_ATTRIBUTE_TYPE",
                        "StringAttributeType": "STRING_ATTRIBUTE_TYPE",
                        "ViewSharingRule": "VIEW_SHARING_RULE",
                        "ViewAssignmentRule": "VIEW_ASSIGNMENT_RULE",
                        "JdbcDriverFile": "JDBC_DRIVER_FILE",
                        "JdbcDriver": "JDBC_DRIVER",
                        "JdbcIngestionProperties": "JDBC_INGESTION_PROPERTIES",
                        "CsvIngestionProperties": "CSV_INGESTION_PROPERTIES",
                        "ExcelIngestionProperties": "EXCEL_INGESTION_PROPERTIES",
                        "ConnectionStringParameter": "CONNECTION_STRING_PARAMETER",
                        "AssignedCharacteristicType": "ASSIGNED_CHARACTERISTIC_TYPE",
                        "Notification": "NOTIFICATION",
                        "Tag": "TAG",
                        "ComplexRelationLegType": "COMPLEX_RELATION_LEG_TYPE",
                        "ComplexRelationAttributeType": "COMPLEX_RELATION_ATTRIBUTE_TYPE",
                        "ComplexRelationLeg": "COMPLEX_RELATION_LEG",
                        "BaseDataType": "BASE_DATA_TYPE",
                        "AdvancedDataType": "ADVANCED_DATA_TYPE",
                        "DiagramPicture": "DIAGRAM_PICTURE",
                        "DiagramPictureSharingRule": "DIAGRAM_PICTURE_SHARING_RULE",
                        "DiagramPictureAssignmentRule": "DIAGRAM_PICTURE_ASSIGNMENT_RULE",
                        "Rating": "RATING",
                        "Classification": "CLASSIFICATION",
                        "PhysicalDataConnector": "PHYSICAL_DATA_CONNECTOR",
                        "Context": "CONTEXT",
                    }
                
                @schemas.classproperty
                def VIEW(cls):
                    return cls("View")
                
                @schemas.classproperty
                def ASSET(cls):
                    return cls("Asset")
                
                @schemas.classproperty
                def COMMUNITY(cls):
                    return cls("Community")
                
                @schemas.classproperty
                def DOMAIN(cls):
                    return cls("Domain")
                
                @schemas.classproperty
                def ASSET_TYPE(cls):
                    return cls("AssetType")
                
                @schemas.classproperty
                def DOMAIN_TYPE(cls):
                    return cls("DomainType")
                
                @schemas.classproperty
                def STATUS(cls):
                    return cls("Status")
                
                @schemas.classproperty
                def USER(cls):
                    return cls("User")
                
                @schemas.classproperty
                def CLASSIFICATION_MATCH(cls):
                    return cls("ClassificationMatch")
                
                @schemas.classproperty
                def USER_GROUP(cls):
                    return cls("UserGroup")
                
                @schemas.classproperty
                def ATTRIBUTE(cls):
                    return cls("Attribute")
                
                @schemas.classproperty
                def STRING_ATTRIBUTE(cls):
                    return cls("StringAttribute")
                
                @schemas.classproperty
                def SCRIPT_ATTRIBUTE(cls):
                    return cls("ScriptAttribute")
                
                @schemas.classproperty
                def BOOLEAN_ATTRIBUTE(cls):
                    return cls("BooleanAttribute")
                
                @schemas.classproperty
                def DATE_ATTRIBUTE(cls):
                    return cls("DateAttribute")
                
                @schemas.classproperty
                def NUMERIC_ATTRIBUTE(cls):
                    return cls("NumericAttribute")
                
                @schemas.classproperty
                def SINGLE_VALUE_LIST_ATTRIBUTE(cls):
                    return cls("SingleValueListAttribute")
                
                @schemas.classproperty
                def MULTI_VALUE_LIST_ATTRIBUTE(cls):
                    return cls("MultiValueListAttribute")
                
                @schemas.classproperty
                def COMMENT(cls):
                    return cls("Comment")
                
                @schemas.classproperty
                def ATTACHMENT(cls):
                    return cls("Attachment")
                
                @schemas.classproperty
                def RESPONSIBILITY(cls):
                    return cls("Responsibility")
                
                @schemas.classproperty
                def WORKFLOW(cls):
                    return cls("Workflow")
                
                @schemas.classproperty
                def JOB(cls):
                    return cls("Job")
                
                @schemas.classproperty
                def RELATION(cls):
                    return cls("Relation")
                
                @schemas.classproperty
                def RELATION_TYPE(cls):
                    return cls("RelationType")
                
                @schemas.classproperty
                def COMPLEX_RELATION(cls):
                    return cls("ComplexRelation")
                
                @schemas.classproperty
                def COMPLEX_RELATION_TYPE(cls):
                    return cls("ComplexRelationType")
                
                @schemas.classproperty
                def ARTICULATION_RULE(cls):
                    return cls("ArticulationRule")
                
                @schemas.classproperty
                def ASSIGNMENT(cls):
                    return cls("Assignment")
                
                @schemas.classproperty
                def SCOPE(cls):
                    return cls("Scope")
                
                @schemas.classproperty
                def RELATION_TRACE(cls):
                    return cls("RelationTrace")
                
                @schemas.classproperty
                def VALIDATION_RULE(cls):
                    return cls("ValidationRule")
                
                @schemas.classproperty
                def DATA_QUALITY_RULE(cls):
                    return cls("DataQualityRule")
                
                @schemas.classproperty
                def DATA_QUALITY_METRIC(cls):
                    return cls("DataQualityMetric")
                
                @schemas.classproperty
                def ADDRESS(cls):
                    return cls("Address")
                
                @schemas.classproperty
                def INSTANT_MESSAGING_ACCOUNT(cls):
                    return cls("InstantMessagingAccount")
                
                @schemas.classproperty
                def EMAIL(cls):
                    return cls("Email")
                
                @schemas.classproperty
                def PHONE_NUMBER(cls):
                    return cls("PhoneNumber")
                
                @schemas.classproperty
                def WEBSITE(cls):
                    return cls("Website")
                
                @schemas.classproperty
                def ACTIVITY(cls):
                    return cls("Activity")
                
                @schemas.classproperty
                def FORM_PROPERTY(cls):
                    return cls("FormProperty")
                
                @schemas.classproperty
                def WORKFLOW_TASK(cls):
                    return cls("WorkflowTask")
                
                @schemas.classproperty
                def ACTIVITY_CHANGE(cls):
                    return cls("ActivityChange")
                
                @schemas.classproperty
                def WORKFLOW_INSTANCE(cls):
                    return cls("WorkflowInstance")
                
                @schemas.classproperty
                def ROLE(cls):
                    return cls("Role")
                
                @schemas.classproperty
                def ATTRIBUTE_TYPE(cls):
                    return cls("AttributeType")
                
                @schemas.classproperty
                def BOOLEAN_ATTRIBUTE_TYPE(cls):
                    return cls("BooleanAttributeType")
                
                @schemas.classproperty
                def DATE_ATTRIBUTE_TYPE(cls):
                    return cls("DateAttributeType")
                
                @schemas.classproperty
                def DATE_TIME_ATTRIBUTE_TYPE(cls):
                    return cls("DateTimeAttributeType")
                
                @schemas.classproperty
                def MULTI_VALUE_LIST_ATTRIBUTE_TYPE(cls):
                    return cls("MultiValueListAttributeType")
                
                @schemas.classproperty
                def NUMERIC_ATTRIBUTE_TYPE(cls):
                    return cls("NumericAttributeType")
                
                @schemas.classproperty
                def SCRIPT_ATTRIBUTE_TYPE(cls):
                    return cls("ScriptAttributeType")
                
                @schemas.classproperty
                def SINGLE_VALUE_LIST_ATTRIBUTE_TYPE(cls):
                    return cls("SingleValueListAttributeType")
                
                @schemas.classproperty
                def STRING_ATTRIBUTE_TYPE(cls):
                    return cls("StringAttributeType")
                
                @schemas.classproperty
                def VIEW_SHARING_RULE(cls):
                    return cls("ViewSharingRule")
                
                @schemas.classproperty
                def VIEW_ASSIGNMENT_RULE(cls):
                    return cls("ViewAssignmentRule")
                
                @schemas.classproperty
                def JDBC_DRIVER_FILE(cls):
                    return cls("JdbcDriverFile")
                
                @schemas.classproperty
                def JDBC_DRIVER(cls):
                    return cls("JdbcDriver")
                
                @schemas.classproperty
                def JDBC_INGESTION_PROPERTIES(cls):
                    return cls("JdbcIngestionProperties")
                
                @schemas.classproperty
                def CSV_INGESTION_PROPERTIES(cls):
                    return cls("CsvIngestionProperties")
                
                @schemas.classproperty
                def EXCEL_INGESTION_PROPERTIES(cls):
                    return cls("ExcelIngestionProperties")
                
                @schemas.classproperty
                def CONNECTION_STRING_PARAMETER(cls):
                    return cls("ConnectionStringParameter")
                
                @schemas.classproperty
                def ASSIGNED_CHARACTERISTIC_TYPE(cls):
                    return cls("AssignedCharacteristicType")
                
                @schemas.classproperty
                def NOTIFICATION(cls):
                    return cls("Notification")
                
                @schemas.classproperty
                def TAG(cls):
                    return cls("Tag")
                
                @schemas.classproperty
                def COMPLEX_RELATION_LEG_TYPE(cls):
                    return cls("ComplexRelationLegType")
                
                @schemas.classproperty
                def COMPLEX_RELATION_ATTRIBUTE_TYPE(cls):
                    return cls("ComplexRelationAttributeType")
                
                @schemas.classproperty
                def COMPLEX_RELATION_LEG(cls):
                    return cls("ComplexRelationLeg")
                
                @schemas.classproperty
                def BASE_DATA_TYPE(cls):
                    return cls("BaseDataType")
                
                @schemas.classproperty
                def ADVANCED_DATA_TYPE(cls):
                    return cls("AdvancedDataType")
                
                @schemas.classproperty
                def DIAGRAM_PICTURE(cls):
                    return cls("DiagramPicture")
                
                @schemas.classproperty
                def DIAGRAM_PICTURE_SHARING_RULE(cls):
                    return cls("DiagramPictureSharingRule")
                
                @schemas.classproperty
                def DIAGRAM_PICTURE_ASSIGNMENT_RULE(cls):
                    return cls("DiagramPictureAssignmentRule")
                
                @schemas.classproperty
                def RATING(cls):
                    return cls("Rating")
                
                @schemas.classproperty
                def CLASSIFICATION(cls):
                    return cls("Classification")
                
                @schemas.classproperty
                def PHYSICAL_DATA_CONNECTOR(cls):
                    return cls("PhysicalDataConnector")
                
                @schemas.classproperty
                def CONTEXT(cls):
                    return cls("Context")
            createdBy = schemas.UUIDSchema
            createdOn = schemas.Int64Schema
            lastModifiedBy = schemas.UUIDSchema
            lastModifiedOn = schemas.Int64Schema
            system = schemas.BoolSchema
            name = schemas.StrSchema
            type = schemas.StrSchema
            userId = schemas.UUIDSchema
            visibility = schemas.Int32Schema
            progressPercentage = schemas.Float64Schema
            cancelable = schemas.BoolSchema
            startDate = schemas.Int64Schema
            endDate = schemas.Int64Schema
            
            
            class state(
                schemas.EnumBase,
                schemas.StrSchema
            ):
            
            
                class MetaOapg:
                    enum_value_to_name = {
                        "WAITING": "WAITING",
                        "RUNNING": "RUNNING",
                        "CANCELING": "CANCELING",
                        "COMPLETED": "COMPLETED",
                        "CANCELED": "CANCELED",
                        "ERROR": "ERROR",
                    }
                
                @schemas.classproperty
                def WAITING(cls):
                    return cls("WAITING")
                
                @schemas.classproperty
                def RUNNING(cls):
                    return cls("RUNNING")
                
                @schemas.classproperty
                def CANCELING(cls):
                    return cls("CANCELING")
                
                @schemas.classproperty
                def COMPLETED(cls):
                    return cls("COMPLETED")
                
                @schemas.classproperty
                def CANCELED(cls):
                    return cls("CANCELED")
                
                @schemas.classproperty
                def ERROR(cls):
                    return cls("ERROR")
            
            
            class result(
                schemas.EnumBase,
                schemas.StrSchema
            ):
            
            
                class MetaOapg:
                    enum_value_to_name = {
                        "NOT_SET": "NOT_SET",
                        "SUCCESS": "SUCCESS",
                        "COMPLETED_WITH_ERROR": "COMPLETED_WITH_ERROR",
                        "FAILURE": "FAILURE",
                        "ABORTED": "ABORTED",
                    }
                
                @schemas.classproperty
                def NOT_SET(cls):
                    return cls("NOT_SET")
                
                @schemas.classproperty
                def SUCCESS(cls):
                    return cls("SUCCESS")
                
                @schemas.classproperty
                def COMPLETED_WITH_ERROR(cls):
                    return cls("COMPLETED_WITH_ERROR")
                
                @schemas.classproperty
                def FAILURE(cls):
                    return cls("FAILURE")
                
                @schemas.classproperty
                def ABORTED(cls):
                    return cls("ABORTED")
            message = schemas.StrSchema
            __annotations__ = {
                "id": id,
                "resourceType": resourceType,
                "createdBy": createdBy,
                "createdOn": createdOn,
                "lastModifiedBy": lastModifiedBy,
                "lastModifiedOn": lastModifiedOn,
                "system": system,
                "name": name,
                "type": type,
                "userId": userId,
                "visibility": visibility,
                "progressPercentage": progressPercentage,
                "cancelable": cancelable,
                "startDate": startDate,
                "endDate": endDate,
                "state": state,
                "result": result,
                "message": message,
            }
    
    id: MetaOapg.properties.id
    resourceType: MetaOapg.properties.resourceType
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["id"]) -> MetaOapg.properties.id: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["resourceType"]) -> MetaOapg.properties.resourceType: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["createdBy"]) -> MetaOapg.properties.createdBy: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["createdOn"]) -> MetaOapg.properties.createdOn: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["lastModifiedBy"]) -> MetaOapg.properties.lastModifiedBy: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["lastModifiedOn"]) -> MetaOapg.properties.lastModifiedOn: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["system"]) -> MetaOapg.properties.system: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["name"]) -> MetaOapg.properties.name: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["type"]) -> MetaOapg.properties.type: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["userId"]) -> MetaOapg.properties.userId: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["visibility"]) -> MetaOapg.properties.visibility: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["progressPercentage"]) -> MetaOapg.properties.progressPercentage: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["cancelable"]) -> MetaOapg.properties.cancelable: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["startDate"]) -> MetaOapg.properties.startDate: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["endDate"]) -> MetaOapg.properties.endDate: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["state"]) -> MetaOapg.properties.state: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["result"]) -> MetaOapg.properties.result: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["message"]) -> MetaOapg.properties.message: ...
    
    @typing.overload
    def __getitem__(self, name: str) -> schemas.UnsetAnyTypeSchema: ...
    
    def __getitem__(self, name: typing.Union[typing_extensions.Literal["id", "resourceType", "createdBy", "createdOn", "lastModifiedBy", "lastModifiedOn", "system", "name", "type", "userId", "visibility", "progressPercentage", "cancelable", "startDate", "endDate", "state", "result", "message", ], str]):
        # dict_instance[name] accessor
        return super().__getitem__(name)
    
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["id"]) -> MetaOapg.properties.id: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["resourceType"]) -> MetaOapg.properties.resourceType: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["createdBy"]) -> typing.Union[MetaOapg.properties.createdBy, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["createdOn"]) -> typing.Union[MetaOapg.properties.createdOn, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["lastModifiedBy"]) -> typing.Union[MetaOapg.properties.lastModifiedBy, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["lastModifiedOn"]) -> typing.Union[MetaOapg.properties.lastModifiedOn, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["system"]) -> typing.Union[MetaOapg.properties.system, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["name"]) -> typing.Union[MetaOapg.properties.name, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["type"]) -> typing.Union[MetaOapg.properties.type, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["userId"]) -> typing.Union[MetaOapg.properties.userId, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["visibility"]) -> typing.Union[MetaOapg.properties.visibility, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["progressPercentage"]) -> typing.Union[MetaOapg.properties.progressPercentage, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["cancelable"]) -> typing.Union[MetaOapg.properties.cancelable, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["startDate"]) -> typing.Union[MetaOapg.properties.startDate, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["endDate"]) -> typing.Union[MetaOapg.properties.endDate, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["state"]) -> typing.Union[MetaOapg.properties.state, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["result"]) -> typing.Union[MetaOapg.properties.result, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["message"]) -> typing.Union[MetaOapg.properties.message, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: str) -> typing.Union[schemas.UnsetAnyTypeSchema, schemas.Unset]: ...
    
    def get_item_oapg(self, name: typing.Union[typing_extensions.Literal["id", "resourceType", "createdBy", "createdOn", "lastModifiedBy", "lastModifiedOn", "system", "name", "type", "userId", "visibility", "progressPercentage", "cancelable", "startDate", "endDate", "state", "result", "message", ], str]):
        return super().get_item_oapg(name)
    

    def __new__(
        cls,
        *args: typing.Union[dict, frozendict.frozendict, ],
        id: typing.Union[MetaOapg.properties.id, str, uuid.UUID, ],
        resourceType: typing.Union[MetaOapg.properties.resourceType, str, ],
        createdBy: typing.Union[MetaOapg.properties.createdBy, str, uuid.UUID, schemas.Unset] = schemas.unset,
        createdOn: typing.Union[MetaOapg.properties.createdOn, decimal.Decimal, int, schemas.Unset] = schemas.unset,
        lastModifiedBy: typing.Union[MetaOapg.properties.lastModifiedBy, str, uuid.UUID, schemas.Unset] = schemas.unset,
        lastModifiedOn: typing.Union[MetaOapg.properties.lastModifiedOn, decimal.Decimal, int, schemas.Unset] = schemas.unset,
        system: typing.Union[MetaOapg.properties.system, bool, schemas.Unset] = schemas.unset,
        name: typing.Union[MetaOapg.properties.name, str, schemas.Unset] = schemas.unset,
        type: typing.Union[MetaOapg.properties.type, str, schemas.Unset] = schemas.unset,
        userId: typing.Union[MetaOapg.properties.userId, str, uuid.UUID, schemas.Unset] = schemas.unset,
        visibility: typing.Union[MetaOapg.properties.visibility, decimal.Decimal, int, schemas.Unset] = schemas.unset,
        progressPercentage: typing.Union[MetaOapg.properties.progressPercentage, decimal.Decimal, int, float, schemas.Unset] = schemas.unset,
        cancelable: typing.Union[MetaOapg.properties.cancelable, bool, schemas.Unset] = schemas.unset,
        startDate: typing.Union[MetaOapg.properties.startDate, decimal.Decimal, int, schemas.Unset] = schemas.unset,
        endDate: typing.Union[MetaOapg.properties.endDate, decimal.Decimal, int, schemas.Unset] = schemas.unset,
        state: typing.Union[MetaOapg.properties.state, str, schemas.Unset] = schemas.unset,
        result: typing.Union[MetaOapg.properties.result, str, schemas.Unset] = schemas.unset,
        message: typing.Union[MetaOapg.properties.message, str, schemas.Unset] = schemas.unset,
        _configuration: typing.Optional[schemas.Configuration] = None,
        **kwargs: typing.Union[schemas.AnyTypeSchema, dict, frozendict.frozendict, str, date, datetime, uuid.UUID, int, float, decimal.Decimal, None, list, tuple, bytes],
    ) -> 'Job':
        return super().__new__(
            cls,
            *args,
            id=id,
            resourceType=resourceType,
            createdBy=createdBy,
            createdOn=createdOn,
            lastModifiedBy=lastModifiedBy,
            lastModifiedOn=lastModifiedOn,
            system=system,
            name=name,
            type=type,
            userId=userId,
            visibility=visibility,
            progressPercentage=progressPercentage,
            cancelable=cancelable,
            startDate=startDate,
            endDate=endDate,
            state=state,
            result=result,
            message=message,
            _configuration=_configuration,
            **kwargs,
        )
