# coding: utf-8

"""
    Collibra Data Governance Center Core API

    <p>The Core REST API allows you to create your own integrations with Collibra Data Governance Center.</p><p><i>Create custom applications to help users get access to the right data.</i></p>  # noqa: E501

    The version of the OpenAPI document: 2.0
    Generated by: https://openapi-generator.tech
"""

from datetime import date, datetime  # noqa: F401
import decimal  # noqa: F401
import functools  # noqa: F401
import io  # noqa: F401
import re  # noqa: F401
import typing  # noqa: F401
import typing_extensions  # noqa: F401
import uuid  # noqa: F401

import frozendict  # noqa: F401

from collibra_core import schemas  # noqa: F401


class DateAttributeType(
    schemas.ComposedBase,
    schemas.DictSchema
):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Represents an attribute which holds a date type value (as timestamp in UTC time).
    """


    class MetaOapg:
        required = {
            "id",
            "resourceType",
        }
        
        @staticmethod
        def discriminator():
            return {
                'resourceType': {
                    'BooleanAttributeType': BooleanAttributeType,
                    'DateAttributeType': DateAttributeType,
                    'MultiValueListAttributeType': MultiValueListAttributeType,
                    'NumericAttributeType': NumericAttributeType,
                    'ScriptAttributeType': ScriptAttributeType,
                    'SingleValueListAttributeType': SingleValueListAttributeType,
                    'StringAttributeType': StringAttributeType,
                }
            }
        
        @classmethod
        @functools.lru_cache()
        def all_of(cls):
            # we need this here to make our import statements work
            # we must store _composed_schemas in here so the code is only run
            # when we invoke this method. If we kept this at the class
            # level we would get an error because the class level
            # code would be run when this module is imported, and these composed
            # classes don't exist yet because their module has not finished
            # loading
            return [
                AttributeType,
            ]

    
    id: schemas.AnyTypeSchema
    resourceType: schemas.AnyTypeSchema

    def __new__(
        cls,
        *args: typing.Union[dict, frozendict.frozendict, ],
        _configuration: typing.Optional[schemas.Configuration] = None,
        **kwargs: typing.Union[schemas.AnyTypeSchema, dict, frozendict.frozendict, str, date, datetime, uuid.UUID, int, float, decimal.Decimal, None, list, tuple, bytes],
    ) -> 'DateAttributeType':
        return super().__new__(
            cls,
            *args,
            _configuration=_configuration,
            **kwargs,
        )

from collibra_core.model.attribute_type import AttributeType
from collibra_core.model.boolean_attribute_type import BooleanAttributeType
from collibra_core.model.date_attribute_type import DateAttributeType
from collibra_core.model.multi_value_list_attribute_type import MultiValueListAttributeType
from collibra_core.model.numeric_attribute_type import NumericAttributeType
from collibra_core.model.script_attribute_type import ScriptAttributeType
from collibra_core.model.single_value_list_attribute_type import SingleValueListAttributeType
from collibra_core.model.string_attribute_type import StringAttributeType
