# collibra-core
<p>The Core REST API allows you to create your own integrations with Collibra Data Governance Center.</p><p><i>Create custom applications to help users get access to the right data.</i></p>

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 2.0
- Package version: 1.0.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python &gt;&#x3D;3.7

## Migration from other generators like python and python-legacy

### Changes
1. This generator uses spec case for all (object) property names and parameter names.
    - So if the spec has a property name like camelCase, it will use camelCase rather than camel_case
    - So you will need to update how you input and read properties to use spec case
2. Endpoint parameters are stored in dictionaries to prevent collisions (explanation below)
    - So you will need to update how you pass data in to endpoints
3. Endpoint responses now include the original response, the deserialized response body, and (todo)the deserialized headers
    - So you will need to update your code to use response.body to access deserialized data
4. All validated data is instantiated in an instance that subclasses all validated Schema classes and Decimal/str/list/tuple/frozendict/NoneClass/BoolClass/bytes/io.FileIO
    - This means that you can use isinstance to check if a payload validated against a schema class
    - This means that no data will be of type None/True/False
        - ingested None will subclass NoneClass
        - ingested True will subclass BoolClass
        - ingested False will subclass BoolClass
        - So if you need to check is True/False/None, instead use instance.is_true_oapg()/.is_false_oapg()/.is_none_oapg()
5. All validated class instances are immutable except for ones based on io.File
    - This is because if properties were changed after validation, that validation would no longer apply
    - So no changing values or property values after a class has been instantiated
6. String + Number types with formats
    - String type data is stored as a string and if you need to access types based on its format like date,
    date-time, uuid, number etc then you will need to use accessor functions on the instance
    - type string + format: See .as_date_oapg, .as_datetime_oapg, .as_decimal_oapg, .as_uuid_oapg
    - type number + format: See .as_float_oapg, .as_int_oapg
    - this was done because openapi/json-schema defines constraints. string data may be type string with no format
    keyword in one schema, and include a format constraint in another schema
    - So if you need to access a string format based type, use as_date_oapg/as_datetime_oapg/as_decimal_oapg/as_uuid_oapg
    - So if you need to access a number format based type, use as_int_oapg/as_float_oapg
7. Property access on AnyType(type unset) or object(dict) schemas
    - Only required keys with valid python names are properties like .someProp and have type hints
    - All optional keys may not exist, so properties are not defined for them
    - One can access optional values with dict_instance['optionalProp'] and KeyError will be raised if it does not exist
    - Use get_item_oapg if you need a way to always get a value whether or not the key exists
        - If the key does not exist, schemas.unset is returned from calling dict_instance.get_item_oapg('optionalProp')
        - All required and optional keys have type hints for this method, and @typing.overload is used
        - A type hint is also generated for additionalProperties accessed using this method
    - So you will need to update you code to use some_instance['optionalProp'] to access optional property
    and additionalProperty values
8. The location of the api classes has changed
    - Api classes are located in your_package.apis.tags.some_api
    - This change was made to eliminate redundant code generation
    - Legacy generators generated the same endpoint twice if it had > 1 tag on it
    - This generator defines an endpoint in one class, then inherits that class to generate
      apis by tags and by paths
    - This change reduces code and allows quicker run time if you use the path apis
        - path apis are at your_package.apis.paths.some_path
    - Those apis will only load their needed models, which is less to load than all of the resources needed in a tag api
    - So you will need to update your import paths to the api classes

### Why are Oapg and _oapg used in class and method names?
Classes can have arbitrarily named properties set on them
Endpoints can have arbitrary operationId method names set
For those reasons, I use the prefix Oapg and _oapg to greatly reduce the likelihood of collisions
on protected + public classes/methods.
oapg stands for OpenApi Python Generator.

### Object property spec case
This was done because when payloads are ingested, they can be validated against N number of schemas.
If the input signature used a different property name then that has mutated the payload.
So SchemaA and SchemaB must both see the camelCase spec named variable.
Also it is possible to send in two properties, named camelCase and camel_case in the same payload.
That use case should be support so spec case is used.

### Parameter spec case
Parameters can be included in different locations including:
- query
- path
- header
- cookie

Any of those parameters could use the same parameter names, so if every parameter
was included as an endpoint parameter in a function signature, they would collide.
For that reason, each of those inputs have been separated out into separate typed dictionaries:
- query_params
- path_params
- header_params
- cookie_params

So when updating your code, you will need to pass endpoint parameters in using those
dictionaries.

### Endpoint responses
Endpoint responses have been enriched to now include more information.
Any response reom an endpoint will now include the following properties:
response: urllib3.HTTPResponse
body: typing.Union[Unset, Schema]
headers: typing.Union[Unset, TODO]
Note: response header deserialization has not yet been added


## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import collibra_core
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import collibra_core
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import time
import collibra_core
from pprint import pprint
from collibra_core.apis.tags import activities_api
from collibra_core.model.activity_paged_response import ActivityPagedResponse
# Defining the host is optional and defaults to http://localhost/rest/2.0
# See configuration.py for a list of all supported configuration parameters.
configuration = collibra_core.Configuration(
    host = "http://localhost/rest/2.0"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure HTTP basic authorization: basicAuth
configuration = collibra_core.Configuration(
    username = 'YOUR_USERNAME',
    password = 'YOUR_PASSWORD'
)

# Configure Bearer authorization (JWT): bearerAuth
configuration = collibra_core.Configuration(
    access_token = 'YOUR_BEARER_TOKEN'
)

# Enter a context with an instance of the API client
with collibra_core.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = activities_api.ActivitiesApi(api_client)
    offset = 0 # int | The first result to retrieve. If not set (offset = <code>0</code>), results will be retrieved starting from row <code>0</code>. (optional) (default to CodegenParameter{isFormParam=false, isQueryParam=true, isPathParam=false, isHeaderParam=false, isCookieParam=false, isBodyParam=false, isContainer=false, isCollectionFormatMulti=false, isPrimitiveType=true, isModel=false, isExplode=true, baseName='offset', paramName='offset', dataType='int', datatypeWithEnum='null', dataFormat='int32', collectionFormat='null', description='The first result to retrieve. If not set (offset = <code>0</code>), results will be retrieved starting from row <code>0</code>.', unescapedDescription='The first result to retrieve. If not set (offset = <code>0</code>), results will be retrieved starting from row <code>0</code>.', baseType='null', defaultValue='0', enumDefaultValue='null', enumName='null', style='FORM', deepObject='false', allowEmptyValue='false', example='0', jsonSchema='{
  "name" : "offset",
  "in" : "query",
  "description" : "The first result to retrieve. If not set (offset = <code>0</code>), results will be retrieved starting from row <code>0</code>.",
  "required" : false,
  "style" : "form",
  "explode" : true,
  "schema" : {
    "type" : "integer",
    "format" : "int32",
    "default" : 0
  }
}', isString=false, isNumeric=false, isInteger=true, isShort=true, isLong=false, isUnboundedInteger=false, isNumber=false, isFloat=false, isDouble=false, isDecimal=false, isByteArray=false, isBinary=false, isBoolean=false, isDate=false, isDateTime=false, isUuid=false, isUri=false, isEmail=false, isFreeFormObject=false, isAnyType=false, isArray=false, isMap=false, isFile=false, isEnum=false, _enum=null, allowableValues=null, items=null, mostInnerItems=null, additionalProperties=null, vars=[], requiredVars=[], vendorExtensions={}, hasValidation=false, maxProperties=null, minProperties=null, isNullable=false, isDeprecated=false, required=false, maximum='null', exclusiveMaximum=false, minimum='null', exclusiveMinimum=false, maxLength=null, minLength=null, pattern='null', maxItems=null, minItems=null, uniqueItems=false, uniqueItemsBoolean=null, contentType=null, multipleOf=null, isNull=false, getAdditionalPropertiesIsAnyType=false, getHasVars=false, getHasRequired=false, getHasDiscriminatorWithNonEmptyMapping=false, composedSchemas=null, hasMultipleTypes=false, schema=CodegenProperty{openApiType='integer', baseName='OffsetSchema', complexType='null', getter='getOffset', setter='setOffset', description='null', dataType='int', datatypeWithEnum='int', dataFormat='int32', name='offset', min='null', max='null', defaultValue='0', defaultValueWithParam=' = data.offset;', baseType='int', containerType='null', title='null', unescapedDescription='null', maxLength=null, minLength=null, pattern='null', example='0', jsonSchema='{
  "type" : "integer",
  "format" : "int32",
  "default" : 0
}', minimum='null', maximum='null', exclusiveMinimum=false, exclusiveMaximum=false, required=false, deprecated=false, hasMoreNonReadOnly=false, isPrimitiveType=true, isModel=false, isContainer=false, isString=false, isNumeric=false, isInteger=true, isShort=false, isLong=false, isUnboundedInteger=false, isNumber=false, isFloat=false, isDouble=false, isDecimal=false, isByteArray=false, isBinary=false, isFile=false, isBoolean=false, isDate=false, isDateTime=false, isUuid=false, isUri=false, isEmail=false, isFreeFormObject=false, isArray=false, isMap=false, isEnum=false, isInnerEnum=false, isAnyType=false, isReadOnly=false, isWriteOnly=false, isNullable=false, isSelfReference=false, isCircularReference=false, isDiscriminator=false, _enum=null, allowableValues=null, items=null, additionalProperties=null, vars=[], requiredVars=[], mostInnerItems=null, vendorExtensions={}, hasValidation=false, isInherited=false, discriminatorValue='null', nameInCamelCase='Offset', nameInSnakeCase='null', enumName='null', maxItems=null, minItems=null, maxProperties=null, minProperties=null, uniqueItems=false, uniqueItemsBoolean=null, multipleOf=null, isXmlAttribute=false, xmlPrefix='null', xmlName='null', xmlNamespace='null', isXmlWrapped=false, isNull=false, getAdditionalPropertiesIsAnyType=false, getHasVars=false, getHasRequired=false, getHasDiscriminatorWithNonEmptyMapping=false, composedSchemas=null, hasMultipleTypes=false, requiredVarsMap=null, ref=null, schemaIsFromAdditionalProperties=false, isBooleanSchemaTrue=false, isBooleanSchemaFalse=false, format=int32, dependentRequired=null, contains=null}, content=null, requiredVarsMap=null, ref=null, schemaIsFromAdditionalProperties=false})
limit = 0 # int | The maximum number of results to retrieve. If not set (limit = <code>0</code>), the default limit will be used. (optional) (default to CodegenParameter{isFormParam=false, isQueryParam=true, isPathParam=false, isHeaderParam=false, isCookieParam=false, isBodyParam=false, isContainer=false, isCollectionFormatMulti=false, isPrimitiveType=true, isModel=false, isExplode=true, baseName='limit', paramName='limit', dataType='int', datatypeWithEnum='null', dataFormat='int32', collectionFormat='null', description='The maximum number of results to retrieve. If not set (limit = <code>0</code>), the default limit will be used.', unescapedDescription='The maximum number of results to retrieve. If not set (limit = <code>0</code>), the default limit will be used.', baseType='null', defaultValue='0', enumDefaultValue='null', enumName='null', style='FORM', deepObject='false', allowEmptyValue='false', example='0', jsonSchema='{
  "name" : "limit",
  "in" : "query",
  "description" : "The maximum number of results to retrieve. If not set (limit = <code>0</code>), the default limit will be used.",
  "required" : false,
  "style" : "form",
  "explode" : true,
  "schema" : {
    "type" : "integer",
    "format" : "int32",
    "default" : 0
  }
}', isString=false, isNumeric=false, isInteger=true, isShort=true, isLong=false, isUnboundedInteger=false, isNumber=false, isFloat=false, isDouble=false, isDecimal=false, isByteArray=false, isBinary=false, isBoolean=false, isDate=false, isDateTime=false, isUuid=false, isUri=false, isEmail=false, isFreeFormObject=false, isAnyType=false, isArray=false, isMap=false, isFile=false, isEnum=false, _enum=null, allowableValues=null, items=null, mostInnerItems=null, additionalProperties=null, vars=[], requiredVars=[], vendorExtensions={}, hasValidation=false, maxProperties=null, minProperties=null, isNullable=false, isDeprecated=false, required=false, maximum='null', exclusiveMaximum=false, minimum='null', exclusiveMinimum=false, maxLength=null, minLength=null, pattern='null', maxItems=null, minItems=null, uniqueItems=false, uniqueItemsBoolean=null, contentType=null, multipleOf=null, isNull=false, getAdditionalPropertiesIsAnyType=false, getHasVars=false, getHasRequired=false, getHasDiscriminatorWithNonEmptyMapping=false, composedSchemas=null, hasMultipleTypes=false, schema=CodegenProperty{openApiType='integer', baseName='LimitSchema', complexType='null', getter='getLimit', setter='setLimit', description='null', dataType='int', datatypeWithEnum='int', dataFormat='int32', name='limit', min='null', max='null', defaultValue='0', defaultValueWithParam=' = data.limit;', baseType='int', containerType='null', title='null', unescapedDescription='null', maxLength=null, minLength=null, pattern='null', example='0', jsonSchema='{
  "type" : "integer",
  "format" : "int32",
  "default" : 0
}', minimum='null', maximum='null', exclusiveMinimum=false, exclusiveMaximum=false, required=false, deprecated=false, hasMoreNonReadOnly=false, isPrimitiveType=true, isModel=false, isContainer=false, isString=false, isNumeric=false, isInteger=true, isShort=false, isLong=false, isUnboundedInteger=false, isNumber=false, isFloat=false, isDouble=false, isDecimal=false, isByteArray=false, isBinary=false, isFile=false, isBoolean=false, isDate=false, isDateTime=false, isUuid=false, isUri=false, isEmail=false, isFreeFormObject=false, isArray=false, isMap=false, isEnum=false, isInnerEnum=false, isAnyType=false, isReadOnly=false, isWriteOnly=false, isNullable=false, isSelfReference=false, isCircularReference=false, isDiscriminator=false, _enum=null, allowableValues=null, items=null, additionalProperties=null, vars=[], requiredVars=[], mostInnerItems=null, vendorExtensions={}, hasValidation=false, isInherited=false, discriminatorValue='null', nameInCamelCase='Limit', nameInSnakeCase='null', enumName='null', maxItems=null, minItems=null, maxProperties=null, minProperties=null, uniqueItems=false, uniqueItemsBoolean=null, multipleOf=null, isXmlAttribute=false, xmlPrefix='null', xmlName='null', xmlNamespace='null', isXmlWrapped=false, isNull=false, getAdditionalPropertiesIsAnyType=false, getHasVars=false, getHasRequired=false, getHasDiscriminatorWithNonEmptyMapping=false, composedSchemas=null, hasMultipleTypes=false, requiredVarsMap=null, ref=null, schemaIsFromAdditionalProperties=false, isBooleanSchemaTrue=false, isBooleanSchemaFalse=false, format=int32, dependentRequired=null, contains=null}, content=null, requiredVarsMap=null, ref=null, schemaIsFromAdditionalProperties=false})
count_limit = -1 # int | Allows to limit the number of elements that will be counted. -1 will count everything and 0 will cause the count to be skipped (optional) (default to CodegenParameter{isFormParam=false, isQueryParam=true, isPathParam=false, isHeaderParam=false, isCookieParam=false, isBodyParam=false, isContainer=false, isCollectionFormatMulti=false, isPrimitiveType=true, isModel=false, isExplode=true, baseName='countLimit', paramName='count_limit', dataType='int', datatypeWithEnum='null', dataFormat='int32', collectionFormat='null', description='Allows to limit the number of elements that will be counted. -1 will count everything and 0 will cause the count to be skipped', unescapedDescription='Allows to limit the number of elements that will be counted. -1 will count everything and 0 will cause the count to be skipped', baseType='null', defaultValue='-1', enumDefaultValue='null', enumName='null', style='FORM', deepObject='false', allowEmptyValue='false', example='-1', jsonSchema='{
  "name" : "countLimit",
  "in" : "query",
  "description" : "Allows to limit the number of elements that will be counted. -1 will count everything and 0 will cause the count to be skipped",
  "required" : false,
  "style" : "form",
  "explode" : true,
  "schema" : {
    "type" : "integer",
    "format" : "int32",
    "default" : -1
  }
}', isString=false, isNumeric=false, isInteger=true, isShort=true, isLong=false, isUnboundedInteger=false, isNumber=false, isFloat=false, isDouble=false, isDecimal=false, isByteArray=false, isBinary=false, isBoolean=false, isDate=false, isDateTime=false, isUuid=false, isUri=false, isEmail=false, isFreeFormObject=false, isAnyType=false, isArray=false, isMap=false, isFile=false, isEnum=false, _enum=null, allowableValues=null, items=null, mostInnerItems=null, additionalProperties=null, vars=[], requiredVars=[], vendorExtensions={}, hasValidation=false, maxProperties=null, minProperties=null, isNullable=false, isDeprecated=false, required=false, maximum='null', exclusiveMaximum=false, minimum='null', exclusiveMinimum=false, maxLength=null, minLength=null, pattern='null', maxItems=null, minItems=null, uniqueItems=false, uniqueItemsBoolean=null, contentType=null, multipleOf=null, isNull=false, getAdditionalPropertiesIsAnyType=false, getHasVars=false, getHasRequired=false, getHasDiscriminatorWithNonEmptyMapping=false, composedSchemas=null, hasMultipleTypes=false, schema=CodegenProperty{openApiType='integer', baseName='CountLimitSchema', complexType='null', getter='getCountLimit', setter='setCountLimit', description='null', dataType='int', datatypeWithEnum='int', dataFormat='int32', name='count_limit', min='null', max='null', defaultValue='-1', defaultValueWithParam=' = data.countLimit;', baseType='int', containerType='null', title='null', unescapedDescription='null', maxLength=null, minLength=null, pattern='null', example='-1', jsonSchema='{
  "type" : "integer",
  "format" : "int32",
  "default" : -1
}', minimum='null', maximum='null', exclusiveMinimum=false, exclusiveMaximum=false, required=false, deprecated=false, hasMoreNonReadOnly=false, isPrimitiveType=true, isModel=false, isContainer=false, isString=false, isNumeric=false, isInteger=true, isShort=false, isLong=false, isUnboundedInteger=false, isNumber=false, isFloat=false, isDouble=false, isDecimal=false, isByteArray=false, isBinary=false, isFile=false, isBoolean=false, isDate=false, isDateTime=false, isUuid=false, isUri=false, isEmail=false, isFreeFormObject=false, isArray=false, isMap=false, isEnum=false, isInnerEnum=false, isAnyType=false, isReadOnly=false, isWriteOnly=false, isNullable=false, isSelfReference=false, isCircularReference=false, isDiscriminator=false, _enum=null, allowableValues=null, items=null, additionalProperties=null, vars=[], requiredVars=[], mostInnerItems=null, vendorExtensions={}, hasValidation=false, isInherited=false, discriminatorValue='null', nameInCamelCase='CountLimit', nameInSnakeCase='null', enumName='null', maxItems=null, minItems=null, maxProperties=null, minProperties=null, uniqueItems=false, uniqueItemsBoolean=null, multipleOf=null, isXmlAttribute=false, xmlPrefix='null', xmlName='null', xmlNamespace='null', isXmlWrapped=false, isNull=false, getAdditionalPropertiesIsAnyType=false, getHasVars=false, getHasRequired=false, getHasDiscriminatorWithNonEmptyMapping=false, composedSchemas=null, hasMultipleTypes=false, requiredVarsMap=null, ref=null, schemaIsFromAdditionalProperties=false, isBooleanSchemaTrue=false, isBooleanSchemaFalse=false, format=int32, dependentRequired=null, contains=null}, content=null, requiredVarsMap=null, ref=null, schemaIsFromAdditionalProperties=false})
task_id = "taskId_example" # str | The ID of the task which contains the basic find activities request. (optional)
context_id = "contextId_example" # str | The ID of the context which the activities should be searched for. (optional)
involved_people_ids = [
        "involvedPeopleIds_example"
    ] # [str] | The list of IDs of the people that should be involved in searched activities. (optional)
involved_role_ids = [
        "involvedRoleIds_example"
    ] # [str] | The list of IDs of the roles that should be involved in searched activities. (optional)
performed_by_user_id = "performedByUserId_example" # str | The ID of the user who performed searched activities. (optional)
performed_by_role_ids = [
        "performedByRoleIds_example"
    ] # [str] | The list of IDs of the roles assigned to users who performed searched activities. (optional)
activity_type = "ADD" # str | The type of the activity. (optional)
call_id = "callId_example" # str | The ID of the call. (optional)
categories = [
        "ATTRIBUTE"
    ] # [str] | The set of the categories of activities that should be searched. One of [ATTRIBUTE, ATTACHMENT, RELATION, COMMENT,<br/>STATUS, WORKFLOW, RESPONSIBILITY, USER, USER_GROUP, ROLE, TAGS, OTHERS]. (optional)
resource_types = [
        "View"
    ] # [str] | The set of the resource types that searched activities refer to, i.e. [Community, Asset, Domain, Attribute,<br/>Relation, WorkflowInstance]. (optional)
start_date = 1 # int | TThe start date of the searched activities. It is the timestamp (in UTC time standard). (optional)
end_date = 1 # int | The end date of the searched activities. It is the timestamp (in UTC time standard). (optional)
call_count_enabled = False # bool | Flag to indicate if the number of calls standing behind the activity should be returned or not.<br/>Note that by default that count will be not calculated as it brings an important performance penalty. (optional) (default to CodegenParameter{isFormParam=false, isQueryParam=true, isPathParam=false, isHeaderParam=false, isCookieParam=false, isBodyParam=false, isContainer=false, isCollectionFormatMulti=false, isPrimitiveType=true, isModel=false, isExplode=true, baseName='callCountEnabled', paramName='call_count_enabled', dataType='bool', datatypeWithEnum='null', dataFormat='null', collectionFormat='null', description='Flag to indicate if the number of calls standing behind the activity should be returned or not.<br/>Note that by default that count will be not calculated as it brings an important performance penalty.', unescapedDescription='Flag to indicate if the number of calls standing behind the activity should be returned or not.<br/>Note that by default that count will be not calculated as it brings an important performance penalty.', baseType='null', defaultValue='False', enumDefaultValue='null', enumName='null', style='FORM', deepObject='false', allowEmptyValue='false', example='False', jsonSchema='{
  "name" : "callCountEnabled",
  "in" : "query",
  "description" : "Flag to indicate if the number of calls standing behind the activity should be returned or not.<br/>Note that by default that count will be not calculated as it brings an important performance penalty.",
  "required" : false,
  "style" : "form",
  "explode" : true,
  "schema" : {
    "type" : "boolean",
    "default" : false
  }
}', isString=false, isNumeric=false, isInteger=false, isShort=false, isLong=false, isUnboundedInteger=false, isNumber=false, isFloat=false, isDouble=false, isDecimal=false, isByteArray=false, isBinary=false, isBoolean=true, isDate=false, isDateTime=false, isUuid=false, isUri=false, isEmail=false, isFreeFormObject=false, isAnyType=false, isArray=false, isMap=false, isFile=false, isEnum=false, _enum=null, allowableValues=null, items=null, mostInnerItems=null, additionalProperties=null, vars=[], requiredVars=[], vendorExtensions={}, hasValidation=false, maxProperties=null, minProperties=null, isNullable=false, isDeprecated=false, required=false, maximum='null', exclusiveMaximum=false, minimum='null', exclusiveMinimum=false, maxLength=null, minLength=null, pattern='null', maxItems=null, minItems=null, uniqueItems=false, uniqueItemsBoolean=null, contentType=null, multipleOf=null, isNull=false, getAdditionalPropertiesIsAnyType=false, getHasVars=false, getHasRequired=false, getHasDiscriminatorWithNonEmptyMapping=false, composedSchemas=null, hasMultipleTypes=false, schema=CodegenProperty{openApiType='boolean', baseName='CallCountEnabledSchema', complexType='null', getter='getCallCountEnabled', setter='setCallCountEnabled', description='null', dataType='bool', datatypeWithEnum='bool', dataFormat='null', name='call_count_enabled', min='null', max='null', defaultValue='False', defaultValueWithParam=' = data.callCountEnabled;', baseType='bool', containerType='null', title='null', unescapedDescription='null', maxLength=null, minLength=null, pattern='null', example='False', jsonSchema='{
  "type" : "boolean",
  "default" : false
}', minimum='null', maximum='null', exclusiveMinimum=false, exclusiveMaximum=false, required=false, deprecated=false, hasMoreNonReadOnly=false, isPrimitiveType=true, isModel=false, isContainer=false, isString=false, isNumeric=false, isInteger=false, isShort=false, isLong=false, isUnboundedInteger=false, isNumber=false, isFloat=false, isDouble=false, isDecimal=false, isByteArray=false, isBinary=false, isFile=false, isBoolean=true, isDate=false, isDateTime=false, isUuid=false, isUri=false, isEmail=false, isFreeFormObject=false, isArray=false, isMap=false, isEnum=false, isInnerEnum=false, isAnyType=false, isReadOnly=false, isWriteOnly=false, isNullable=false, isSelfReference=false, isCircularReference=false, isDiscriminator=false, _enum=null, allowableValues=null, items=null, additionalProperties=null, vars=[], requiredVars=[], mostInnerItems=null, vendorExtensions={}, hasValidation=false, isInherited=false, discriminatorValue='null', nameInCamelCase='CallCountEnabled', nameInSnakeCase='null', enumName='null', maxItems=null, minItems=null, maxProperties=null, minProperties=null, uniqueItems=false, uniqueItemsBoolean=null, multipleOf=null, isXmlAttribute=false, xmlPrefix='null', xmlName='null', xmlNamespace='null', isXmlWrapped=false, isNull=false, getAdditionalPropertiesIsAnyType=false, getHasVars=false, getHasRequired=false, getHasDiscriminatorWithNonEmptyMapping=false, composedSchemas=null, hasMultipleTypes=false, requiredVarsMap=null, ref=null, schemaIsFromAdditionalProperties=false, isBooleanSchemaTrue=false, isBooleanSchemaFalse=false, format=null, dependentRequired=null, contains=null}, content=null, requiredVarsMap=null, ref=null, schemaIsFromAdditionalProperties=false})

    try:
        # Returns activities matching the given search criteria.
        api_response = api_instance.get_activities(offset=offsetlimit=limitcount_limit=count_limittask_id=task_idcontext_id=context_idinvolved_people_ids=involved_people_idsinvolved_role_ids=involved_role_idsperformed_by_user_id=performed_by_user_idperformed_by_role_ids=performed_by_role_idsactivity_type=activity_typecall_id=call_idcategories=categoriesresource_types=resource_typesstart_date=start_dateend_date=end_datecall_count_enabled=call_count_enabled)
        pprint(api_response)
    except collibra_core.ApiException as e:
        print("Exception when calling ActivitiesApi->get_activities: %s\n" % e)
```

## Documentation for API Endpoints

All URIs are relative to *http://localhost/rest/2.0*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*ActivitiesApi* | [**get_activities**](docs/apis/tags/ActivitiesApi.md#get_activities) | **get** /activities | Returns activities matching the given search criteria.
*ApplicationApi* | [**get_info**](docs/apis/tags/ApplicationApi.md#get_info) | **get** /application/info | Returns the basic information about the application.
*AssetTypesApi* | [**add_asset_type**](docs/apis/tags/AssetTypesApi.md#add_asset_type) | **post** /assetTypes | Add asset type
*AssetTypesApi* | [**add_asset_types**](docs/apis/tags/AssetTypesApi.md#add_asset_types) | **post** /assetTypes/bulk | Add multiple asset types
*AssetTypesApi* | [**change_asset_type**](docs/apis/tags/AssetTypesApi.md#change_asset_type) | **patch** /assetTypes/{assetTypeId} | Change asset type
*AssetTypesApi* | [**change_asset_types**](docs/apis/tags/AssetTypesApi.md#change_asset_types) | **patch** /assetTypes/bulk | Change multiple asset types
*AssetTypesApi* | [**find_asset_types**](docs/apis/tags/AssetTypesApi.md#find_asset_types) | **get** /assetTypes | Find asset types matching criteria
*AssetTypesApi* | [**find_parent_types**](docs/apis/tags/AssetTypesApi.md#find_parent_types) | **get** /assetTypes/{assetTypeId}/parents | Find parent types
*AssetTypesApi* | [**find_sub_asset_types**](docs/apis/tags/AssetTypesApi.md#find_sub_asset_types) | **get** /assetTypes/{assetTypeId}/subTypes | Find asset subtypes
*AssetTypesApi* | [**get_asset_type**](docs/apis/tags/AssetTypesApi.md#get_asset_type) | **get** /assetTypes/{assetTypeId} | Get asset type by ID
*AssetTypesApi* | [**remove_asset_type**](docs/apis/tags/AssetTypesApi.md#remove_asset_type) | **delete** /assetTypes/{assetTypeId} | Remove asset type by ID
*AssetTypesApi* | [**remove_asset_types**](docs/apis/tags/AssetTypesApi.md#remove_asset_types) | **delete** /assetTypes/bulk | Remove multiple asset types
*AssetsApi* | [**add_asset**](docs/apis/tags/AssetsApi.md#add_asset) | **post** /assets | Add asset
*AssetsApi* | [**add_assets**](docs/apis/tags/AssetsApi.md#add_assets) | **post** /assets/bulk | Add multiple assets
*AssetsApi* | [**add_tags_to_asset**](docs/apis/tags/AssetsApi.md#add_tags_to_asset) | **post** /assets/{assetId}/tags | Add tags
*AssetsApi* | [**change_asset**](docs/apis/tags/AssetsApi.md#change_asset) | **patch** /assets/{assetId} | Change asset
*AssetsApi* | [**change_assets**](docs/apis/tags/AssetsApi.md#change_assets) | **patch** /assets/bulk | Change multiple assets
*AssetsApi* | [**find_assets**](docs/apis/tags/AssetsApi.md#find_assets) | **get** /assets | Find assets
*AssetsApi* | [**get_asset**](docs/apis/tags/AssetsApi.md#get_asset) | **get** /assets/{assetId} | Get asset
*AssetsApi* | [**get_asset_breadcrumb**](docs/apis/tags/AssetsApi.md#get_asset_breadcrumb) | **get** /assets/{assetId}/breadcrumb | Get asset breadcrumb
*AssetsApi* | [**get_asset_tags**](docs/apis/tags/AssetsApi.md#get_asset_tags) | **get** /assets/{assetId}/tags | Get asset tags
*AssetsApi* | [**remove_asset**](docs/apis/tags/AssetsApi.md#remove_asset) | **delete** /assets/{assetId} | Remove asset
*AssetsApi* | [**remove_assets**](docs/apis/tags/AssetsApi.md#remove_assets) | **delete** /assets/bulk | Remove assets
*AssetsApi* | [**remove_tags_from_asset**](docs/apis/tags/AssetsApi.md#remove_tags_from_asset) | **delete** /assets/{assetId}/tags | Remove tags
*AssetsApi* | [**set_asset_attributes**](docs/apis/tags/AssetsApi.md#set_asset_attributes) | **put** /assets/{assetId}/attributes | Set asset attributes
*AssetsApi* | [**set_asset_relations**](docs/apis/tags/AssetsApi.md#set_asset_relations) | **put** /assets/{assetId}/relations | Set asset relations
*AssetsApi* | [**set_asset_responsibilities**](docs/apis/tags/AssetsApi.md#set_asset_responsibilities) | **put** /assets/{assetId}/responsibilities | Set asset responsibilities
*AssetsApi* | [**set_tags_for_asset**](docs/apis/tags/AssetsApi.md#set_tags_for_asset) | **put** /assets/{assetId}/tags | Set asset tags
*AssignmentsApi* | [**add_assignment**](docs/apis/tags/AssignmentsApi.md#add_assignment) | **post** /assignments | Adds a new Assignment.
*AssignmentsApi* | [**change_assignment**](docs/apis/tags/AssignmentsApi.md#change_assignment) | **patch** /assignments/{assignmentId} | Changes the assignment with the information that is provided in the request.
*AssignmentsApi* | [**find_assignments_for_resource**](docs/apis/tags/AssignmentsApi.md#find_assignments_for_resource) | **get** /assignments/forResource | Find the assignments where a given resource is assigned.
*AssignmentsApi* | [**get_assignments_for_asset**](docs/apis/tags/AssignmentsApi.md#get_assignments_for_asset) | **get** /assignments/asset/{assetId} | Returns the Assignment identified by the given Asset.
*AssignmentsApi* | [**get_assignments_for_asset_type**](docs/apis/tags/AssignmentsApi.md#get_assignments_for_asset_type) | **get** /assignments/assetType/{assetTypeId} | Returns Assignments for given asset type id.
*AssignmentsApi* | [**get_available_asset_types_for_domain**](docs/apis/tags/AssignmentsApi.md#get_available_asset_types_for_domain) | **get** /assignments/domain/{domainId}/assetTypes | Returns available asset types for domain identified by given id.
*AssignmentsApi* | [**get_available_attribute_types_for_asset**](docs/apis/tags/AssignmentsApi.md#get_available_attribute_types_for_asset) | **get** /assignments/asset/{assetId}/attributeTypes | Returns available attribute types for asset identified by given id.
*AssignmentsApi* | [**get_available_complex_relation_types_for_asset**](docs/apis/tags/AssignmentsApi.md#get_available_complex_relation_types_for_asset) | **get** /assignments/asset/{assetId}/complexRelationTypes | Returns the available ComplexRelationTypes for the Asset identified by the given id.
*AssignmentsApi* | [**get_available_relation_types_for_asset**](docs/apis/tags/AssignmentsApi.md#get_available_relation_types_for_asset) | **get** /assignments/asset/{assetId}/relationTypes | Returns the available RelationTypes for the Asset identified by the given id.
*AssignmentsApi* | [**remove_assignment**](docs/apis/tags/AssignmentsApi.md#remove_assignment) | **delete** /assignments/{assignmentId} | Removes the Assignment identified by the given id.
*AttachmentsApi* | [**add_attachment**](docs/apis/tags/AttachmentsApi.md#add_attachment) | **post** /attachments | Add attachment
*AttachmentsApi* | [**find_attachments**](docs/apis/tags/AttachmentsApi.md#find_attachments) | **get** /attachments | Find attachments
*AttachmentsApi* | [**get_attachment**](docs/apis/tags/AttachmentsApi.md#get_attachment) | **get** /attachments/{attachmentId} | Get attachment
*AttachmentsApi* | [**get_attachment_content**](docs/apis/tags/AttachmentsApi.md#get_attachment_content) | **get** /attachments/{attachmentId}/file | Get attachment content
*AttachmentsApi* | [**remove_attachment**](docs/apis/tags/AttachmentsApi.md#remove_attachment) | **delete** /attachments/{attachmentId} | Remove attachment
*AttributeTypesApi* | [**add_attribute_type**](docs/apis/tags/AttributeTypesApi.md#add_attribute_type) | **post** /attributeTypes | Adds a new Attribute Type.
*AttributeTypesApi* | [**add_attribute_types**](docs/apis/tags/AttributeTypesApi.md#add_attribute_types) | **post** /attributeTypes/bulk | Adds multiple Attribute Types.
*AttributeTypesApi* | [**change_attribute_type**](docs/apis/tags/AttributeTypesApi.md#change_attribute_type) | **patch** /attributeTypes/{attributeTypeId} | Changes the attribute types.
*AttributeTypesApi* | [**change_attribute_types**](docs/apis/tags/AttributeTypesApi.md#change_attribute_types) | **patch** /attributeTypes/bulk | Changes multiple attribute types.
*AttributeTypesApi* | [**find_attribute_types**](docs/apis/tags/AttributeTypesApi.md#find_attribute_types) | **get** /attributeTypes | Returns attribute types matching the given search criteria.
*AttributeTypesApi* | [**get_attribute_type**](docs/apis/tags/AttributeTypesApi.md#get_attribute_type) | **get** /attributeTypes/{attributeTypeId} | Returns the attribute type identified by given UUID.
*AttributeTypesApi* | [**get_attribute_type_by_name**](docs/apis/tags/AttributeTypesApi.md#get_attribute_type_by_name) | **get** /attributeTypes/name/{attributeTypeName} | Returns the attribute type identified by given name.
*AttributeTypesApi* | [**remove_attribute_type**](docs/apis/tags/AttributeTypesApi.md#remove_attribute_type) | **delete** /attributeTypes/{attributeTypeId} | Removes attribute type identified by given UUID.
*AttributeTypesApi* | [**remove_attribute_types**](docs/apis/tags/AttributeTypesApi.md#remove_attribute_types) | **delete** /attributeTypes/bulk | Removes multiple attribute types.
*AttributesApi* | [**add_attribute**](docs/apis/tags/AttributesApi.md#add_attribute) | **post** /attributes | Add attribute
*AttributesApi* | [**add_attributes**](docs/apis/tags/AttributesApi.md#add_attributes) | **post** /attributes/bulk | Add attributes
*AttributesApi* | [**change_attribute**](docs/apis/tags/AttributesApi.md#change_attribute) | **patch** /attributes/{attributeId} | Change attribute
*AttributesApi* | [**change_attributes**](docs/apis/tags/AttributesApi.md#change_attributes) | **patch** /attributes/bulk | Change attributes
*AttributesApi* | [**find_attributes**](docs/apis/tags/AttributesApi.md#find_attributes) | **get** /attributes | Find attributes
*AttributesApi* | [**get_attribute**](docs/apis/tags/AttributesApi.md#get_attribute) | **get** /attributes/{attributeId} | Get attribute
*AttributesApi* | [**remove_attribute**](docs/apis/tags/AttributesApi.md#remove_attribute) | **delete** /attributes/{attributeId} | Remove attribute
*AttributesApi* | [**remove_attributes**](docs/apis/tags/AttributesApi.md#remove_attributes) | **delete** /attributes/bulk | Remove attributes
*AuthenticationSessionsApi* | [**current_session**](docs/apis/tags/AuthenticationSessionsApi.md#current_session) | **get** /auth/sessions/current | Get session
*AuthenticationSessionsApi* | [**heartbeat**](docs/apis/tags/AuthenticationSessionsApi.md#heartbeat) | **get** /auth/sessions/heartbeat | Checks if the user session is active
*AuthenticationSessionsApi* | [**login**](docs/apis/tags/AuthenticationSessionsApi.md#login) | **post** /auth/sessions | Login
*AuthenticationSessionsApi* | [**logout**](docs/apis/tags/AuthenticationSessionsApi.md#logout) | **delete** /auth/sessions/current | Logout
*CommentsApi* | [**add_comment**](docs/apis/tags/CommentsApi.md#add_comment) | **post** /comments | Add comment.
*CommentsApi* | [**change_comment**](docs/apis/tags/CommentsApi.md#change_comment) | **patch** /comments/{commentId} | Change comment.
*CommentsApi* | [**find_comments**](docs/apis/tags/CommentsApi.md#find_comments) | **get** /comments | Find comments.
*CommentsApi* | [**get_comment**](docs/apis/tags/CommentsApi.md#get_comment) | **get** /comments/{commentId} | Get comment.
*CommentsApi* | [**remove_comment**](docs/apis/tags/CommentsApi.md#remove_comment) | **delete** /comments/{commentId} | Remove comment.
*CommunitiesApi* | [**add_communities**](docs/apis/tags/CommunitiesApi.md#add_communities) | **post** /communities/bulk | Add multiple communities
*CommunitiesApi* | [**add_community**](docs/apis/tags/CommunitiesApi.md#add_community) | **post** /communities | Add community
*CommunitiesApi* | [**change_communities**](docs/apis/tags/CommunitiesApi.md#change_communities) | **patch** /communities/bulk | Change multiple communities
*CommunitiesApi* | [**change_community**](docs/apis/tags/CommunitiesApi.md#change_community) | **patch** /communities/{communityId} | Change community
*CommunitiesApi* | [**change_to_root_community**](docs/apis/tags/CommunitiesApi.md#change_to_root_community) | **post** /communities/{communityId}/root | Change to root community
*CommunitiesApi* | [**find_communities**](docs/apis/tags/CommunitiesApi.md#find_communities) | **get** /communities | Find communities
*CommunitiesApi* | [**get_community**](docs/apis/tags/CommunitiesApi.md#get_community) | **get** /communities/{communityId} | Get community
*CommunitiesApi* | [**get_community_breadcrumb**](docs/apis/tags/CommunitiesApi.md#get_community_breadcrumb) | **get** /communities/{communityId}/breadcrumb | Get community breadcrumb
*CommunitiesApi* | [**remove_communities**](docs/apis/tags/CommunitiesApi.md#remove_communities) | **delete** /communities/bulk | Remove multiple communities
*CommunitiesApi* | [**remove_communities_in_job**](docs/apis/tags/CommunitiesApi.md#remove_communities_in_job) | **post** /communities/removalJobs | Remove multiple communities asynchronously
*CommunitiesApi* | [**remove_community**](docs/apis/tags/CommunitiesApi.md#remove_community) | **delete** /communities/{communityId} | Remove community
*ComplexRelationTypesApi* | [**add_complex_relation_type**](docs/apis/tags/ComplexRelationTypesApi.md#add_complex_relation_type) | **post** /complexRelationTypes | Adds a new complex relation type.
*ComplexRelationTypesApi* | [**change_complex_relation_type**](docs/apis/tags/ComplexRelationTypesApi.md#change_complex_relation_type) | **patch** /complexRelationTypes/{complexRelationTypeId} | Changes the complex relation type.
*ComplexRelationTypesApi* | [**find_complex_relation_types**](docs/apis/tags/ComplexRelationTypesApi.md#find_complex_relation_types) | **get** /complexRelationTypes | Returns complex relation types matching the given search criteria.
*ComplexRelationTypesApi* | [**get_complex_relation_type**](docs/apis/tags/ComplexRelationTypesApi.md#get_complex_relation_type) | **get** /complexRelationTypes/{complexRelationTypeId} | Returns complex relation type identified by given UUID.
*ComplexRelationTypesApi* | [**remove_complex_relation_type**](docs/apis/tags/ComplexRelationTypesApi.md#remove_complex_relation_type) | **delete** /complexRelationTypes/{complexRelationTypeId} | Removes complex relation type identified by given UUID.
*ComplexRelationsApi* | [**add_complex_relation**](docs/apis/tags/ComplexRelationsApi.md#add_complex_relation) | **post** /complexRelations | Adds new complex relation.
*ComplexRelationsApi* | [**change_complex_relation**](docs/apis/tags/ComplexRelationsApi.md#change_complex_relation) | **patch** /complexRelations/{complexRelationId} | Change the complex relation with the information that is present in the request.
*ComplexRelationsApi* | [**export_to_csv**](docs/apis/tags/ComplexRelationsApi.md#export_to_csv) | **post** /complexRelations/export/csv-job | Export complex relations of the given type to CSV.
*ComplexRelationsApi* | [**export_to_csv_without_job**](docs/apis/tags/ComplexRelationsApi.md#export_to_csv_without_job) | **post** /complexRelations/export/csv-file | Export all complex relations of the given type to a CSV file.
*ComplexRelationsApi* | [**export_to_csvas_string**](docs/apis/tags/ComplexRelationsApi.md#export_to_csvas_string) | **post** /complexRelations/export/csv | Export all complex relations of the given type to CSV as a String.
*ComplexRelationsApi* | [**export_to_excel**](docs/apis/tags/ComplexRelationsApi.md#export_to_excel) | **post** /complexRelations/export/excel-job | Export complex relations of the given type to Excel.
*ComplexRelationsApi* | [**export_to_excel_without_job**](docs/apis/tags/ComplexRelationsApi.md#export_to_excel_without_job) | **post** /complexRelations/export/excel-file | Export all complex relations of the given type to an Excel file.
*ComplexRelationsApi* | [**find_complex_relations**](docs/apis/tags/ComplexRelationsApi.md#find_complex_relations) | **get** /complexRelations | Returns complex relations matching the given search criteria.
*ComplexRelationsApi* | [**get_complex_relation**](docs/apis/tags/ComplexRelationsApi.md#get_complex_relation) | **get** /complexRelations/{complexRelationId} | Returns a ComplexRelation identified by given id.
*ComplexRelationsApi* | [**remove_complex_relation**](docs/apis/tags/ComplexRelationsApi.md#remove_complex_relation) | **delete** /complexRelations/{complexRelationId} | Removes complex relation identified by given id.
*DataQualityRulesApi* | [**add_data_quality_rule**](docs/apis/tags/DataQualityRulesApi.md#add_data_quality_rule) | **post** /dataQualityRules | Adds a new data quality rule.
*DataQualityRulesApi* | [**change_data_quality_rule**](docs/apis/tags/DataQualityRulesApi.md#change_data_quality_rule) | **patch** /dataQualityRules/{dataQualityRuleId} | Changes the data quality rule with the information that is present in the request.
*DataQualityRulesApi* | [**find_data_quality_rules**](docs/apis/tags/DataQualityRulesApi.md#find_data_quality_rules) | **get** /dataQualityRules | Returns data quality rules matching the given search criteria.
*DataQualityRulesApi* | [**get_data_quality_rule**](docs/apis/tags/DataQualityRulesApi.md#get_data_quality_rule) | **get** /dataQualityRules/{dataQualityRuleId} | Returns the DataQualityRule identified by given id.
*DataQualityRulesApi* | [**remove_data_quality_rule**](docs/apis/tags/DataQualityRulesApi.md#remove_data_quality_rule) | **delete** /dataQualityRules/{dataQualityRuleId} | Removes the DataQualityRule identified by the given id.
*DiagramPicturesApi* | [**add_diagram_picture**](docs/apis/tags/DiagramPicturesApi.md#add_diagram_picture) | **post** /diagramPictures | Adds a diagram picture.
*DomainTypesApi* | [**add_domain_type**](docs/apis/tags/DomainTypesApi.md#add_domain_type) | **post** /domainTypes | Adds a new domain type.
*DomainTypesApi* | [**add_domain_types**](docs/apis/tags/DomainTypesApi.md#add_domain_types) | **post** /domainTypes/bulk | Adds multiple new domain types.
*DomainTypesApi* | [**change_domain_type**](docs/apis/tags/DomainTypesApi.md#change_domain_type) | **patch** /domainTypes/{domainTypeId} | Changes the domain type.
*DomainTypesApi* | [**change_domain_types**](docs/apis/tags/DomainTypesApi.md#change_domain_types) | **patch** /domainTypes/bulk | Changes the domain types.
*DomainTypesApi* | [**find_domain_types**](docs/apis/tags/DomainTypesApi.md#find_domain_types) | **get** /domainTypes | Returns domain types matching the given search criteria.
*DomainTypesApi* | [**find_sub_domain_types**](docs/apis/tags/DomainTypesApi.md#find_sub_domain_types) | **get** /domainTypes/{domainTypeId}/subTypes | Returns sub domain types matching the given search criteria.
*DomainTypesApi* | [**get_domain_type**](docs/apis/tags/DomainTypesApi.md#get_domain_type) | **get** /domainTypes/{domainTypeId} | Returns domain type identified by given UUID.
*DomainTypesApi* | [**remove_domain_type**](docs/apis/tags/DomainTypesApi.md#remove_domain_type) | **delete** /domainTypes/{domainTypeId} | Removes domain type identified by given UUID.
*DomainTypesApi* | [**remove_domain_types**](docs/apis/tags/DomainTypesApi.md#remove_domain_types) | **delete** /domainTypes/bulk | Removes multiple domain types.
*DomainsApi* | [**add_domain**](docs/apis/tags/DomainsApi.md#add_domain) | **post** /domains | Add domain
*DomainsApi* | [**add_domains**](docs/apis/tags/DomainsApi.md#add_domains) | **post** /domains/bulk | Add multpile domains
*DomainsApi* | [**change_domain**](docs/apis/tags/DomainsApi.md#change_domain) | **patch** /domains/{domainId} | Change domain
*DomainsApi* | [**change_domains**](docs/apis/tags/DomainsApi.md#change_domains) | **patch** /domains/bulk | Change multiple domains
*DomainsApi* | [**find_domains**](docs/apis/tags/DomainsApi.md#find_domains) | **get** /domains | Search domains
*DomainsApi* | [**get_domain**](docs/apis/tags/DomainsApi.md#get_domain) | **get** /domains/{domainId} | Get domain
*DomainsApi* | [**get_domain_breadcrumb**](docs/apis/tags/DomainsApi.md#get_domain_breadcrumb) | **get** /domains/{domainId}/breadcrumb | Get domain breadcrumb
*DomainsApi* | [**remove_domain**](docs/apis/tags/DomainsApi.md#remove_domain) | **delete** /domains/{domainId} | Remove domain
*DomainsApi* | [**remove_domains**](docs/apis/tags/DomainsApi.md#remove_domains) | **delete** /domains/bulk | Remove multiple domains
*DomainsApi* | [**remove_domains_in_job**](docs/apis/tags/DomainsApi.md#remove_domains_in_job) | **post** /domains/removalJobs | Remove multiple domains asynchronously
*FilesApi* | [**add_files**](docs/apis/tags/FilesApi.md#add_files) | **post** /files | Upload files
*FilesApi* | [**delete_file**](docs/apis/tags/FilesApi.md#delete_file) | **delete** /files/{fileId} | 
*FilesApi* | [**get_file**](docs/apis/tags/FilesApi.md#get_file) | **get** /files/{fileId} | Download file
*FilesApi* | [**get_file_info**](docs/apis/tags/FilesApi.md#get_file_info) | **get** /files/{fileId}/info | Get file information
*IssuesApi* | [**add_issue**](docs/apis/tags/IssuesApi.md#add_issue) | **post** /issues | Adds a new issue.
*IssuesApi* | [**find_issues**](docs/apis/tags/IssuesApi.md#find_issues) | **get** /issues | Returns issues matching the given search criteria.
*IssuesApi* | [**move_issue**](docs/apis/tags/IssuesApi.md#move_issue) | **patch** /issues/{issueId}/community/{communityId} | Moves an issue to another community.
*JDBCDriverApi* | [**find_jdbc_drivers**](docs/apis/tags/JDBCDriverApi.md#find_jdbc_drivers) | **get** /jdbc | Find JDBC Drivers
*JobsApi* | [**cancel_job**](docs/apis/tags/JobsApi.md#cancel_job) | **post** /jobs/{jobId}/canceled | Cancels given Job.
*JobsApi* | [**find_jobs**](docs/apis/tags/JobsApi.md#find_jobs) | **get** /jobs | Find jobs
*JobsApi* | [**get_job**](docs/apis/tags/JobsApi.md#get_job) | **get** /jobs/{jobId} | Returns the Job identified by the given UUID.
*MappingsApi* | [**add_mapping**](docs/apis/tags/MappingsApi.md#add_mapping) | **post** /mappings | Adds a new mapping.
*MappingsApi* | [**add_mappings**](docs/apis/tags/MappingsApi.md#add_mappings) | **post** /mappings/bulk | Adds new mappings.
*MappingsApi* | [**change_mapping**](docs/apis/tags/MappingsApi.md#change_mapping) | **patch** /mappings/{mappingId} | Changes the mapping identified by its id.
*MappingsApi* | [**change_mapping_by_external_entity**](docs/apis/tags/MappingsApi.md#change_mapping_by_external_entity) | **patch** /mappings/externalSystem/{externalSystemId}/externalEntity/{externalEntityId} | Changes the mapping identified by its external ids.
*MappingsApi* | [**change_mapping_by_mapped_resource**](docs/apis/tags/MappingsApi.md#change_mapping_by_mapped_resource) | **patch** /mappings/externalSystem/{externalSystemId}/mappedResource/{mappedResourceId} | Changes the mapping identified by its external system id and mapped resource id.
*MappingsApi* | [**change_mappings**](docs/apis/tags/MappingsApi.md#change_mappings) | **patch** /mappings/bulk | Changes multiple mappings identified by their ids.
*MappingsApi* | [**change_mappings_by_external_entities**](docs/apis/tags/MappingsApi.md#change_mappings_by_external_entities) | **patch** /mappings/externalSystem/externalEntity/bulk | Changes the mappings identified by their external ids.
*MappingsApi* | [**change_mappings_by_mapped_resources**](docs/apis/tags/MappingsApi.md#change_mappings_by_mapped_resources) | **patch** /mappings/externalSystem/mappedResource/bulk | Changes the mapping identified by their external system ids and mapped resource ids.
*MappingsApi* | [**find_mappings**](docs/apis/tags/MappingsApi.md#find_mappings) | **get** /mappings | Returns mappings matching the given search criteria.
*MappingsApi* | [**get_mapping**](docs/apis/tags/MappingsApi.md#get_mapping) | **get** /mappings/{mappingId} | Returns a mapping identified by given id.
*MappingsApi* | [**get_mapping_by_external_entity**](docs/apis/tags/MappingsApi.md#get_mapping_by_external_entity) | **get** /mappings/externalSystem/{externalSystemId}/externalEntity/{externalEntityId} | Returns a mapping identified by its external ids.
*MappingsApi* | [**get_mapping_by_mapped_resource**](docs/apis/tags/MappingsApi.md#get_mapping_by_mapped_resource) | **get** /mappings/externalSystem/{externalSystemId}/mappedResource/{mappedResourceId} | Returns a mapping identified by its external system id and mapped resource id.
*MappingsApi* | [**remove_mapping**](docs/apis/tags/MappingsApi.md#remove_mapping) | **delete** /mappings/{mappingId} | Removes the mapping identified by its id.
*MappingsApi* | [**remove_mapping_by_external_entity**](docs/apis/tags/MappingsApi.md#remove_mapping_by_external_entity) | **delete** /mappings/externalSystem/{externalSystemId}/externalEntity/{externalEntityId} | Removes the mapping identified by its external ids.
*MappingsApi* | [**remove_mapping_by_mapped_resource**](docs/apis/tags/MappingsApi.md#remove_mapping_by_mapped_resource) | **delete** /mappings/externalSystem/{externalSystemId}/mappedResource/{mappedResourceId} | Removes the mapping identified by its external system id and mapped resource id.
*MappingsApi* | [**remove_mappings_by_external_system_in_job**](docs/apis/tags/MappingsApi.md#remove_mappings_by_external_system_in_job) | **post** /mappings/externalSystem/{externalSystemId}/removalJobs | Removes all the mappings identified by given external system id.
*MappingsApi* | [**remove_mappings_in_job**](docs/apis/tags/MappingsApi.md#remove_mappings_in_job) | **post** /mappings/removalJobs | Removes multiple mappings in job.
*NavigationStatisticsApi* | [**find_most_viewed_assets**](docs/apis/tags/NavigationStatisticsApi.md#find_most_viewed_assets) | **get** /navigation/most_viewed | Find most viewed assets.
*NavigationStatisticsApi* | [**find_recently_viewed_assets**](docs/apis/tags/NavigationStatisticsApi.md#find_recently_viewed_assets) | **get** /navigation/recently_viewed | Find recently viewed assets.
*OutputModuleApi* | [**export_csv**](docs/apis/tags/OutputModuleApi.md#export_csv) | **post** /outputModule/export/csv | Exports results in CSV format, returns the results immediately.
*OutputModuleApi* | [**export_csvin_job**](docs/apis/tags/OutputModuleApi.md#export_csvin_job) | **post** /outputModule/export/csv-job | Exports results in CSV format, returns JSON representation of the async Job.
*OutputModuleApi* | [**export_csvto_file**](docs/apis/tags/OutputModuleApi.md#export_csvto_file) | **post** /outputModule/export/csv-file | Exports results in CSV format, returns information about created file.
*OutputModuleApi* | [**export_excel_in_job**](docs/apis/tags/OutputModuleApi.md#export_excel_in_job) | **post** /outputModule/export/excel-job | Exports results in Excel format, returns JSON representation of the async Job.
*OutputModuleApi* | [**export_excel_to_file**](docs/apis/tags/OutputModuleApi.md#export_excel_to_file) | **post** /outputModule/export/excel-file | Exports results in Excel format, returns information about created file.
*OutputModuleApi* | [**export_json**](docs/apis/tags/OutputModuleApi.md#export_json) | **post** /outputModule/export/json | Exports results in JSON format, returns the results immediately.
*OutputModuleApi* | [**export_jsonin_job**](docs/apis/tags/OutputModuleApi.md#export_jsonin_job) | **post** /outputModule/export/json-job | Exports results in JSON format, returns JSON representation of the async Job.
*OutputModuleApi* | [**export_jsonto_file**](docs/apis/tags/OutputModuleApi.md#export_jsonto_file) | **post** /outputModule/export/json-file | Exports results in JSON format, returns information about created file.
*OutputModuleApi* | [**export_xml**](docs/apis/tags/OutputModuleApi.md#export_xml) | **post** /outputModule/export/xml | Exports results in XML format, returns the results immediately.
*OutputModuleApi* | [**export_xmlin_job**](docs/apis/tags/OutputModuleApi.md#export_xmlin_job) | **post** /outputModule/export/xml-job | Exports results in XML format, returns JSON representation of the async Job.
*OutputModuleApi* | [**export_xmlto_file**](docs/apis/tags/OutputModuleApi.md#export_xmlto_file) | **post** /outputModule/export/xml-file | Exports results in XML format, returns information about created file.
*OutputModuleApi* | [**get_table_view_config_by_view_id**](docs/apis/tags/OutputModuleApi.md#get_table_view_config_by_view_id) | **get** /outputModule/tableViewConfigs/viewId/{viewId} | Returns TableViewConfig based on id of given View and its Location.
*RatingsApi* | [**add_rating**](docs/apis/tags/RatingsApi.md#add_rating) | **post** /ratings | Add rating.
*RatingsApi* | [**change_rating**](docs/apis/tags/RatingsApi.md#change_rating) | **patch** /ratings/{ratingId} | Change rating.
*RatingsApi* | [**find_ratings**](docs/apis/tags/RatingsApi.md#find_ratings) | **get** /ratings | Find ratings.
*RatingsApi* | [**get_rating**](docs/apis/tags/RatingsApi.md#get_rating) | **get** /ratings/{ratingId} | Get rating.
*RatingsApi* | [**remove_rating**](docs/apis/tags/RatingsApi.md#remove_rating) | **delete** /ratings/{ratingId} | Remove rating.
*RelationTypesApi* | [**add_relation_type**](docs/apis/tags/RelationTypesApi.md#add_relation_type) | **post** /relationTypes | Adds a new relation type.
*RelationTypesApi* | [**add_relation_types**](docs/apis/tags/RelationTypesApi.md#add_relation_types) | **post** /relationTypes/bulk | Adds multiple new relation type.
*RelationTypesApi* | [**change_relation_type**](docs/apis/tags/RelationTypesApi.md#change_relation_type) | **patch** /relationTypes/{relationTypeId} | Changes the relation type.
*RelationTypesApi* | [**change_relation_types**](docs/apis/tags/RelationTypesApi.md#change_relation_types) | **patch** /relationTypes/bulk | Changes the relation types.
*RelationTypesApi* | [**find_relation_types**](docs/apis/tags/RelationTypesApi.md#find_relation_types) | **get** /relationTypes | Finds all the relation types matching the given criteria.
*RelationTypesApi* | [**get_relation_type**](docs/apis/tags/RelationTypesApi.md#get_relation_type) | **get** /relationTypes/{relationTypeId} | Returns relation type identified by given UUID.
*RelationTypesApi* | [**remove_relation_type**](docs/apis/tags/RelationTypesApi.md#remove_relation_type) | **delete** /relationTypes/{relationTypeId} | Removes relation type identified by given UUID.
*RelationTypesApi* | [**remove_relation_types**](docs/apis/tags/RelationTypesApi.md#remove_relation_types) | **delete** /relationTypes/bulk | Removes multiple relation types.
*RelationsApi* | [**add_relation**](docs/apis/tags/RelationsApi.md#add_relation) | **post** /relations | Adds a new relation.
*RelationsApi* | [**add_relations**](docs/apis/tags/RelationsApi.md#add_relations) | **post** /relations/bulk | Adds multiple relations in one go.
*RelationsApi* | [**change_relation**](docs/apis/tags/RelationsApi.md#change_relation) | **patch** /relations/{relationId} | Changes the relation with the information that is present in the request.
*RelationsApi* | [**change_relations**](docs/apis/tags/RelationsApi.md#change_relations) | **patch** /relations/bulk | Changes multiple relations.
*RelationsApi* | [**find_relations**](docs/apis/tags/RelationsApi.md#find_relations) | **get** /relations | Returns relations matching the given search criteria.
*RelationsApi* | [**get_relation**](docs/apis/tags/RelationsApi.md#get_relation) | **get** /relations/{relationId} | Returns a relation identified by given id.
*RelationsApi* | [**remove_relation**](docs/apis/tags/RelationsApi.md#remove_relation) | **delete** /relations/{relationId} | Removes a relation identified by given id.
*RelationsApi* | [**remove_relations**](docs/apis/tags/RelationsApi.md#remove_relations) | **delete** /relations/bulk | Removes multiple relations.
*ReportingApi* | [**get_insights_zip**](docs/apis/tags/ReportingApi.md#get_insights_zip) | **get** /reporting/insights/download | Reporting insights download
*ResponsibilitiesApi* | [**add_responsibilities**](docs/apis/tags/ResponsibilitiesApi.md#add_responsibilities) | **post** /responsibilities/bulk | Adds multiple responsibilities in one go.
*ResponsibilitiesApi* | [**add_responsibility**](docs/apis/tags/ResponsibilitiesApi.md#add_responsibility) | **post** /responsibilities | Adds a new responsibility.
*ResponsibilitiesApi* | [**find_responsibilities**](docs/apis/tags/ResponsibilitiesApi.md#find_responsibilities) | **get** /responsibilities | Finds responsibilities.
*ResponsibilitiesApi* | [**get_responsibility**](docs/apis/tags/ResponsibilitiesApi.md#get_responsibility) | **get** /responsibilities/{responsibilityId} | Returns the responsibility identified by the given id.
*ResponsibilitiesApi* | [**remove_responsibilities**](docs/apis/tags/ResponsibilitiesApi.md#remove_responsibilities) | **delete** /responsibilities/bulk | Removes multiple responsibilities in one go.
*ResponsibilitiesApi* | [**remove_responsibility**](docs/apis/tags/ResponsibilitiesApi.md#remove_responsibility) | **delete** /responsibilities/{responsibilityId} | Removes the responsibility identified by the given id.
*RolesApi* | [**add_role**](docs/apis/tags/RolesApi.md#add_role) | **post** /roles | Adds a new role.
*RolesApi* | [**change_role**](docs/apis/tags/RolesApi.md#change_role) | **patch** /roles/{roleId} | Change the role with the given id.
*RolesApi* | [**find_roles**](docs/apis/tags/RolesApi.md#find_roles) | **get** /roles | Returns roles matching the given search criteria.
*RolesApi* | [**get_role**](docs/apis/tags/RolesApi.md#get_role) | **get** /roles/{roleId} | Returns the role identified by the given id.
*RolesApi* | [**remove_role**](docs/apis/tags/RolesApi.md#remove_role) | **delete** /roles/{roleId} | Removes the role identified by the given id.
*SAMLApi* | [**change_certificate**](docs/apis/tags/SAMLApi.md#change_certificate) | **post** /security/saml/certificate/{type} | Changes the certificate to be used with SAML
*SAMLApi* | [**delete_customizations**](docs/apis/tags/SAMLApi.md#delete_customizations) | **delete** /security/saml/certificate/{type} | Delete the specified SAML certificate from the SAML keystore.
*SAMLApi* | [**get_sp_metadata_as_string**](docs/apis/tags/SAMLApi.md#get_sp_metadata_as_string) | **get** /security/saml | Returns the SAML Service Provider metadata for this instance.
*ScopesApi* | [**add_scope**](docs/apis/tags/ScopesApi.md#add_scope) | **post** /scopes | Add scope
*ScopesApi* | [**change_scope**](docs/apis/tags/ScopesApi.md#change_scope) | **patch** /scopes/{scopeId} | Change scope
*ScopesApi* | [**get_all_scopes**](docs/apis/tags/ScopesApi.md#get_all_scopes) | **get** /scopes | Find scopes
*ScopesApi* | [**get_scope**](docs/apis/tags/ScopesApi.md#get_scope) | **get** /scopes/{scopeId} | Get scope
*ScopesApi* | [**remove_scope**](docs/apis/tags/ScopesApi.md#remove_scope) | **delete** /scopes/{scopeId} | Remove scope
*StatusesApi* | [**add_status**](docs/apis/tags/StatusesApi.md#add_status) | **post** /statuses | Adds a new Status.
*StatusesApi* | [**add_statuses**](docs/apis/tags/StatusesApi.md#add_statuses) | **post** /statuses/bulk | Adds multiple statuses in one go.
*StatusesApi* | [**change_status**](docs/apis/tags/StatusesApi.md#change_status) | **patch** /statuses/{statusId} | Changes the status with the information that is present in the request.
*StatusesApi* | [**change_statuses**](docs/apis/tags/StatusesApi.md#change_statuses) | **patch** /statuses/bulk | Changes multiple statuses in one go.
*StatusesApi* | [**find_statuses**](docs/apis/tags/StatusesApi.md#find_statuses) | **get** /statuses | Returns statuses matching the given search criteria.
*StatusesApi* | [**get_status**](docs/apis/tags/StatusesApi.md#get_status) | **get** /statuses/{statusId} | Returns the Status identified by the given id.
*StatusesApi* | [**get_status_by_name**](docs/apis/tags/StatusesApi.md#get_status_by_name) | **get** /statuses/name/{statusName} | Returns the Status identified by the given name.
*StatusesApi* | [**remove_status**](docs/apis/tags/StatusesApi.md#remove_status) | **delete** /statuses/{statusId} | Removes the Status identified by the given id.
*StatusesApi* | [**remove_statuses**](docs/apis/tags/StatusesApi.md#remove_statuses) | **delete** /statuses/bulk | Removes multiple statuses.
*TagsApi* | [**change_tag**](docs/apis/tags/TagsApi.md#change_tag) | **patch** /tags/{tagId} | Change tag.
*TagsApi* | [**exists**](docs/apis/tags/TagsApi.md#exists) | **get** /tags/exists/{tagName} | Check tag name.
*TagsApi* | [**find_tags**](docs/apis/tags/TagsApi.md#find_tags) | **get** /tags | Find tags.
*TagsApi* | [**get_tag**](docs/apis/tags/TagsApi.md#get_tag) | **get** /tags/{tagId} | Get tag.
*TagsApi* | [**get_tags_by_asset_id**](docs/apis/tags/TagsApi.md#get_tags_by_asset_id) | **get** /tags/asset/{assetId} | Get asset tags.
*TagsApi* | [**merge_tags**](docs/apis/tags/TagsApi.md#merge_tags) | **post** /tags/merge | Merge tags.
*TagsApi* | [**remove_tag**](docs/apis/tags/TagsApi.md#remove_tag) | **delete** /tags/{tagId} | Remove tag.
*TagsApi* | [**remove_tags**](docs/apis/tags/TagsApi.md#remove_tags) | **delete** /tags/bulk | Remove tags.
*UserGroupsApi* | [**add_user_group**](docs/apis/tags/UserGroupsApi.md#add_user_group) | **post** /userGroups | Add new user group
*UserGroupsApi* | [**add_users_to_user_group**](docs/apis/tags/UserGroupsApi.md#add_users_to_user_group) | **post** /userGroups/{userGroupId}/users | Add users to user group
*UserGroupsApi* | [**change_user_group**](docs/apis/tags/UserGroupsApi.md#change_user_group) | **patch** /userGroups/{userGroupId} | Change user group
*UserGroupsApi* | [**find_user_groups**](docs/apis/tags/UserGroupsApi.md#find_user_groups) | **get** /userGroups | Find user groups
*UserGroupsApi* | [**get_user_group**](docs/apis/tags/UserGroupsApi.md#get_user_group) | **get** /userGroups/{userGroupId} | Get user group
*UserGroupsApi* | [**remove_user_group**](docs/apis/tags/UserGroupsApi.md#remove_user_group) | **delete** /userGroups/{userGroupId} | Remove user group
*UserGroupsApi* | [**remove_users_from_user_group**](docs/apis/tags/UserGroupsApi.md#remove_users_from_user_group) | **delete** /userGroups/{userGroupId}/users | Remove users from user group
*UsersApi* | [**add_user**](docs/apis/tags/UsersApi.md#add_user) | **post** /users | Adds a new user
*UsersApi* | [**add_user_groups_for_user**](docs/apis/tags/UsersApi.md#add_user_groups_for_user) | **post** /users/{userId}/userGroups | Add a user to multiple user groups
*UsersApi* | [**add_users**](docs/apis/tags/UsersApi.md#add_users) | **post** /users/bulk | Adds multiple new users
*UsersApi* | [**change_user**](docs/apis/tags/UsersApi.md#change_user) | **patch** /users/{userId} | Changes the user with the information that is present in the request
*UsersApi* | [**change_user_avatar**](docs/apis/tags/UsersApi.md#change_user_avatar) | **patch** /users/{userId}/avatar | Changes the avatar for the user identified by the given ID
*UsersApi* | [**delete_user**](docs/apis/tags/UsersApi.md#delete_user) | **delete** /users/{userId} | Deletes the user with the given ID
*UsersApi* | [**delete_user_avatar**](docs/apis/tags/UsersApi.md#delete_user_avatar) | **delete** /users/{userId}/avatar | Deletes the avatar for the user identified by the given ID
*UsersApi* | [**find_users**](docs/apis/tags/UsersApi.md#find_users) | **get** /users | Returns users matching the given search criteria
*UsersApi* | [**get_avatar_file**](docs/apis/tags/UsersApi.md#get_avatar_file) | **get** /users/{userId}/avatar | Get the avatar image for the user with the given ID
*UsersApi* | [**get_current_user**](docs/apis/tags/UsersApi.md#get_current_user) | **get** /users/current | Returns the current user, if logged in
*UsersApi* | [**get_current_user_permissions**](docs/apis/tags/UsersApi.md#get_current_user_permissions) | **get** /users/current/permissions | Returns the current user global permissions, if logged in
*UsersApi* | [**get_user**](docs/apis/tags/UsersApi.md#get_user) | **get** /users/{userId} | Gets the user with the given ID
*UsersApi* | [**get_user_by_email_address**](docs/apis/tags/UsersApi.md#get_user_by_email_address) | **get** /users/email/{emailAddress} | Gets the user identified by given e-mail address
*UsersApi* | [**get_user_required_license_type**](docs/apis/tags/UsersApi.md#get_user_required_license_type) | **get** /users/{userId}/licenseType | Gets the required LicenseType for the given user
*UsersApi* | [**remove_user_from_user_groups**](docs/apis/tags/UsersApi.md#remove_user_from_user_groups) | **delete** /users/{userId}/userGroups | Removes user from multiple user groups
*UsersApi* | [**set_user_groups_for_user**](docs/apis/tags/UsersApi.md#set_user_groups_for_user) | **put** /users/{userId}/userGroups | Sets user groups for the indicated user
*ValidationApi* | [**find_validation_results**](docs/apis/tags/ValidationApi.md#find_validation_results) | **get** /validation | Returns the validation results matching the given search criteria.
*ValidationApi* | [**validate**](docs/apis/tags/ValidationApi.md#validate) | **post** /validation/{assetId} | Validates a single asset.
*ValidationApi* | [**validate_in_job**](docs/apis/tags/ValidationApi.md#validate_in_job) | **post** /validation/bulk | Validates multiple assets.
*ViewPermissionsApi* | [**add_view_permission**](docs/apis/tags/ViewPermissionsApi.md#add_view_permission) | **post** /viewPermissions | Adds a view permission. It can be applied only to &#x27;Community&#x27; and &#x27;Domain&#x27; resource types.
*ViewPermissionsApi* | [**find_view_permissions**](docs/apis/tags/ViewPermissionsApi.md#find_view_permissions) | **get** /viewPermissions | Finds view permissions with given criteria.
*ViewPermissionsApi* | [**get_view_permission**](docs/apis/tags/ViewPermissionsApi.md#get_view_permission) | **get** /viewPermissions/{viewPermissionId} | Retrieves a view permission.
*ViewPermissionsApi* | [**remove_view_permission**](docs/apis/tags/ViewPermissionsApi.md#remove_view_permission) | **delete** /viewPermissions/{viewPermissionId} | Removes a view permission.
*WorkflowDefinitionsApi* | [**add_asset_type_assignment_rule**](docs/apis/tags/WorkflowDefinitionsApi.md#add_asset_type_assignment_rule) | **post** /workflowDefinitions/{workflowDefinitionId}/assetTypeAssignmentRules | Add asset type assignment rule.
*WorkflowDefinitionsApi* | [**add_domain_type_assignment_rule**](docs/apis/tags/WorkflowDefinitionsApi.md#add_domain_type_assignment_rule) | **post** /workflowDefinitions/{workflowDefinitionId}/domainTypeAssignmentRules | Add domain type assignment rule.
*WorkflowDefinitionsApi* | [**change_asset_type_assignment_rule**](docs/apis/tags/WorkflowDefinitionsApi.md#change_asset_type_assignment_rule) | **patch** /workflowDefinitions/{workflowDefinitionId}/assetTypeAssignmentRules/{ruleId} | Change asset type assignment rule.
*WorkflowDefinitionsApi* | [**change_domain_type_assignment_rule**](docs/apis/tags/WorkflowDefinitionsApi.md#change_domain_type_assignment_rule) | **patch** /workflowDefinitions/{workflowDefinitionId}/domainTypeAssignmentRules/{ruleId} | Change domain type assignment rule.
*WorkflowDefinitionsApi* | [**change_workflow_definition**](docs/apis/tags/WorkflowDefinitionsApi.md#change_workflow_definition) | **patch** /workflowDefinitions/{workflowDefinitionId} | Change workflow definition.
*WorkflowDefinitionsApi* | [**deploy_workflow_definition**](docs/apis/tags/WorkflowDefinitionsApi.md#deploy_workflow_definition) | **post** /workflowDefinitions | Deploy workflow definition.
*WorkflowDefinitionsApi* | [**find_workflow_definitions**](docs/apis/tags/WorkflowDefinitionsApi.md#find_workflow_definitions) | **get** /workflowDefinitions | Find workflow definitions.
*WorkflowDefinitionsApi* | [**get_configuration_start_form_data**](docs/apis/tags/WorkflowDefinitionsApi.md#get_configuration_start_form_data) | **get** /workflowDefinitions/workflowDefinition/{workflowDefinitionId}/configurationStartFormData | Get configuration start form data.
*WorkflowDefinitionsApi* | [**get_possible_start_events**](docs/apis/tags/WorkflowDefinitionsApi.md#get_possible_start_events) | **get** /workflowDefinitions/startEvents | Get all possible workflow start events
*WorkflowDefinitionsApi* | [**get_start_form_data**](docs/apis/tags/WorkflowDefinitionsApi.md#get_start_form_data) | **get** /workflowDefinitions/workflowDefinition/{workflowDefinitionId}/startFormData | Get start form data.
*WorkflowDefinitionsApi* | [**get_workflow_definition**](docs/apis/tags/WorkflowDefinitionsApi.md#get_workflow_definition) | **get** /workflowDefinitions/{workflowDefinitionId} | Get workflow definition.
*WorkflowDefinitionsApi* | [**get_workflow_definition_by_process_id**](docs/apis/tags/WorkflowDefinitionsApi.md#get_workflow_definition_by_process_id) | **get** /workflowDefinitions/process/{processId} | Get workflow definition.
*WorkflowDefinitionsApi* | [**get_workflow_definition_diagram**](docs/apis/tags/WorkflowDefinitionsApi.md#get_workflow_definition_diagram) | **get** /workflowDefinitions/{workflowDefinitionId}/diagram | Get process diagram.
*WorkflowDefinitionsApi* | [**get_workflow_definition_xml**](docs/apis/tags/WorkflowDefinitionsApi.md#get_workflow_definition_xml) | **get** /workflowDefinitions/{workflowDefinitionId}/xml | Get XML of workflow definition.
*WorkflowDefinitionsApi* | [**remove_assignment_rule**](docs/apis/tags/WorkflowDefinitionsApi.md#remove_assignment_rule) | **delete** /workflowDefinitions/{workflowDefinitionId}/assignmentRules/{ruleId} | Remove assignment rule.
*WorkflowDefinitionsApi* | [**remove_workflow_definition**](docs/apis/tags/WorkflowDefinitionsApi.md#remove_workflow_definition) | **delete** /workflowDefinitions/{workflowDefinitionId} | Remove workflow definition.
*WorkflowDefinitionsApi* | [**remove_workflow_definitions_in_job**](docs/apis/tags/WorkflowDefinitionsApi.md#remove_workflow_definitions_in_job) | **post** /workflowDefinitions/removalJobs | Remove multiple workflow definitions.
*WorkflowInstancesApi* | [**cancel_workflow_instances**](docs/apis/tags/WorkflowInstancesApi.md#cancel_workflow_instances) | **post** /workflowInstances/{workflowInstanceId}/canceled | Cancel workflow instance.
*WorkflowInstancesApi* | [**find_workflow_instances**](docs/apis/tags/WorkflowInstancesApi.md#find_workflow_instances) | **get** /workflowInstances | Find workflow instances.
*WorkflowInstancesApi* | [**get_workflow_instance_diagram**](docs/apis/tags/WorkflowInstancesApi.md#get_workflow_instance_diagram) | **get** /workflowInstances/{workflowInstanceId}/diagram | Returns the file representing the diagram of workflow instance identified by the given ID.
*WorkflowInstancesApi* | [**message_event_received**](docs/apis/tags/WorkflowInstancesApi.md#message_event_received) | **post** /workflowInstances/{processInstanceId}/messageEvents/{messageName} | Pass message event to workflow engine.
*WorkflowInstancesApi* | [**start_workflow_instances**](docs/apis/tags/WorkflowInstancesApi.md#start_workflow_instances) | **post** /workflowInstances | Start workflow instances.
*WorkflowInstancesApi* | [**start_workflow_instances_in_job**](docs/apis/tags/WorkflowInstancesApi.md#start_workflow_instances_in_job) | **post** /workflowInstances/startJobs | Start workflow instances.
*WorkflowTasksApi* | [**cancel_workflow_task**](docs/apis/tags/WorkflowTasksApi.md#cancel_workflow_task) | **post** /workflowTasks/{workflowTaskId}/canceled | Cancel workflow task.
*WorkflowTasksApi* | [**complete_workflow_tasks**](docs/apis/tags/WorkflowTasksApi.md#complete_workflow_tasks) | **post** /workflowTasks/completed | Complete workflow tasks.
*WorkflowTasksApi* | [**find_workflow_tasks**](docs/apis/tags/WorkflowTasksApi.md#find_workflow_tasks) | **get** /workflowTasks | Find workflow tasks.
*WorkflowTasksApi* | [**get_task_form_data**](docs/apis/tags/WorkflowTasksApi.md#get_task_form_data) | **get** /workflowTasks/{workflowTaskId}/taskFormData | Get task form data.
*WorkflowTasksApi* | [**get_workflow_task**](docs/apis/tags/WorkflowTasksApi.md#get_workflow_task) | **get** /workflowTasks/{workflowTaskId} | Get workflow task.
*WorkflowTasksApi* | [**reassign_task**](docs/apis/tags/WorkflowTasksApi.md#reassign_task) | **post** /workflowTasks/{workflowTaskId}/reassign | Reassign task.

## Documentation For Models

 - [ActivityImpl](docs/models/ActivityImpl.md)
 - [ActivityPagedResponse](docs/models/ActivityPagedResponse.md)
 - [AddAssetRequest](docs/models/AddAssetRequest.md)
 - [AddAssetTagsRequest](docs/models/AddAssetTagsRequest.md)
 - [AddAssetTypeAssignmentRuleRequest](docs/models/AddAssetTypeAssignmentRuleRequest.md)
 - [AddAssetTypeRequest](docs/models/AddAssetTypeRequest.md)
 - [AddAssignmentRequest](docs/models/AddAssignmentRequest.md)
 - [AddAttributeRequest](docs/models/AddAttributeRequest.md)
 - [AddAttributeTypeRequest](docs/models/AddAttributeTypeRequest.md)
 - [AddCommentRequest](docs/models/AddCommentRequest.md)
 - [AddCommunityRequest](docs/models/AddCommunityRequest.md)
 - [AddComplexRelationRequest](docs/models/AddComplexRelationRequest.md)
 - [AddComplexRelationTypeRequest](docs/models/AddComplexRelationTypeRequest.md)
 - [AddDataQualityRuleRequest](docs/models/AddDataQualityRuleRequest.md)
 - [AddDiagramPictureRequest](docs/models/AddDiagramPictureRequest.md)
 - [AddDomainRequest](docs/models/AddDomainRequest.md)
 - [AddDomainTypeAssignmentRuleRequest](docs/models/AddDomainTypeAssignmentRuleRequest.md)
 - [AddDomainTypeRequest](docs/models/AddDomainTypeRequest.md)
 - [AddIssueRequest](docs/models/AddIssueRequest.md)
 - [AddMappingRequest](docs/models/AddMappingRequest.md)
 - [AddRatingRequest](docs/models/AddRatingRequest.md)
 - [AddRelationRequest](docs/models/AddRelationRequest.md)
 - [AddRelationTypeRequest](docs/models/AddRelationTypeRequest.md)
 - [AddResponsibilityRequest](docs/models/AddResponsibilityRequest.md)
 - [AddRoleRequest](docs/models/AddRoleRequest.md)
 - [AddScopeRequest](docs/models/AddScopeRequest.md)
 - [AddStatusRequest](docs/models/AddStatusRequest.md)
 - [AddUserGroupRequest](docs/models/AddUserGroupRequest.md)
 - [AddUserRequest](docs/models/AddUserRequest.md)
 - [AddUserToUserGroupsRequest](docs/models/AddUserToUserGroupsRequest.md)
 - [AddUsersToUserGroupRequest](docs/models/AddUsersToUserGroupRequest.md)
 - [AddViewPermissionRequest](docs/models/AddViewPermissionRequest.md)
 - [Address](docs/models/Address.md)
 - [ApplicationInfo](docs/models/ApplicationInfo.md)
 - [ApplicationVersionImpl](docs/models/ApplicationVersionImpl.md)
 - [ArticulationRuleImpl](docs/models/ArticulationRuleImpl.md)
 - [ArticulationRuleRequest](docs/models/ArticulationRuleRequest.md)
 - [AssetAssignmentRuleImpl](docs/models/AssetAssignmentRuleImpl.md)
 - [AssetImpl](docs/models/AssetImpl.md)
 - [AssetPagedResponse](docs/models/AssetPagedResponse.md)
 - [AssetReferenceImpl](docs/models/AssetReferenceImpl.md)
 - [AssetTypeImpl](docs/models/AssetTypeImpl.md)
 - [AssetTypePagedResponse](docs/models/AssetTypePagedResponse.md)
 - [AssignedAttributeType](docs/models/AssignedAttributeType.md)
 - [AssignedCharacteristicType](docs/models/AssignedCharacteristicType.md)
 - [AssignedComplexRelationType](docs/models/AssignedComplexRelationType.md)
 - [AssignedRelationType](docs/models/AssignedRelationType.md)
 - [AssignmentImpl](docs/models/AssignmentImpl.md)
 - [AttachmentImpl](docs/models/AttachmentImpl.md)
 - [AttachmentPagedResponse](docs/models/AttachmentPagedResponse.md)
 - [Attribute](docs/models/Attribute.md)
 - [AttributePagedResponse](docs/models/AttributePagedResponse.md)
 - [AttributeType](docs/models/AttributeType.md)
 - [AttributeTypePagedResponse](docs/models/AttributeTypePagedResponse.md)
 - [AttributeValue](docs/models/AttributeValue.md)
 - [BooleanAttribute](docs/models/BooleanAttribute.md)
 - [BooleanAttributeType](docs/models/BooleanAttributeType.md)
 - [CancelJobRequest](docs/models/CancelJobRequest.md)
 - [ChangeAssetRequest](docs/models/ChangeAssetRequest.md)
 - [ChangeAssetTypeAssignmentRuleRequest](docs/models/ChangeAssetTypeAssignmentRuleRequest.md)
 - [ChangeAssetTypeRequest](docs/models/ChangeAssetTypeRequest.md)
 - [ChangeAssignmentRequest](docs/models/ChangeAssignmentRequest.md)
 - [ChangeAttributeRequest](docs/models/ChangeAttributeRequest.md)
 - [ChangeAttributeTypeRequest](docs/models/ChangeAttributeTypeRequest.md)
 - [ChangeCommentRequest](docs/models/ChangeCommentRequest.md)
 - [ChangeCommunityRequest](docs/models/ChangeCommunityRequest.md)
 - [ChangeComplexRelationRequest](docs/models/ChangeComplexRelationRequest.md)
 - [ChangeComplexRelationTypeRequest](docs/models/ChangeComplexRelationTypeRequest.md)
 - [ChangeDataQualityRuleRequest](docs/models/ChangeDataQualityRuleRequest.md)
 - [ChangeDomainRequest](docs/models/ChangeDomainRequest.md)
 - [ChangeDomainTypeAssignmentRuleRequest](docs/models/ChangeDomainTypeAssignmentRuleRequest.md)
 - [ChangeDomainTypeRequest](docs/models/ChangeDomainTypeRequest.md)
 - [ChangeMappingByExternalEntityRequest](docs/models/ChangeMappingByExternalEntityRequest.md)
 - [ChangeMappingByMappedResourceRequest](docs/models/ChangeMappingByMappedResourceRequest.md)
 - [ChangeMappingRequest](docs/models/ChangeMappingRequest.md)
 - [ChangeRatingRequest](docs/models/ChangeRatingRequest.md)
 - [ChangeRelationRequest](docs/models/ChangeRelationRequest.md)
 - [ChangeRelationTypeRequest](docs/models/ChangeRelationTypeRequest.md)
 - [ChangeRoleRequest](docs/models/ChangeRoleRequest.md)
 - [ChangeScopeRequest](docs/models/ChangeScopeRequest.md)
 - [ChangeStatusRequest](docs/models/ChangeStatusRequest.md)
 - [ChangeTagRequest](docs/models/ChangeTagRequest.md)
 - [ChangeUserAvatarRequest](docs/models/ChangeUserAvatarRequest.md)
 - [ChangeUserGroupRequest](docs/models/ChangeUserGroupRequest.md)
 - [ChangeUserRequest](docs/models/ChangeUserRequest.md)
 - [ChangeWorkflowDefinitionRequest](docs/models/ChangeWorkflowDefinitionRequest.md)
 - [CharacteristicTypeAssignmentReference](docs/models/CharacteristicTypeAssignmentReference.md)
 - [Comment](docs/models/Comment.md)
 - [CommentPagedResponse](docs/models/CommentPagedResponse.md)
 - [CommunityImpl](docs/models/CommunityImpl.md)
 - [CommunityPagedResponse](docs/models/CommunityPagedResponse.md)
 - [CompleteWorkflowTasksRequest](docs/models/CompleteWorkflowTasksRequest.md)
 - [ComplexRelationAttributeTypeImpl](docs/models/ComplexRelationAttributeTypeImpl.md)
 - [ComplexRelationAttributeTypeRequest](docs/models/ComplexRelationAttributeTypeRequest.md)
 - [ComplexRelationImpl](docs/models/ComplexRelationImpl.md)
 - [ComplexRelationLegImpl](docs/models/ComplexRelationLegImpl.md)
 - [ComplexRelationLegRequest](docs/models/ComplexRelationLegRequest.md)
 - [ComplexRelationLegTypeImpl](docs/models/ComplexRelationLegTypeImpl.md)
 - [ComplexRelationLegTypeRequest](docs/models/ComplexRelationLegTypeRequest.md)
 - [ComplexRelationTypeImpl](docs/models/ComplexRelationTypeImpl.md)
 - [ComplexRelationTypePagedResponse](docs/models/ComplexRelationTypePagedResponse.md)
 - [ConnectionStringParameter](docs/models/ConnectionStringParameter.md)
 - [CursorPagedResponseAsset](docs/models/CursorPagedResponseAsset.md)
 - [CursorPagedResponseAttribute](docs/models/CursorPagedResponseAttribute.md)
 - [CursorPagedResponseCommunity](docs/models/CursorPagedResponseCommunity.md)
 - [CursorPagedResponseComplexRelation](docs/models/CursorPagedResponseComplexRelation.md)
 - [CursorPagedResponseDomain](docs/models/CursorPagedResponseDomain.md)
 - [CursorPagedResponseRelation](docs/models/CursorPagedResponseRelation.md)
 - [DGCSession](docs/models/DGCSession.md)
 - [DataQualityMetricImpl](docs/models/DataQualityMetricImpl.md)
 - [DataQualityMetricRequest](docs/models/DataQualityMetricRequest.md)
 - [DataQualityRuleImpl](docs/models/DataQualityRuleImpl.md)
 - [DataQualityRulePagedResponse](docs/models/DataQualityRulePagedResponse.md)
 - [DateAttribute](docs/models/DateAttribute.md)
 - [DateAttributeType](docs/models/DateAttributeType.md)
 - [DomainImpl](docs/models/DomainImpl.md)
 - [DomainPagedResponse](docs/models/DomainPagedResponse.md)
 - [DomainTypeImpl](docs/models/DomainTypeImpl.md)
 - [DomainTypePagedResponse](docs/models/DomainTypePagedResponse.md)
 - [DropdownValue](docs/models/DropdownValue.md)
 - [Email](docs/models/Email.md)
 - [ExportComplexRelationsToCSVRequest](docs/models/ExportComplexRelationsToCSVRequest.md)
 - [ExportComplexRelationsToExcelRequest](docs/models/ExportComplexRelationsToExcelRequest.md)
 - [FileInfoImpl](docs/models/FileInfoImpl.md)
 - [FileReferenceImpl](docs/models/FileReferenceImpl.md)
 - [FormProperty](docs/models/FormProperty.md)
 - [InstantMessagingAccount](docs/models/InstantMessagingAccount.md)
 - [JdbcDriver](docs/models/JdbcDriver.md)
 - [JdbcDriverFile](docs/models/JdbcDriverFile.md)
 - [JdbcDriverPagedResponse](docs/models/JdbcDriverPagedResponse.md)
 - [Job](docs/models/Job.md)
 - [JobPagedResponse](docs/models/JobPagedResponse.md)
 - [LoginRequest](docs/models/LoginRequest.md)
 - [Mapping](docs/models/Mapping.md)
 - [MappingPagedResponse](docs/models/MappingPagedResponse.md)
 - [MergeTagsRequest](docs/models/MergeTagsRequest.md)
 - [MessageEventReceivedRequest](docs/models/MessageEventReceivedRequest.md)
 - [MultiValueListAttribute](docs/models/MultiValueListAttribute.md)
 - [MultiValueListAttributeType](docs/models/MultiValueListAttributeType.md)
 - [NamedDescribedResourceReference](docs/models/NamedDescribedResourceReference.md)
 - [NamedDescribedWorkflowStartEventType](docs/models/NamedDescribedWorkflowStartEventType.md)
 - [NamedResourceReferenceImpl](docs/models/NamedResourceReferenceImpl.md)
 - [NavigationStatisticsEntry](docs/models/NavigationStatisticsEntry.md)
 - [NavigationStatisticsEntryPagedResponse](docs/models/NavigationStatisticsEntryPagedResponse.md)
 - [NumericAttribute](docs/models/NumericAttribute.md)
 - [NumericAttributeType](docs/models/NumericAttributeType.md)
 - [OptionValue](docs/models/OptionValue.md)
 - [PagedResponse](docs/models/PagedResponse.md)
 - [PagedResponseActivity](docs/models/PagedResponseActivity.md)
 - [PagedResponseAsset](docs/models/PagedResponseAsset.md)
 - [PagedResponseAssetType](docs/models/PagedResponseAssetType.md)
 - [PagedResponseAttachment](docs/models/PagedResponseAttachment.md)
 - [PagedResponseAttributeType](docs/models/PagedResponseAttributeType.md)
 - [PagedResponseComment](docs/models/PagedResponseComment.md)
 - [PagedResponseComplexRelationType](docs/models/PagedResponseComplexRelationType.md)
 - [PagedResponseDataQualityRule](docs/models/PagedResponseDataQualityRule.md)
 - [PagedResponseDomainType](docs/models/PagedResponseDomainType.md)
 - [PagedResponseJdbcDriver](docs/models/PagedResponseJdbcDriver.md)
 - [PagedResponseJob](docs/models/PagedResponseJob.md)
 - [PagedResponseMapping](docs/models/PagedResponseMapping.md)
 - [PagedResponseNavigationStatisticsEntry](docs/models/PagedResponseNavigationStatisticsEntry.md)
 - [PagedResponseRating](docs/models/PagedResponseRating.md)
 - [PagedResponseRelationType](docs/models/PagedResponseRelationType.md)
 - [PagedResponseResponsibility](docs/models/PagedResponseResponsibility.md)
 - [PagedResponseRole](docs/models/PagedResponseRole.md)
 - [PagedResponseScope](docs/models/PagedResponseScope.md)
 - [PagedResponseStatus](docs/models/PagedResponseStatus.md)
 - [PagedResponseTag](docs/models/PagedResponseTag.md)
 - [PagedResponseUser](docs/models/PagedResponseUser.md)
 - [PagedResponseUserGroup](docs/models/PagedResponseUserGroup.md)
 - [PagedResponseValidationResult](docs/models/PagedResponseValidationResult.md)
 - [PagedResponseViewPermission](docs/models/PagedResponseViewPermission.md)
 - [PagedResponseWorkflowDefinition](docs/models/PagedResponseWorkflowDefinition.md)
 - [PagedResponseWorkflowInstance](docs/models/PagedResponseWorkflowInstance.md)
 - [PagedResponseWorkflowTask](docs/models/PagedResponseWorkflowTask.md)
 - [PhoneNumber](docs/models/PhoneNumber.md)
 - [Rating](docs/models/Rating.md)
 - [RatingsPagedResponse](docs/models/RatingsPagedResponse.md)
 - [RelatedAssetId](docs/models/RelatedAssetId.md)
 - [RelatedAssetReference](docs/models/RelatedAssetReference.md)
 - [RelationImpl](docs/models/RelationImpl.md)
 - [RelationPagedResponse](docs/models/RelationPagedResponse.md)
 - [RelationTraceEntryImpl](docs/models/RelationTraceEntryImpl.md)
 - [RelationTraceEntryRequest](docs/models/RelationTraceEntryRequest.md)
 - [RelationTraceImpl](docs/models/RelationTraceImpl.md)
 - [RelationTypeImpl](docs/models/RelationTypeImpl.md)
 - [RelationTypePagedResponse](docs/models/RelationTypePagedResponse.md)
 - [RemoveAssetTagsRequest](docs/models/RemoveAssetTagsRequest.md)
 - [RemoveUserFromUserGroupsRequest](docs/models/RemoveUserFromUserGroupsRequest.md)
 - [RemoveUsersFromUserGroupRequest](docs/models/RemoveUsersFromUserGroupRequest.md)
 - [ResourceReference](docs/models/ResourceReference.md)
 - [ResponsibilityImpl](docs/models/ResponsibilityImpl.md)
 - [RoleImpl](docs/models/RoleImpl.md)
 - [ScopeImpl](docs/models/ScopeImpl.md)
 - [ScopePagedResponse](docs/models/ScopePagedResponse.md)
 - [ScriptAttribute](docs/models/ScriptAttribute.md)
 - [ScriptAttributeType](docs/models/ScriptAttributeType.md)
 - [SetAssetAttributesRequest](docs/models/SetAssetAttributesRequest.md)
 - [SetAssetRelationsRequest](docs/models/SetAssetRelationsRequest.md)
 - [SetAssetResponsibilitiesRequest](docs/models/SetAssetResponsibilitiesRequest.md)
 - [SetAssetTagsRequest](docs/models/SetAssetTagsRequest.md)
 - [SetUserGroupsForUserRequest](docs/models/SetUserGroupsForUserRequest.md)
 - [SingleValueListAttribute](docs/models/SingleValueListAttribute.md)
 - [SingleValueListAttributeType](docs/models/SingleValueListAttributeType.md)
 - [SolutionInfo](docs/models/SolutionInfo.md)
 - [StartFormDataImpl](docs/models/StartFormDataImpl.md)
 - [StartWorkflowInstancesRequest](docs/models/StartWorkflowInstancesRequest.md)
 - [StatusImpl](docs/models/StatusImpl.md)
 - [StatusPagedResponse](docs/models/StatusPagedResponse.md)
 - [StringAttribute](docs/models/StringAttribute.md)
 - [StringAttributeType](docs/models/StringAttributeType.md)
 - [SymbolDataImpl](docs/models/SymbolDataImpl.md)
 - [Tag](docs/models/Tag.md)
 - [TagPagedResponse](docs/models/TagPagedResponse.md)
 - [TaskFormData](docs/models/TaskFormData.md)
 - [User](docs/models/User.md)
 - [UserGroupImpl](docs/models/UserGroupImpl.md)
 - [UserGroupPagedResponse](docs/models/UserGroupPagedResponse.md)
 - [UserPagedResponse](docs/models/UserPagedResponse.md)
 - [UserPermissions](docs/models/UserPermissions.md)
 - [UserReferenceImpl](docs/models/UserReferenceImpl.md)
 - [ValidateInJobRequest](docs/models/ValidateInJobRequest.md)
 - [ValidationResultImpl](docs/models/ValidationResultImpl.md)
 - [ValidationResultPagedResponse](docs/models/ValidationResultPagedResponse.md)
 - [ViewPermissionImpl](docs/models/ViewPermissionImpl.md)
 - [Website](docs/models/Website.md)
 - [WorkflowDefinitionImpl](docs/models/WorkflowDefinitionImpl.md)
 - [WorkflowDefinitionPagedResponse](docs/models/WorkflowDefinitionPagedResponse.md)
 - [WorkflowDefinitionReference](docs/models/WorkflowDefinitionReference.md)
 - [WorkflowInstance](docs/models/WorkflowInstance.md)
 - [WorkflowTask](docs/models/WorkflowTask.md)
 - [WorkflowTaskPagedResponse](docs/models/WorkflowTaskPagedResponse.md)

## Documentation For Authorization


## basicAuth

- **Type**: HTTP basic authentication

 Authentication schemes defined for the API:
## bearerAuth

- **Type**: Bearer authentication (JWT)


## Author











































## Notes for Large OpenAPI documents
If the OpenAPI document is large, imports in collibra_core.apis and collibra_core.models may fail with a
RecursionError indicating the maximum recursion limit has been exceeded. In that case, there are a couple of solutions:

Solution 1:
Use specific imports for apis and models like:
- `from collibra_core.apis.default_api import DefaultApi`
- `from collibra_core.model.pet import Pet`

Solution 1:
Before importing the package, adjust the maximum recursion limit as shown below:
```
import sys
sys.setrecursionlimit(1500)
import collibra_core
from collibra_core.apis import *
from collibra_core.models import *
```
