[[Paper]]() [[Хабр]]() [[Model Card]](https://huggingface.co/sberbank-ai/RuDOLPH-350M) [[Colab]]() [[Kaggle]]()

## <img src="https://raw.githubusercontent.com/shonenkov/ru-dolph/master/pics/rudolph.png?token=AHV2MCOWDUYEND527HLVOPDB3MLAK" height="60"/> RuDOLPH 🦌🎄☃️

*One Hyper-Modal Transformer can be creative as DALL-E and smart as CLIP*



**Ru**ssian **D**iffusion **O**n **L**anguage **P**icture **H**yper-modality (RuDOLPH) Transformer



# Sparse Attention Mask
`row - col - row - [last] conv`

![](./pics/attention_masks.png)

![](./pics/high_res.png)

# Installing
```
pip install rudolph==0.0.1rc0
pip install rudalle==0.4.0
```

# Usage
### Init models
```python
from rudalle import get_tokenizer, get_vae
from rudalle.utils import seed_everything
from rudalle.image_prompts import ImagePrompts

from rudolph.model import get_rudolph_model
from rudolph.pipelines import zs_clf, generate_codebooks, self_reranking_by_image, self_reranking_by_text, show, generate_captions, generate_texts

device = 'cuda'
model = get_rudolph_model('350M', fp16=True, device=device)
model.to(device);
tokenizer = get_tokenizer()
vae = get_vae(dwt=False).to(device)
```
### Text Generation
```python
generate_texts(
    tokenizer,
    model,
    template='красивый пейзаж ',
    top_k=32, top_p=0.6, texts_num=32, bs=32, seed=42
)[:8]

[{'text': 'красивый пейзаж с лесом и рекой. вид с воздуха на сельскую местность. пейзаж с лесом и рекой. вид на горы с беспилотника', 'ppl': 82.94},
 {'text': 'красивый пейзаж в стиле реализм, автор которой сергей владимирович дорофеев', 'ppl': 112.73},
 {'text': 'красивый пейзаж с рекой и озером - обои для рабочего стола, картинки, фото', 'ppl': 125.55},
 {'text': 'красивый пейзаж с рекой и мостом через реку в сумерках', 'ppl': 170.83},
 {'text': 'красивый пейзаж с горами в тумане - горы в тумане', 'ppl': 180.72},
 {'text': 'красивый пейзаж с лесом и лугом в сумерках', 'ppl': 185.84},
 {'text': 'красивый пейзаж с озером и лесом на заднем плане', 'ppl': 199.84},
 {'text': 'красивый пейзаж с видом на горы в таиланде', 'ppl': 219.86}]
```

### Image Generation + Self Reranking
```python
text = 'красивый пейзаж с озером и лесом на заднем плане'
images_num = 256
seed_everything(42)
codebooks = []
for top_k, top_p, images_num in [
    (2048, 0.99, images_num),
    (1024, 0.99, images_num),
    (1024, 0.98, images_num),
]:
    codebooks.append(generate_codebooks(text, tokenizer, model, top_k=top_k, images_num=images_num, top_p=top_p, bs=128))

codebooks = torch.cat(codebooks)

ppl_text, ppl_image = self_reranking_by_text(text, codebooks, tokenizer, model, bs=32)
with torch.no_grad():
    images = vae.decode(codebooks[ppl_text.argsort()[:16]])

pil_images = utils.torch_tensors_to_pil_list(images)
show(pil_images, 8)
```
![](./pics/pipelines/lake.png)


```python
text = 'зимнее время года'

ppl_text, ppl_image = self_reranking_by_text(text, codebooks, tokenizer, model, bs=32)
with torch.no_grad():
    images = vae.decode(codebooks[ppl_text.argsort()[:16]])

pil_images = utils.torch_tensors_to_pil_list(images)
show(pil_images, 8)
```
![](./pics/pipelines/lake_winter.png)


```python
text = 'ночное время суток'

ppl_text, ppl_image = self_reranking_by_text(text, codebooks, tokenizer, model, bs=32)
with torch.no_grad():
    images = vae.decode(codebooks[ppl_text.argsort()[:16]])

pil_images = utils.torch_tensors_to_pil_list(images)
show(pil_images, 8)
```
![](./pics/pipelines/lake_night.png)


### Image Prompt (like Inpainting)
![](pics/pipelines/lake_image_prompt.png)
```python
text = 'лодка с алыми парусами'

images_num = 1024
bs = 128

borders = {'up': 6, 'left': 4, 'right': 6, 'down': 2}
image_prompts = ImagePrompts(pil_img, borders, vae, device, crop_first=True)

seed_everything(42)
codebooks = []
for top_k, top_p, images_num in [
    (1024, 0.99, images_num),
]:
    codebooks.append(
        generate_codebooks(text, tokenizer, model, top_k=top_k, images_num=images_num, top_p=top_p, bs=bs, image_prompts=image_prompts)
    )

codebooks = torch.cat(codebooks)

ppl_text, ppl_image = self_reranking_by_text(
    text,
    codebooks,
    tokenizer,
    model,
    bs=bs,
)
with torch.no_grad():
    images = vae.decode(codebooks[ppl_text.argsort()[:16]])

pil_images = utils.torch_tensors_to_pil_list(images)
show(pil_images, 8)
```
![](./pics/pipelines/lake_ship.png)

### Diffusion (TODO, see Colab)

### Image Captioning + Self Reranking
![](./pics/pipelines/final_lake_ship.png)
```python
texts = generate_captions(pil_img, tokenizer, model, vae, template='на картинке ', top_k=8, captions_num=128, bs=128, top_p=0.6, seed=42)
ppl_text, ppl_image = self_reranking_by_image(texts, pil_img, tokenizer, model, vae, bs=16, seed=42)
for idx in ppl_image.argsort()[:8]:
    print(f'-{texts[idx]}')

-на картинке я хочу увидеть как выглядит дом в горах
-на картинке нарисована лодка с каяком и лесом
-на картинке нарисован дом с бассейном
-на картинке – пейзаж – горы – одна из самых красивых мест на планете
-на картинке: в норвегии
-на картинке в горах
-на картинке я хочу нарисовать дом
-на картинке изображен домик на горе
```

### Zero-Shot Image Classification using PPL
```python
bs4_urls = [
    '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',
    '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',
    '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',
    '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',
    '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',
    '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',
    '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',
    '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',
]

import base64
from PIL import Image
from io import BytesIO

f, ax = plt.subplots(2,4, figsize=(12,6))

for i, bs4_url in enumerate(bs4_urls):
    pil_img = Image.open(BytesIO(base64.b64decode(bs4_url)))
    
    classes = ['кошка', 'собака']
    preds = zs_clf(
        pil_img, 
        classes,
        model, 
        tokenizer,
        vae,
        template = 'на фото изображена', 
    )
    ax[i//4, i%4].imshow(pil_img)
    ax[i//4, i%4].set_title(preds['class'])
```
![](./pics/pipelines/zs_clf.png)

### Linear Probe (TODO, see Colab)

# Authors: 

+ Alex Shonenkov: [Github](https://github.com/shonenkov), [Kaggle GM](https://www.kaggle.com/shonenkov)
+ Michael Konstantinov: [Mishin Learning](https://t.me/mishin_learning), [Transformer Community](https://transformer.community/)

<img src='https://habrastorage.org/webt/2w/5k/2r/2w5k2reyf6yqa4s7ywmmioaaieg.png' alt="Drawing" width="200" />  <img src='https://habrastorage.org/webt/eq/ft/g3/eqftg3_8l1b_fpimhiof7knytzk.png' alt="Drawing" width="200" />

# Citation

```
@article{shonenkov2022ruDolph,
  title         = {RuDOLPH: One Hyper-Modal Transformer can be creative as DALL-E and smart as CLIP},
  author        = {Alex Shonenkov and Michael Konstantinov},
  year          = {2022},
  eprint        = {...},
  archivePrefix = {arXiv},
  primaryClass  = {cs.CL}
}
```

```
@misc{github2022ruDolph,
  title         = {RuDOLPH: One Hyper-Modal Transformer can be creative as DALL-E and smart as CLIP},
  author        = {Alex Shonenkov and Michael Konstantinov},
  year          = {2022},
  howpublished  = {\url{https://github.com/sberbank-ai/ru-dolph}},
}
```
