"use strict";define(["userSettings","events"],(function(userSettings,events){var currentCulture,currentDateTimeCulture,allTranslations={};function getCurrentLocale(){return currentCulture}function updateCurrentCulture(){var culture,dateTimeCulture;try{culture=userSettings.language()}catch(err){console.error("no language set in user settings")}culture=culture||function getDefaultLanguage(){var culture=document.documentElement.getAttribute("data-culture");return culture||(navigator.language?navigator.language:navigator.userLanguage?navigator.userLanguage:navigator.languages&&navigator.languages.length?navigator.languages[0]:"en-us")}(),currentCulture=normalizeLocaleName(culture);try{dateTimeCulture=userSettings.dateTimeLocale()}catch(err){console.error("no date format set in user settings")}currentDateTimeCulture=dateTimeCulture?normalizeLocaleName(dateTimeCulture):currentCulture,function ensureTranslations(culture){for(var i in allTranslations)ensureTranslation(allTranslations[i],culture);if("en-us"!==culture)for(var i in allTranslations)ensureTranslation(allTranslations[i],"en-us")}(currentCulture)}function ensureTranslation(translationInfo,culture){return translationInfo.dictionaries[culture]?Promise.resolve():function loadTranslation(translations,lang){lang=normalizeLocaleName(lang);var filtered=translations.filter((function(t){return normalizeLocaleName(t.lang)===lang}));filtered.length||(filtered=translations.filter((function(t){return"en-us"===normalizeLocaleName(t.lang)})));return new Promise((function(resolve,reject){if(filtered.length){var url=filtered[0].path;url+=-1===url.indexOf("?")?"?":"&",url+="v="+cacheParam;var xhr=new XMLHttpRequest;xhr.open("GET",url,!0),xhr.onload=function(e){this.status<400?resolve(JSON.parse(this.response)):resolve({})},xhr.onerror=function(){resolve({})},xhr.send()}else resolve()}))}(translationInfo.translations,culture).then((function(dictionary){translationInfo.dictionaries[culture]=dictionary}))}function normalizeLocaleName(culture){var parts=(culture=culture.replace("_","-")).split("-");2===parts.length&&parts[0].toLowerCase()===parts[1].toLowerCase()&&(culture=parts[0].toLowerCase());var lower=culture.toLowerCase();return"ca-es"===lower?"ca":"sv-se"===lower?"sv":lower}function getDictionary(module,locale){module||(module=defaultModule());var translations=allTranslations[module];return translations?translations.dictionaries[locale]:{}}function register(options){allTranslations[options.name]={translations:options.strings||options.translations,dictionaries:{}}}var _defaultModule,cacheParam=(new Date).getTime();function translateKey(key){var module,parts=key.split("#");return parts.length>1&&(module=parts[0],key=parts[1]),translateKeyFromModule(key,module)}function translateKeyFromModule(key,module){var dictionary=getDictionary(module,getCurrentLocale());return dictionary&&dictionary[key]||(dictionary=getDictionary(module,"en-us")),dictionary&&dictionary[key]||key}function replaceAll(str,find,replace){return str.split(find).join(replace)}function translate(key){for(var val=translateKey(key),i=1;i<arguments.length;i++)val=replaceAll(val,"{"+(i-1)+"}",arguments[i]);return val}function translateHtml(html,module){if(module||(module=defaultModule()),!module)throw new Error("module cannot be null or empty");var startIndex=html.indexOf("${");if(-1===startIndex)return html;startIndex+=2;var endIndex=html.indexOf("}",startIndex);if(-1===endIndex)return html;var key=html.substring(startIndex,endIndex),val=translateKeyFromModule(key,module);return translateHtml(html=html.replace("${"+key+"}",val),module)}function defaultModule(val){return val&&(_defaultModule=val),_defaultModule}return updateCurrentCulture(),events.on(userSettings,"change",(function(e,name){"language"!==name&&"datetimelocale"!==name||updateCurrentCulture()})),{getString:translate,translate:translate,translateDocument:translateHtml,translateHtml:translateHtml,loadStrings:function loadStrings(options){var optionsName,locale=getCurrentLocale(),promises=[];return"string"==typeof options?optionsName=options:(optionsName=options.name,register(options)),promises.push(ensureTranslation(allTranslations[optionsName],locale)),promises.push(ensureTranslation(allTranslations[optionsName],"en-us")),Promise.all(promises)},defaultModule:defaultModule,getCurrentLocale:getCurrentLocale,getCurrentDateTimeLocale:function getCurrentDateTimeLocale(){return currentDateTimeCulture},register:register,updateCurrentCulture:updateCurrentCulture}}));
//# sourceMappingURL=globalize.js.map
