"use strict";define(["dialogHelper","dom","layoutManager","connectionManager","globalize","loading","browser","focusManager","scrollHelper","material-icons","formDialogStyle","emby-button","emby-itemscontainer","cardStyle"],(function(dialogHelper,dom,layoutManager,connectionManager,globalize,loading,browser,focusManager,scrollHelper){var enableFocusTransform=!browser.slow&&!browser.edge;function getDeviceHtml(device){var html="",cssClass="card scalableCard";return cssClass+=" backdropCard backdropCard-scalable","cardPadder-backdrop",layoutManager.tv&&(cssClass+=" show-focus",enableFocusTransform&&(cssClass+=" show-animation")),html+='<button type="button" class="'+cssClass+'" data-id="'+device.DeviceId+'" style="min-width:33.3333%;">',html+='<div class="cardBox visualCardBox">',html+='<div class="cardScalable visualCardBox-cardScalable">',html+='<div class="cardPadder-backdrop"></div>',html+='<div class="cardContent searchImage">',html+='<div class="cardImageContainer coveredImage"><span class="cardImageIcon material-icons dvr"></span></div>',html+="</div>",html+="</div>",html+='<div class="cardFooter visualCardBox-cardFooter">',html+='<div class="cardText cardTextCentered">'+function getTunerName(providerId){switch(providerId=providerId.toLowerCase()){case"m3u":return"M3U";case"hdhomerun":return"HDHomerun";case"hauppauge":return"Hauppauge";case"satip":return"DVB";default:return"Unknown"}}(device.Type)+"</div>",html+='<div class="cardText cardTextCentered cardText-secondary">'+device.FriendlyName+"</div>",html+='<div class="cardText cardText-secondary cardTextCentered">',html+=device.Url||"&nbsp;",html+="</div>",html+="</div>",(html+="</div>")+"</button>"}function discoverDevices(view,apiClient){return loading.show(),view.querySelector(".loadingContent").classList.remove("hide"),ApiClient.getJSON(ApiClient.getUrl("LiveTv/Tuners/Discvover",{NewDevicesOnly:!0})).then((function(devices){currentDevices=devices,function renderDevices(view,devices){var i,length,html="";for(i=0,length=devices.length;i<length;i++)html+=getDeviceHtml(devices[i]);devices.length?view.querySelector(".devicesHeader").classList.remove("hide"):(html="<p><br/>"+globalize.translate("NoNewDevicesFound")+"</p>",view.querySelector(".devicesHeader").classList.add("hide"));var elem=view.querySelector(".results");elem.innerHTML=html,layoutManager.tv&&focusManager.autoFocus(elem)}(view,devices),view.querySelector(".loadingContent").classList.add("hide"),loading.hide()}))}var currentDevices=[];return function tunerPicker(){this.show=function(options){var dialogOptions={removeOnClose:!0,scrollY:!1};layoutManager.tv?dialogOptions.size="fullscreen":dialogOptions.size="small";var dlg=dialogHelper.createDialog(dialogOptions);dlg.classList.add("formDialog");var deviceResult,html="";html+='<div class="formDialogHeader">',html+='<button is="paper-icon-button-light" class="btnCancel autoSize" tabindex="-1"><span class="material-icons arrow_back"></span></button>',html+='<h3 class="formDialogHeaderTitle">',html+=globalize.translate("HeaderLiveTvTunerSetup"),html+="</h3>",html+="</div>",html+=function getEditorHtml(){var html="";return html+='<div class="formDialogContent scrollY">',html+='<div class="dialogContentInner dialog-content-centered">',html+='<div class="loadingContent hide">',html+="<h1>"+globalize.translate("DetectingDevices")+"...</h1>",html+="<p>"+globalize.translate("MessagePleaseWait")+"</p>",html+="</div>",html+='<h1 style="margin-bottom:.25em;" class="devicesHeader hide">'+globalize.translate("HeaderNewDevices")+"</h1>",html+='<div is="emby-itemscontainer" class="results vertical-wrap">',html+="</div>",(html+="</div>")+"</div>"}(),dlg.innerHTML=html,dlg.querySelector(".btnCancel").addEventListener("click",(function(){dialogHelper.close(dlg)})),dlg.querySelector(".results").addEventListener("click",(function(e){var tunerCard=dom.parentWithClass(e.target,"card");if(tunerCard){var deviceId=tunerCard.getAttribute("data-id");deviceResult=currentDevices.filter((function(d){return d.DeviceId===deviceId}))[0],dialogHelper.close(dlg)}})),layoutManager.tv&&scrollHelper.centerFocus.on(dlg.querySelector(".formDialogContent"),!1);connectionManager.getApiClient(options.serverId);return discoverDevices(dlg),layoutManager.tv&&scrollHelper.centerFocus.off(dlg.querySelector(".formDialogContent"),!1),dialogHelper.open(dlg).then((function(){return deviceResult?Promise.resolve(deviceResult):Promise.reject()}))}}}));
//# sourceMappingURL=tunerPicker.js.map
