define(["exports","events","connectionManager","playbackManager","syncPlayManager","loading","toast","actionsheet","globalize","playbackPermissionManager"],(function(_exports,_events,_connectionManager,_playbackManager,_syncPlayManager,_loading,_toast,_actionsheet,_globalize,_playbackPermissionManager){"use strict";function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function getActivePlayerId(){var info=_playbackManager.default.getPlayerInfo();return info?info.id:null}function showNewJoinGroupSelection(button,user,apiClient){var playingItemId,inSession="none"!==(getActivePlayerId()||"none"),policy=user.localUser?user.localUser.Policy:{};try{var playState=_playbackManager.default.getPlayerState();playingItemId=playState.NowPlayingItem.Id,console.debug("Item",playingItemId,"is currently playing.")}catch(error){playingItemId="",console.debug("No item is currently playing.")}apiClient.getSyncPlayGroups().then((function(response){response.json().then((function(groups){var menuItems=groups.map((function(group){return{name:group.PlayingItemName,icon:"group",id:group.GroupId,selected:!1,secondaryText:group.Participants.join(", ")}}));if(inSession&&"CreateAndJoinGroups"===policy.SyncPlayAccess&&menuItems.push({name:_globalize.default.translate("LabelSyncPlayNewGroup"),icon:"add",id:"new-group",selected:!0,secondaryText:_globalize.default.translate("LabelSyncPlayNewGroupDescription")}),0===menuItems.length)return inSession&&"JoinGroups"===policy.SyncPlayAccess?(0,_toast.default)({text:_globalize.default.translate("MessageSyncPlayCreateGroupDenied")}):(0,_toast.default)({text:_globalize.default.translate("MessageSyncPlayNoGroupsAvailable")}),void _loading.default.hide();var menuOptions={title:_globalize.default.translate("HeaderSyncPlaySelectGroup"),items:menuItems,positionTo:button,resolveOnClick:!0,border:!0};_actionsheet.default.show(menuOptions).then((function(id){"new-group"==id?apiClient.createSyncPlayGroup():id&&apiClient.joinSyncPlayGroup({GroupId:id,PlayingItemId:playingItemId})})).catch((function(error){console.error("SyncPlay: unexpected error listing groups:",error)})),_loading.default.hide()}))})).catch((function(error){console.error(error),_loading.default.hide(),(0,_toast.default)({text:_globalize.default.translate("MessageSyncPlayErrorAccessingGroups")})}))}Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.show=function show(button){_loading.default.show(),_playbackPermissionManager.default.check().then((function(){console.debug("Playback is allowed.")})).catch((function(error){console.error("Playback not allowed!",error),(0,_toast.default)({text:_globalize.default.translate("MessageSyncPlayPlaybackPermissionRequired")})}));var apiClient=_connectionManager.default.currentApiClient();_connectionManager.default.user(apiClient).then((function(user){syncPlayEnabled?function showLeaveGroupSelection(button,user,apiClient){if(!getActivePlayerId())return _syncPlayManager.default.signalError(),(0,_toast.default)({text:_globalize.default.translate("MessageSyncPlayErrorNoActivePlayer")}),void showNewJoinGroupSelection(button,user,apiClient);var menuItems=[{name:_globalize.default.translate("LabelSyncPlayLeaveGroup"),icon:"meeting_room",id:"leave-group",selected:!0,secondaryText:_globalize.default.translate("LabelSyncPlayLeaveGroupDescription")}],menuOptions={title:_globalize.default.translate("HeaderSyncPlayEnabled"),items:menuItems,positionTo:button,resolveOnClick:!0,border:!0};_actionsheet.default.show(menuOptions).then((function(id){"leave-group"==id&&apiClient.leaveSyncPlayGroup()})).catch((function(error){console.error("SyncPlay: unexpected error showing group menu:",error)})),_loading.default.hide()}(button,user,apiClient):showNewJoinGroupSelection(button,user,apiClient)})).catch((function(error){console.error(error),_loading.default.hide(),(0,_toast.default)({text:_globalize.default.translate("MessageSyncPlayNoGroupsAvailable")})}))},_events=_interopRequireDefault(_events),_connectionManager=_interopRequireDefault(_connectionManager),_playbackManager=_interopRequireDefault(_playbackManager),_syncPlayManager=_interopRequireDefault(_syncPlayManager),_loading=_interopRequireDefault(_loading),_toast=_interopRequireDefault(_toast),_actionsheet=_interopRequireDefault(_actionsheet),_globalize=_interopRequireDefault(_globalize),_playbackPermissionManager=_interopRequireDefault(_playbackPermissionManager);var syncPlayEnabled=!1;_events.default.on(_syncPlayManager.default,"enabled",(function(e,enabled){syncPlayEnabled=enabled}))}));
//# sourceMappingURL=groupSelectionMenu.js.map
