define(["playbackManager","nowPlayingHelper","events","connectionManager"],(function(_playbackManager,_nowPlayingHelper,_events,_connectionManager){"use strict";function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}var currentPlayer;function seriesImageUrl(item){var options=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};if(options.type=options.type||"Primary","Episode"!==item.Type)return null;if("Primary"===options.type&&item.SeriesPrimaryImageTag)return options.tag=item.SeriesPrimaryImageTag,_connectionManager.default.getApiClient(item.ServerId).getScaledImageUrl(item.SeriesId,options);if("Thumb"===options.type){if(item.SeriesThumbImageTag)return options.tag=item.SeriesThumbImageTag,_connectionManager.default.getApiClient(item.ServerId).getScaledImageUrl(item.SeriesId,options);if(item.ParentThumbImageTag)return options.tag=item.ParentThumbImageTag,_connectionManager.default.getApiClient(item.ServerId).getScaledImageUrl(item.ParentThumbItemId,options)}return null}function imageUrl(item){var options=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};return options.type=options.type||"Primary",item.ImageTags&&item.ImageTags[options.type]?(options.tag=item.ImageTags[options.type],_connectionManager.default.getApiClient(item.ServerId).getScaledImageUrl(item.Id,options)):item.AlbumId&&item.AlbumPrimaryImageTag?(options.tag=item.AlbumPrimaryImageTag,_connectionManager.default.getApiClient(item.ServerId).getScaledImageUrl(item.AlbumId,options)):null}function getImageUrl(item){var imageOptions=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},url=seriesImageUrl(item,imageOptions)||imageUrl(item,imageOptions);if(url){var height=imageOptions.height||imageOptions.maxHeight;return{src:url,sizes:height+"x"+height}}return null}function getImageUrls(item){var imageSizes=arguments.length>1&&void 0!==arguments[1]?arguments[1]:[96,128,192,256,384,512],list=[];return imageSizes.forEach((function(size){var url=getImageUrl(item,{height:size});null!==url&&list.push(url)})),list}function updatePlayerState(player,state,eventName){if("timeupdate"!==eventName){var item=state.NowPlayingItem;if(item){"init"===eventName&&(eventName="timeupdate");var isVideo="Video"===item.MediaType,isLocalPlayer=player.isLocalPlayer||!1;if(!isLocalPlayer||!isVideo){var playState=state.PlayState||{},parts=_nowPlayingHelper.default.getNowPlayingNames(item),artist=parts[parts.length-1].text,title=1===parts.length?"":parts[0].text,album=item.Album||"",itemId=item.Id,duration=parseInt(item.RunTimeTicks?item.RunTimeTicks/1e4:0),currentTime=parseInt(playState.PositionTicks?playState.PositionTicks/1e4:0),isPaused=playState.IsPaused||!1,canSeek=playState.CanSeek||!1;if("mediaSession"in navigator)navigator.mediaSession.metadata=new MediaMetadata({title:title,artist:artist,album:album,artwork:getImageUrls(item)});else{var itemImageUrl=seriesImageUrl(item,{maxHeight:3e3})||imageUrl(item,{maxHeight:3e3});window.NativeShell.updateMediaSession({action:eventName,isLocalPlayer:isLocalPlayer,itemId:itemId,title:title,artist:artist,album:album,duration:duration,position:currentTime,imageUrl:itemImageUrl,canSeek:canSeek,isPaused:isPaused})}}}else hideMediaControls()}}function onGeneralEvent(e){updatePlayerState(this,_playbackManager.default.getPlayerState(this),e.type)}function onStateChanged(e,state){updatePlayerState(this,state,"statechange")}function onPlaybackStart(e,state){updatePlayerState(this,state,e.type)}function onPlaybackStopped(){hideMediaControls()}function hideMediaControls(){"mediaSession"in navigator?navigator.mediaSession.metadata=null:window.NativeShell.hideMediaSession()}function bindToPlayer(player){(function releaseCurrentPlayer(){currentPlayer&&(_events.default.off(currentPlayer,"playbackstart",onPlaybackStart),_events.default.off(currentPlayer,"playbackstop",onPlaybackStopped),_events.default.off(currentPlayer,"unpause",onGeneralEvent),_events.default.off(currentPlayer,"pause",onGeneralEvent),_events.default.off(currentPlayer,"statechange",onStateChanged),_events.default.off(currentPlayer,"timeupdate",onGeneralEvent),currentPlayer=null,hideMediaControls())}(),player)&&(currentPlayer=player,updatePlayerState(player,_playbackManager.default.getPlayerState(player),"init"),_events.default.on(currentPlayer,"playbackstart",onPlaybackStart),_events.default.on(currentPlayer,"playbackstop",onPlaybackStopped),_events.default.on(currentPlayer,"unpause",onGeneralEvent),_events.default.on(currentPlayer,"pause",onGeneralEvent),_events.default.on(currentPlayer,"statechange",onStateChanged),_events.default.on(currentPlayer,"timeupdate",onGeneralEvent))}function execute(name){_playbackManager.default[name](currentPlayer)}_playbackManager=_interopRequireDefault(_playbackManager),_nowPlayingHelper=_interopRequireDefault(_nowPlayingHelper),_events=_interopRequireDefault(_events),_connectionManager=_interopRequireDefault(_connectionManager),"mediaSession"in navigator&&(navigator.mediaSession.setActionHandler("previoustrack",(function(){execute("previousTrack")})),navigator.mediaSession.setActionHandler("nexttrack",(function(){execute("nextTrack")})),navigator.mediaSession.setActionHandler("play",(function(){execute("unpause")})),navigator.mediaSession.setActionHandler("pause",(function(){execute("pause")})),navigator.mediaSession.setActionHandler("seekbackward",(function(){execute("rewind")})),navigator.mediaSession.setActionHandler("seekforward",(function(){execute("fastForward")})),navigator.mediaSession.setActionHandler("seekto",(function(object){var item=_playbackManager.default.getPlayerState(currentPlayer).NowPlayingItem,duration=parseInt(item.RunTimeTicks?item.RunTimeTicks/1e4:0),wantedTime=1e3*object.seekTime;_playbackManager.default.seekPercent(wantedTime/duration*100,currentPlayer)}))),_events.default.on(_playbackManager.default,"playerchange",(function(){bindToPlayer(_playbackManager.default.getCurrentPlayer())})),bindToPlayer(_playbackManager.default.getCurrentPlayer())}));
//# sourceMappingURL=mediasession.js.map
