define(["exports","datetime","itemHelper","emby-progressbar","css!./indicators.css","material-icons"],(function(_exports,_datetime,_itemHelper,_embyProgressbar,_indicators,_materialIcons){"use strict";function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function enableProgressIndicator(item){return"Video"===item.MediaType&&"TvChannel"!==item.Type||("AudioBook"===item.Type||"AudioPodcast"===item.Type)}function getProgressHtml(pct,options){var containerClass="itemProgressBar";return options&&options.containerClass&&(containerClass+=" "+options.containerClass),'<div class="'+containerClass+'"><div class="itemProgressBarForeground" style="width:'+pct+'%;"></div></div>'}function getProgressBarHtml(item,options){var pct;if(enableProgressIndicator(item)&&"Recording"!==item.Type){var userData=options&&options.userData?options.userData:item.UserData;if(userData&&(pct=userData.PlayedPercentage)&&pct<100)return getProgressHtml(pct,options)}if(("Program"===item.Type||"Timer"===item.Type||"Recording"===item.Type)&&item.StartDate&&item.EndDate){var startDate=0,endDate=1;try{startDate=_datetime.default.parseISO8601Date(item.StartDate).getTime(),endDate=_datetime.default.parseISO8601Date(item.EndDate).getTime()}catch(err){console.error(err)}if((pct=((new Date).getTime()-startDate)/(endDate-startDate)*100)>0&&pct<100)return function getAutoTimeProgressHtml(pct,options,isRecording,start,end){var containerClass="itemProgressBar";options&&options.containerClass&&(containerClass+=" "+options.containerClass);var foregroundClass="itemProgressBarForeground";return isRecording&&(foregroundClass+=" itemProgressBarForeground-recording"),'<div is="emby-progressbar" data-automode="time" data-starttime="'+start+'" data-endtime="'+end+'" class="'+containerClass+'"><div class="'+foregroundClass+'" style="width:'+pct+'%;"></div></div>'}(pct,options,"Timer"===item.Type||"Recording"===item.Type||item.TimerId,startDate,endDate)}return""}function enablePlayedIndicator(item){return _itemHelper.default.canMarkPlayed(item)}function getPlayedIndicatorHtml(item){if(enablePlayedIndicator(item)){var userData=item.UserData||{};if(userData.UnplayedItemCount)return'<div class="countIndicator indicator">'+userData.UnplayedItemCount+"</div>";if(userData.PlayedPercentage&&userData.PlayedPercentage>=100||userData.Played)return'<div class="playedIndicator indicator"><span class="material-icons indicatorIcon check"></span></div>'}return""}function getChildCountIndicatorHtml(item,options){var minCount=options&&options.minCount?options.minCount:0;return item.ChildCount&&item.ChildCount>minCount?'<div class="countIndicator indicator">'+item.ChildCount+"</div>":""}function getTimerIndicator(item){var status;if("SeriesTimer"===item.Type)return'<span class="material-icons timerIndicator indicatorIcon fiber_smart_record"></span>';if(item.TimerId||item.SeriesTimerId)status=item.Status||"Cancelled";else{if("Timer"!==item.Type)return"";status=item.Status}return item.SeriesTimerId?"Cancelled"!==status?'<span class="material-icons timerIndicator indicatorIcon fiber_smart_record"></span>':'<span class="material-icons timerIndicator timerIndicator-inactive indicatorIcon fiber_smart_record"></span>':'<span class="material-icons timerIndicator indicatorIcon fiber_manual_record"></span>'}function getSyncIndicator(item){return 100===item.SyncPercent?'<div class="syncIndicator indicator fullSyncIndicator"><span class="material-icons indicatorIcon file_download"></span></div>':null!=item.SyncPercent?'<div class="syncIndicator indicator emptySyncIndicator"><span class="material-icons indicatorIcon file_download"></span></div>':""}function getTypeIndicator(item){var icon={Video:"videocam",Folder:"folder",PhotoAlbum:"photo_album",Photo:"photo"}[item.Type];return icon?'<div class="indicator videoIndicator"><span class="material-icons indicatorIcon '+icon+'"></span></div>':""}function getMissingIndicator(item){if("Episode"===item.Type&&"Virtual"===item.LocationType){if(item.PremiereDate)try{if(_datetime.default.parseISO8601Date(item.PremiereDate).getTime()>(new Date).getTime())return'<div class="unairedIndicator">Unaired</div>'}catch(err){console.error(err)}return'<div class="missingIndicator">Missing</div>'}return""}Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.enableProgressIndicator=enableProgressIndicator,_exports.getProgressHtml=getProgressHtml,_exports.getProgressBarHtml=getProgressBarHtml,_exports.enablePlayedIndicator=enablePlayedIndicator,_exports.getPlayedIndicatorHtml=getPlayedIndicatorHtml,_exports.getChildCountIndicatorHtml=getChildCountIndicatorHtml,_exports.getTimerIndicator=getTimerIndicator,_exports.getSyncIndicator=getSyncIndicator,_exports.getTypeIndicator=getTypeIndicator,_exports.getMissingIndicator=getMissingIndicator,_exports.default=void 0,_datetime=_interopRequireDefault(_datetime),_itemHelper=_interopRequireDefault(_itemHelper);var _default={getProgressHtml:getProgressHtml,getProgressBarHtml:getProgressBarHtml,getPlayedIndicatorHtml:getPlayedIndicatorHtml,getChildCountIndicatorHtml:getChildCountIndicatorHtml,enableProgressIndicator:enableProgressIndicator,getTimerIndicator:getTimerIndicator,enablePlayedIndicator:enablePlayedIndicator,getSyncIndicator:getSyncIndicator,getTypeIndicator:getTypeIndicator,getMissingIndicator:getMissingIndicator};_exports.default=_default}));
//# sourceMappingURL=indicators.js.map
