# coding: utf-8

"""
    DocuSign Rooms API - v2

    An API for an integrator to access the features of DocuSign Rooms  # noqa: E501

    OpenAPI spec version: v2
    Contact: devcenter@docusign.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import sys
import os
import re

# python 2 and python 3 compatibility library
from six import iteritems

from ..client.configuration import Configuration
from ..client.api_client import ApiClient


class ExternalFormFillSessionsApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    def create_external_form_fill_session(self, form_fill_session_for_create, account_id, **kwargs):
        """
        Creates an external form fill session.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_external_form_fill_session(form_fill_session_for_create, account_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param ExternalFormFillSessionForCreate form_fill_session_for_create: (required)
        :param str account_id: (required)
        :return: ExternalFormFillSession
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_external_form_fill_session_with_http_info(form_fill_session_for_create, account_id, **kwargs)
        else:
            (data) = self.create_external_form_fill_session_with_http_info(form_fill_session_for_create, account_id, **kwargs)
            return data

    def create_external_form_fill_session_with_http_info(self, form_fill_session_for_create, account_id, **kwargs):
        """
        Creates an external form fill session.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_external_form_fill_session_with_http_info(form_fill_session_for_create, account_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param ExternalFormFillSessionForCreate form_fill_session_for_create: (required)
        :param str account_id: (required)
        :return: ExternalFormFillSession
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['form_fill_session_for_create', 'account_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_external_form_fill_session" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'form_fill_session_for_create' is set
        if ('form_fill_session_for_create' not in params) or (params['form_fill_session_for_create'] is None):
            raise ValueError("Missing the required parameter `form_fill_session_for_create` when calling `create_external_form_fill_session`")
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `create_external_form_fill_session`")


        collection_formats = {}

        resource_path = '/v2/accounts/{accountId}/external_form_fill_sessions'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'form_fill_session_for_create' in params:
            body_params = params['form_fill_session_for_create']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ExternalFormFillSession',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)
