"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.resolve = void 0;
function resolve(value, options = {}) {
    var _a, _b, _c, _d;
    const args = (_a = options.args) !== null && _a !== void 0 ? _a : [];
    const omitEmpty = (_b = options.omitEmpty) !== null && _b !== void 0 ? _b : false;
    if (value == null) {
        return value;
    }
    // if value is a function, call it and resolve the result.
    if (typeof (value) === 'function') {
        const resolved = value.apply(undefined, args);
        return resolve(resolved, options);
    }
    if (typeof (value) !== 'object') {
        return value;
    }
    if (Array.isArray(value)) {
        if (omitEmpty && value.length === 0) {
            return undefined;
        }
        return value
            .map(x => resolve(x, options))
            .filter(x => x != null); // filter undefined/null/omitted
    }
    // only allow data types (i.e. objects without constructors)
    if (value.constructor && ((_c = value.constructor) === null || _c === void 0 ? void 0 : _c.name) !== 'Object') {
        throw new Error(`only data types can be resolved. trying to resolve object of type ${(_d = value.constructor) === null || _d === void 0 ? void 0 : _d.name}`);
    }
    const result = {};
    for (const [k, v] of Object.entries(value)) {
        const resolved = resolve(v, options);
        // skip undefined values
        if (resolved === undefined) {
            continue;
        }
        result[k] = resolved;
    }
    if (omitEmpty && Object.keys(result).length === 0) {
        return undefined;
    }
    return result;
}
exports.resolve = resolve;
//# sourceMappingURL=data:application/json;base64,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