"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const logging = require("../logging");
const util_1 = require("./util");
logging.disable();
describe('SampleReadProps', () => {
    test('default SampleReadme', () => {
        // GIVEN
        const project = new util_1.TestProject();
        // WHEN
        const output = util_1.synthSnapshot(project);
        // THEN
        const upper = output['README.md'];
        const lower = output['readme.md'];
        expect(upper).toBeTruthy();
        expect(lower).toBeFalsy();
    });
    test('customized w/ default SampleReadme', () => {
        // GIVEN
        const project = new util_1.TestProject({
            readme: {
                filename: 'README.md',
            },
        });
        // WHEN
        const output = util_1.synthSnapshot(project);
        // THEN
        const upper = output['README.md'];
        const lower = output['readme.md'];
        expect(upper).toBeTruthy();
        expect(lower).toBeFalsy();
    });
    test('customized SampleReadme', () => {
        // GIVEN
        const project = new util_1.TestProject({
            readme: {
                filename: 'readme.md',
            },
        });
        // WHEN
        const output = util_1.synthSnapshot(project);
        // THEN
        const upper = output['README.md'];
        const lower = output['readme.md'];
        expect(upper).toBeFalsy();
        expect(lower).toBeTruthy();
    });
    test('SampleReadme customized contents in constructor', () => {
        // GIVEN
        const project = new util_1.TestProject({
            readme: {
                contents: 'my stuff',
            },
        });
        // WHEN
        const output = util_1.synthSnapshot(project);
        // THEN
        const readme = output['README.md'];
        expect(readme).toBeTruthy();
        expect(readme).toStrictEqual('my stuff');
    });
});
//# sourceMappingURL=data:application/json;base64,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