"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const logger_1 = require("../../logger");
const python_1 = require("../../python");
const util_1 = require("../util");
test('setuptools enabled', () => {
    const p = new TestPythonProject({
        setuptools: true,
        homepage: 'http://www.example.com',
        description: 'a short project description',
        license: 'Apache Software License',
        classifiers: [
            'Development Status :: 4 - Beta',
        ],
    });
    const snapshot = util_1.synthSnapshot(p);
    expect(snapshot['setup.py']).toContain('First Last');
    expect(snapshot['setup.py']).toContain('email@example.com');
    expect(snapshot['setup.py']).toContain('http://www.example.com');
    expect(snapshot['setup.py']).toContain('a short project description');
    expect(snapshot['setup.py']).toContain('Apache Software License');
    expect(snapshot['setup.py']).toContain('Development Status :: 4 - Beta');
});
class TestPythonProject extends python_1.PythonProject {
    constructor(options = {}) {
        super({
            ...options,
            clobber: false,
            name: 'test-python-project',
            moduleName: 'test_python_project',
            authorName: 'First Last',
            authorEmail: 'email@example.com',
            version: '0.1.0',
            outdir: util_1.mkdtemp(),
            logging: { level: logger_1.LogLevel.OFF },
        });
    }
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic2V0dXB0b29scy50ZXN0LmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vc3JjL19fdGVzdHNfXy9weXRob24vc2V0dXB0b29scy50ZXN0LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7O0FBQUEseUNBQXdDO0FBQ3hDLHlDQUFtRTtBQUNuRSxrQ0FBaUQ7QUFFakQsSUFBSSxDQUFDLG9CQUFvQixFQUFFLEdBQUcsRUFBRTtJQUM5QixNQUFNLENBQUMsR0FBRyxJQUFJLGlCQUFpQixDQUFDO1FBQzlCLFVBQVUsRUFBRSxJQUFJO1FBQ2hCLFFBQVEsRUFBRSx3QkFBd0I7UUFDbEMsV0FBVyxFQUFFLDZCQUE2QjtRQUMxQyxPQUFPLEVBQUUseUJBQXlCO1FBQ2xDLFdBQVcsRUFBRTtZQUNYLGdDQUFnQztTQUNqQztLQUNGLENBQUMsQ0FBQztJQUVILE1BQU0sUUFBUSxHQUFHLG9CQUFhLENBQUMsQ0FBQyxDQUFDLENBQUM7SUFDbEMsTUFBTSxDQUFDLFFBQVEsQ0FBQyxVQUFVLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxZQUFZLENBQUMsQ0FBQztJQUNyRCxNQUFNLENBQUMsUUFBUSxDQUFDLFVBQVUsQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLG1CQUFtQixDQUFDLENBQUM7SUFDNUQsTUFBTSxDQUFDLFFBQVEsQ0FBQyxVQUFVLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyx3QkFBd0IsQ0FBQyxDQUFDO0lBQ2pFLE1BQU0sQ0FBQyxRQUFRLENBQUMsVUFBVSxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsNkJBQTZCLENBQUMsQ0FBQztJQUN0RSxNQUFNLENBQUMsUUFBUSxDQUFDLFVBQVUsQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLHlCQUF5QixDQUFDLENBQUM7SUFDbEUsTUFBTSxDQUFDLFFBQVEsQ0FBQyxVQUFVLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxnQ0FBZ0MsQ0FBQyxDQUFDO0FBQzNFLENBQUMsQ0FBQyxDQUFDO0FBRUgsTUFBTSxpQkFBa0IsU0FBUSxzQkFBYTtJQUMzQyxZQUFZLFVBQXlDLEVBQUc7UUFDdEQsS0FBSyxDQUFDO1lBQ0osR0FBRyxPQUFPO1lBQ1YsT0FBTyxFQUFFLEtBQUs7WUFDZCxJQUFJLEVBQUUscUJBQXFCO1lBQzNCLFVBQVUsRUFBRSxxQkFBcUI7WUFDakMsVUFBVSxFQUFFLFlBQVk7WUFDeEIsV0FBVyxFQUFFLG1CQUFtQjtZQUNoQyxPQUFPLEVBQUUsT0FBTztZQUNoQixNQUFNLEVBQUUsY0FBTyxFQUFFO1lBQ2pCLE9BQU8sRUFBRSxFQUFFLEtBQUssRUFBRSxpQkFBUSxDQUFDLEdBQUcsRUFBRTtTQUNqQyxDQUFDLENBQUM7SUFDTCxDQUFDO0NBQ0YiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBMb2dMZXZlbCB9IGZyb20gJy4uLy4uL2xvZ2dlcic7XG5pbXBvcnQgeyBQeXRob25Qcm9qZWN0LCBQeXRob25Qcm9qZWN0T3B0aW9ucyB9IGZyb20gJy4uLy4uL3B5dGhvbic7XG5pbXBvcnQgeyBta2R0ZW1wLCBzeW50aFNuYXBzaG90IH0gZnJvbSAnLi4vdXRpbCc7XG5cbnRlc3QoJ3NldHVwdG9vbHMgZW5hYmxlZCcsICgpID0+IHtcbiAgY29uc3QgcCA9IG5ldyBUZXN0UHl0aG9uUHJvamVjdCh7XG4gICAgc2V0dXB0b29sczogdHJ1ZSxcbiAgICBob21lcGFnZTogJ2h0dHA6Ly93d3cuZXhhbXBsZS5jb20nLFxuICAgIGRlc2NyaXB0aW9uOiAnYSBzaG9ydCBwcm9qZWN0IGRlc2NyaXB0aW9uJyxcbiAgICBsaWNlbnNlOiAnQXBhY2hlIFNvZnR3YXJlIExpY2Vuc2UnLFxuICAgIGNsYXNzaWZpZXJzOiBbXG4gICAgICAnRGV2ZWxvcG1lbnQgU3RhdHVzIDo6IDQgLSBCZXRhJyxcbiAgICBdLFxuICB9KTtcblxuICBjb25zdCBzbmFwc2hvdCA9IHN5bnRoU25hcHNob3QocCk7XG4gIGV4cGVjdChzbmFwc2hvdFsnc2V0dXAucHknXSkudG9Db250YWluKCdGaXJzdCBMYXN0Jyk7XG4gIGV4cGVjdChzbmFwc2hvdFsnc2V0dXAucHknXSkudG9Db250YWluKCdlbWFpbEBleGFtcGxlLmNvbScpO1xuICBleHBlY3Qoc25hcHNob3RbJ3NldHVwLnB5J10pLnRvQ29udGFpbignaHR0cDovL3d3dy5leGFtcGxlLmNvbScpO1xuICBleHBlY3Qoc25hcHNob3RbJ3NldHVwLnB5J10pLnRvQ29udGFpbignYSBzaG9ydCBwcm9qZWN0IGRlc2NyaXB0aW9uJyk7XG4gIGV4cGVjdChzbmFwc2hvdFsnc2V0dXAucHknXSkudG9Db250YWluKCdBcGFjaGUgU29mdHdhcmUgTGljZW5zZScpO1xuICBleHBlY3Qoc25hcHNob3RbJ3NldHVwLnB5J10pLnRvQ29udGFpbignRGV2ZWxvcG1lbnQgU3RhdHVzIDo6IDQgLSBCZXRhJyk7XG59KTtcblxuY2xhc3MgVGVzdFB5dGhvblByb2plY3QgZXh0ZW5kcyBQeXRob25Qcm9qZWN0IHtcbiAgY29uc3RydWN0b3Iob3B0aW9uczogUGFydGlhbDxQeXRob25Qcm9qZWN0T3B0aW9ucz4gPSB7IH0pIHtcbiAgICBzdXBlcih7XG4gICAgICAuLi5vcHRpb25zLFxuICAgICAgY2xvYmJlcjogZmFsc2UsXG4gICAgICBuYW1lOiAndGVzdC1weXRob24tcHJvamVjdCcsXG4gICAgICBtb2R1bGVOYW1lOiAndGVzdF9weXRob25fcHJvamVjdCcsXG4gICAgICBhdXRob3JOYW1lOiAnRmlyc3QgTGFzdCcsXG4gICAgICBhdXRob3JFbWFpbDogJ2VtYWlsQGV4YW1wbGUuY29tJyxcbiAgICAgIHZlcnNpb246ICcwLjEuMCcsXG4gICAgICBvdXRkaXI6IG1rZHRlbXAoKSxcbiAgICAgIGxvZ2dpbmc6IHsgbGV2ZWw6IExvZ0xldmVsLk9GRiB9LFxuICAgIH0pO1xuICB9XG59XG4iXX0=