"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const deps_1 = require("../../deps");
const java_1 = require("../../java");
const util_1 = require("../util");
test('group/artifact/version', () => {
    const pom = new TestPom({
        groupId: 'my.group.id',
        artifactId: 'mfoo-bar',
        version: '1.2.3',
    });
    expect(actualPom(pom)).toMatchSnapshot();
});
test('optional metadata', () => {
    const pom = new TestPom({
        groupId: 'my.group.id',
        artifactId: 'mfoo-bar',
        version: '1.2.3',
        description: 'hello, world!',
        url: 'https://foo/bar',
        packaging: 'not_jar',
    });
    expect(actualPom(pom)).toMatchSnapshot();
});
test('addProperty()', () => {
    const pom = new TestPom();
    pom.addProperty('project.build.sourceEncoding', 'UTF-8');
    pom.addProperty('junit.version', '5.7.0');
    expect(actualPom(pom)).toMatchSnapshot();
});
test('addDependency()', () => {
    const pom = new TestPom();
    pom.addDependency('software.amazon.awscdk/core');
    // dependencies are managed at the project level
    pom.project.deps.addDependency('org.assertj/assertj-core@^3.18.1', deps_1.DependencyType.TEST);
    expect(actualPom(pom)).toMatchSnapshot();
    // check that pom.addDependency() updates the project
    expect(pom.project.deps.getDependency('software.amazon.awscdk/core')).toStrictEqual({
        name: 'software.amazon.awscdk/core',
        type: 'runtime',
    });
});
test('addPlugin()', () => {
    const pom = new TestPom();
    pom.addPlugin('org.apache.maven.plugins/maven-compiler-plugin@3.8.1', {
        dependencies: [
            'org.projen/projen@^0.14',
        ],
        configuration: {
            source: '1.8',
            target: '1.8',
        },
    });
    // alteratively
    pom.project.deps.addDependency('org.codehaus.mojo/exec-maven-plugin@3.0.0', deps_1.DependencyType.BUILD, {
        configuration: {
            mainClass: 'com.myorg.Play202101050157App',
        },
    });
    expect(actualPom(pom)).toMatchSnapshot();
});
function actualPom(p) {
    const snap = util_1.synthSnapshot(p.project);
    return snap[p.fileName];
}
class TestPom extends java_1.Pom {
    constructor(options) {
        super(new util_1.TestProject(), options !== null && options !== void 0 ? options : {
            groupId: 'org.acme',
            artifactId: 'my-artifact',
            version: '1.2.3',
        });
    }
}
//# sourceMappingURL=data:application/json;base64,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