"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const cdk8s_app_ts_1 = require("../cdk8s-app-ts");
const logger_1 = require("../logger");
const util_1 = require("./util");
test('test if cdk8s synth is possible', () => {
    const project = new TestCdk8sAppProject({
        cdk8sVersion: '1.0.0-beta.11',
        name: 'project',
        defaultReleaseBranch: 'main',
        releaseWorkflow: true,
    });
    const output = util_1.synthSnapshot(project);
    // expect a synth script
    expect(output['package.json'].scripts.synth).toContain('npx projen synth');
    // expect a synth task
    expect(output['.projen/tasks.json'].tasks.synth.steps).toStrictEqual([{
            exec: 'cdk8s synth',
        }]);
    // expect build step to contain synth
    expect(output['.projen/tasks.json'].tasks.build.steps).toStrictEqual([
        {
            exec: 'npx projen',
        },
        {
            spawn: 'test',
        },
        {
            spawn: 'compile',
        },
        {
            spawn: 'synth',
        },
    ]);
    expect(output['package.json'].dependencies).toStrictEqual({
        'cdk8s': '^1.0.0-beta.11',
        'cdk8s-plus-17': '^1.0.0-beta.11',
        'constructs': '^3.2.34',
    });
});
class TestCdk8sAppProject extends cdk8s_app_ts_1.Cdk8sTypeScriptApp {
    constructor(options) {
        super({
            outdir: util_1.mkdtemp(),
            logging: {
                level: logger_1.LogLevel.OFF,
            },
            ...options,
        });
    }
}
//# sourceMappingURL=data:application/json;base64,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