"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const awscdk_construct_1 = require("../awscdk-construct");
const logger_1 = require("../logger");
const node_package_1 = require("../node-package");
const util_1 = require("./util");
describe('constructs dependency selection', () => {
    test('user-selected', () => {
        var _a, _b, _c, _d, _e, _f;
        // GIVEN
        const project = new TestProject({ cdkVersion: '1.100.0', constructsVersion: '42.1337.0-ultimate.∞' });
        // WHEN
        const snapshot = util_1.synthSnapshot(project);
        // THEN
        expect((_b = (_a = snapshot['package.json']) === null || _a === void 0 ? void 0 : _a.peerDependencies) === null || _b === void 0 ? void 0 : _b.constructs).toBe('^42.1337.0-ultimate.∞');
        expect((_d = (_c = snapshot['package.json']) === null || _c === void 0 ? void 0 : _c.devDependencies) === null || _d === void 0 ? void 0 : _d.constructs).toBe('42.1337.0-ultimate.∞');
        expect((_f = (_e = snapshot['package.json']) === null || _e === void 0 ? void 0 : _e.dependencies) === null || _f === void 0 ? void 0 : _f.constructs).toBeUndefined();
    });
    test('for cdk 1.x', () => {
        var _a, _b, _c, _d, _e, _f;
        // GIVEN
        const project = new TestProject({ cdkVersion: '1.100.0' });
        // WHEN
        const snapshot = util_1.synthSnapshot(project);
        // THEN
        expect((_b = (_a = snapshot['package.json']) === null || _a === void 0 ? void 0 : _a.peerDependencies) === null || _b === void 0 ? void 0 : _b.constructs).toMatch(/^\^3\./);
        expect((_d = (_c = snapshot['package.json']) === null || _c === void 0 ? void 0 : _c.devDependencies) === null || _d === void 0 ? void 0 : _d.constructs).toBeUndefined();
        expect((_f = (_e = snapshot['package.json']) === null || _e === void 0 ? void 0 : _e.dependencies) === null || _f === void 0 ? void 0 : _f.constructs).toBeUndefined();
    });
    test('for cdk 2.x', () => {
        var _a, _b, _c, _d, _e, _f;
        // GIVEN
        const project = new TestProject({ cdkVersion: '2.0.0-alpha.5' });
        // WHEN
        const snapshot = util_1.synthSnapshot(project);
        // THEN
        expect((_b = (_a = snapshot['package.json']) === null || _a === void 0 ? void 0 : _a.peerDependencies) === null || _b === void 0 ? void 0 : _b.constructs).toMatch(/^\^10./);
        expect((_d = (_c = snapshot['package.json']) === null || _c === void 0 ? void 0 : _c.devDependencies) === null || _d === void 0 ? void 0 : _d.constructs).toBeUndefined();
        expect((_f = (_e = snapshot['package.json']) === null || _e === void 0 ? void 0 : _e.dependencies) === null || _f === void 0 ? void 0 : _f.constructs).toBeUndefined();
    });
    test('for cdk 3.x (does not exist yet)', () => {
        var _a, _b, _c, _d, _e, _f;
        // GIVEN
        const project = new TestProject({ cdkVersion: '3.1337.42' });
        // WHEN
        const snapshot = util_1.synthSnapshot(project);
        // THEN
        expect((_b = (_a = snapshot['package.json']) === null || _a === void 0 ? void 0 : _a.peerDependencies) === null || _b === void 0 ? void 0 : _b.constructs).toBe('*');
        expect((_d = (_c = snapshot['package.json']) === null || _c === void 0 ? void 0 : _c.devDependencies) === null || _d === void 0 ? void 0 : _d.constructs).toBeUndefined();
        expect((_f = (_e = snapshot['package.json']) === null || _e === void 0 ? void 0 : _e.dependencies) === null || _f === void 0 ? void 0 : _f.constructs).toBeUndefined();
    });
});
const defaultOptions = {
    author: 'Nobody',
    authorAddress: 'nobody@nowhere.com',
    clobber: false,
    defaultReleaseBranch: 'main',
    jest: false,
    name: 'test-project',
    npmAccess: node_package_1.NpmAccess.PUBLIC,
    repositoryUrl: 'https://github.com/projen/projen.git',
};
class TestProject extends awscdk_construct_1.AwsCdkConstructLibrary {
    constructor(options) {
        super({
            outdir: util_1.mkdtemp(),
            logging: {
                level: logger_1.LogLevel.OFF,
            },
            ...defaultOptions,
            ...options,
        });
    }
}
//# sourceMappingURL=data:application/json;base64,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