"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const awscdk_app_ts_1 = require("../awscdk-app-ts");
const util_1 = require("./util");
describe('cdkVersion is >= 2.0.0', () => {
    test('use "aws-cdk-lib" the constructs at ^10.0.5', () => {
        const project = new awscdk_app_ts_1.AwsCdkTypeScriptApp({
            outdir: util_1.mkdtemp(),
            cdkVersion: '2.0.0-rc.1',
            defaultReleaseBranch: 'main',
            name: 'test',
        });
        const snap = util_1.synthSnapshot(project);
        expect(snap['package.json'].dependencies).toStrictEqual({
            '@aws-cdk/assert': '^2.0.0-rc.1',
            'aws-cdk-lib': '^2.0.0-rc.1',
            'constructs': '^10.0.5',
        });
        expect(snap['src/main.ts'].indexOf('import { App, Stack, StackProps } from \'aws-cdk-lib\'')).not.toEqual(-1);
    });
});
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYXdzY2RrLWFwcC50ZXN0LmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vc3JjL19fdGVzdHNfXy9hd3NjZGstYXBwLnRlc3QudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7QUFBQSxvREFBdUQ7QUFDdkQsaUNBQWdEO0FBRWhELFFBQVEsQ0FBQyx3QkFBd0IsRUFBRSxHQUFHLEVBQUU7SUFDdEMsSUFBSSxDQUFDLDZDQUE2QyxFQUFFLEdBQUcsRUFBRTtRQUN2RCxNQUFNLE9BQU8sR0FBRyxJQUFJLG1DQUFtQixDQUFDO1lBQ3RDLE1BQU0sRUFBRSxjQUFPLEVBQUU7WUFDakIsVUFBVSxFQUFFLFlBQVk7WUFDeEIsb0JBQW9CLEVBQUUsTUFBTTtZQUM1QixJQUFJLEVBQUUsTUFBTTtTQUNiLENBQUMsQ0FBQztRQUNILE1BQU0sSUFBSSxHQUFHLG9CQUFhLENBQUMsT0FBTyxDQUFDLENBQUM7UUFDcEMsTUFBTSxDQUFDLElBQUksQ0FBQyxjQUFjLENBQUMsQ0FBQyxZQUFZLENBQUMsQ0FBQyxhQUFhLENBQUM7WUFDdEQsaUJBQWlCLEVBQUUsYUFBYTtZQUNoQyxhQUFhLEVBQUUsYUFBYTtZQUM1QixZQUFZLEVBQUUsU0FBUztTQUN4QixDQUFDLENBQUM7UUFDSCxNQUFNLENBQUMsSUFBSSxDQUFDLGFBQWEsQ0FBQyxDQUFDLE9BQU8sQ0FBQyx3REFBd0QsQ0FBQyxDQUFDLENBQUMsR0FBRyxDQUFDLE9BQU8sQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDO0lBQ2hILENBQUMsQ0FBQyxDQUFDO0FBQ0wsQ0FBQyxDQUFDLENBQUMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBBd3NDZGtUeXBlU2NyaXB0QXBwIH0gZnJvbSAnLi4vYXdzY2RrLWFwcC10cyc7XG5pbXBvcnQgeyBta2R0ZW1wLCBzeW50aFNuYXBzaG90IH0gZnJvbSAnLi91dGlsJztcblxuZGVzY3JpYmUoJ2Nka1ZlcnNpb24gaXMgPj0gMi4wLjAnLCAoKSA9PiB7XG4gIHRlc3QoJ3VzZSBcImF3cy1jZGstbGliXCIgdGhlIGNvbnN0cnVjdHMgYXQgXjEwLjAuNScsICgpID0+IHtcbiAgICBjb25zdCBwcm9qZWN0ID0gbmV3IEF3c0Nka1R5cGVTY3JpcHRBcHAoe1xuICAgICAgb3V0ZGlyOiBta2R0ZW1wKCksXG4gICAgICBjZGtWZXJzaW9uOiAnMi4wLjAtcmMuMScsXG4gICAgICBkZWZhdWx0UmVsZWFzZUJyYW5jaDogJ21haW4nLFxuICAgICAgbmFtZTogJ3Rlc3QnLFxuICAgIH0pO1xuICAgIGNvbnN0IHNuYXAgPSBzeW50aFNuYXBzaG90KHByb2plY3QpO1xuICAgIGV4cGVjdChzbmFwWydwYWNrYWdlLmpzb24nXS5kZXBlbmRlbmNpZXMpLnRvU3RyaWN0RXF1YWwoe1xuICAgICAgJ0Bhd3MtY2RrL2Fzc2VydCc6ICdeMi4wLjAtcmMuMScsXG4gICAgICAnYXdzLWNkay1saWInOiAnXjIuMC4wLXJjLjEnLFxuICAgICAgJ2NvbnN0cnVjdHMnOiAnXjEwLjAuNScsXG4gICAgfSk7XG4gICAgZXhwZWN0KHNuYXBbJ3NyYy9tYWluLnRzJ10uaW5kZXhPZignaW1wb3J0IHsgQXBwLCBTdGFjaywgU3RhY2tQcm9wcyB9IGZyb20gXFwnYXdzLWNkay1saWJcXCcnKSkubm90LnRvRXF1YWwoLTEpO1xuICB9KTtcbn0pO1xuIl19