# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['zettelkasten']

package_data = \
{'': ['*']}

install_requires = \
['GitPython>=3.1.14,<4.0.0',
 'Pygments>=2.8.1,<3.0.0',
 'Sphinx>=3.5.2,<4.0.0',
 'importlib-metadata>=3.7.0,<4.0.0',
 'pylint>=2.7.0,<3.0.0',
 'pytest-dependency>=0.5.1,<0.6.0',
 'rich>=9.13.0,<10.0.0',
 'smmap2>=3.0.1,<4.0.0',
 'smmap>=3.0.1,<4.0.0',
 'typer[all]>=0.3.2,<0.4.0']

extras_require = \
{':python_version < "3.8"': ['importlib_metadata>=3.4.0,<4.0.0']}

entry_points = \
{'console_scripts': ['zettelkasten = zettelkasten.cli:app']}

setup_kwargs = {
    'name': 'zettelkasten',
    'version': '0.2.0',
    'description': 'CLI interface for managing a folder based zettelkasten using emacs org-mode file zettels and a bibtex reference system',
    'long_description': '# zettelkasten\n\n<div align="center">\n\n[![Build status](https://github.com/tZ3ma/zettelkasten/workflows/build/badge.svg?branch=master&event=push)](https://github.com/tZ3ma/zettelkasten/actions?query=workflow%3Abuild)\n[![Python Version](https://img.shields.io/pypi/pyversions/zettelkasten.svg)](https://pypi.org/project/zettelkasten/)\n[![Dependencies Status](https://img.shields.io/badge/dependencies-up%20to%20date-brightgreen.svg)](https://github.com/tZ3ma/zettelkasten/pulls?utf8=%E2%9C%93&q=is%3Apr%20author%3Aapp%2Fdependabot)\n\n[![Code style: black](https://img.shields.io/badge/code%20style-black-000000.svg)](https://github.com/psf/black)\n[![Security: bandit](https://img.shields.io/badge/security-bandit-green.svg)](https://github.com/PyCQA/bandit)\n[![Pre-commit](https://img.shields.io/badge/pre--commit-enabled-brightgreen?logo=pre-commit&logoColor=white)](https://github.com/tZ3ma/zettelkasten/blob/master/.pre-commit-config.yaml)\n[![Semantic Versions](https://img.shields.io/badge/%F0%9F%9A%80-semantic%20versions-informational.svg)](https://github.com/tZ3ma/zettelkasten/releases)\n[![License](https://img.shields.io/github/license/tZ3ma/zettelkasten)](https://github.com/tZ3ma/zettelkasten/blob/master/LICENSE)\n\nFolder based zettelkasten with a bibtex reference system and emacs org-mode file zettels\n\n</div>\n\n## Very first steps\n\n### Initial\n\n1. Initialize `git` inside your repo:\n\n```bash\ngit init\n```\n\n2. If you don\'t have `Poetry` installed run:\n\n```bash\nmake download-poetry\n```\n\n3. Initialize poetry and install `pre-commit` hooks:\n\n```bash\nmake install\n```\n\n4. Upload initial code to GitHub (ensure you\'ve run `make install` to use `pre-commit`):\n\n```bash\ngit add .\ngit commit -m ":tada: Initial commit"\ngit branch -M main\ngit remote add origin https://github.com/tZ3ma/zettelkasten.git\ngit push -u origin main\n```\n\n### Initial setting up\n\n- Set up [Dependabot](https://docs.github.com/en/github/administering-a-repository/enabling-and-disabling-version-updates#enabling-github-dependabot-version-updates) to ensure you have the latest dependencies.\n- Set up [Stale bot](https://github.com/apps/stale) for automatic issue closing.\n\n### Poetry\n\nAll manipulations with dependencies are executed through Poetry. If you\'re new to it, look through [the documentation](https://python-poetry.org/docs/).\n\n<details>\n<summary>Notes about Poetry</summary>\n<p>\n\nPoetry\'s [commands](https://python-poetry.org/docs/cli/#commands) are very intuitive and easy to learn, like:\n\n- `poetry add numpy`\n- `poetry run pytest`\n- `poetry build`\n- etc\n\n</p>\n</details>\n\n### Building your package\n\nBuilding a new version of the application contains steps:\n\n- Bump the version of your package `poetry version <version>`. You can pass the new version explicitly, or a rule such as `major`, `minor`, or `patch`. For more details, refer to the [Semantic Versions](https://semver.org/) standard.\n- Make a commit to `GitHub`.\n- Create a `GitHub release`.\n- And... publish 🙂 `poetry publish --build`\n\n## What\'s next\n\nWell, that\'s up to you. I can only recommend the packages and articles that helped me.\n\nPackages:\n\n- [`Typer`](https://github.com/tiangolo/typer) is great for creating CLI applications.\n- [`Rich`](https://github.com/willmcgugan/rich) makes it easy to add beautiful formatting in the terminal.\n- [`FastAPI`](https://github.com/tiangolo/fastapi) is a type-driven asynchronous web framework.\n- [`IceCream`](https://github.com/gruns/icecream) is a little library for sweet and creamy debugging\n\nArticles:\n\n- [Open Source Guides](https://opensource.guide/)\n- [GitHub Actions Documentation](https://help.github.com/en/actions)\n- Maybe you would like to add [gitmoji](https://gitmoji.carloscuesta.me/) to commit names. This is really funny. 😄\n\n## 🚀 Features\n\nFor your development we\'ve prepared:\n\n- Supports for `Python 3.7` and higher.\n- [`Poetry`](https://python-poetry.org/) as the dependencies manager. See configuration in [`pyproject.toml`](https://github.com/tZ3ma/zettelkasten/blob/master/pyproject.toml) and [`setup.cfg`](https://github.com/tZ3ma/zettelkasten/blob/master/setup.cfg).\n- Power of [`black`](https://github.com/psf/black), [`isort`](https://github.com/timothycrosley/isort) and [`pyupgrade`](https://github.com/asottile/pyupgrade) formatters.\n- Ready-to-use [`pre-commit`](https://pre-commit.com/) hooks with formatters above.\n- Type checks with the configured [`mypy`](https://mypy.readthedocs.io).\n- Testing with [`pytest`](https://docs.pytest.org/en/latest/).\n- Docstring checks with [`darglint`](https://github.com/terrencepreilly/darglint).\n- Security checks with [`safety`](https://github.com/pyupio/safety) and [`bandit`](https://github.com/PyCQA/bandit).\n- Well-made [`.editorconfig`](https://github.com/tZ3ma/zettelkasten/blob/master/.editorconfig), [`.dockerignore`](https://github.com/tZ3ma/zettelkasten/blob/master/.dockerignore), and [`.gitignore`](https://github.com/tZ3ma/zettelkasten/blob/master/.gitignore). You don\'t have to worry about those things.\n\nFor building and deployment:\n\n- `GitHub` integration.\n- [`Makefile`](https://github.com/tZ3ma/zettelkasten/blob/master/Makefile#L89) for building routines. Everything is already set up for security checks, codestyle checks, code formatting, testing, linting, docker builds, etc. More details at [Makefile summary](#makefile-usage)).\n- [Dockerfile](https://github.com/tZ3ma/zettelkasten/blob/master/docker/Dockerfile) for your package.\n- `Github Actions` with predefined [build workflow](https://github.com/tZ3ma/zettelkasten/blob/master/.github/workflows/build.yml) as the default CI/CD.\n- Always up-to-date dependencies with [`@dependabot`](https://dependabot.com/) (You will only [enable it](https://docs.github.com/en/github/administering-a-repository/enabling-and-disabling-version-updates#enabling-github-dependabot-version-updates)).\n- Automatic drafts of new releases with [`Release Drafter`](https://github.com/marketplace/actions/release-drafter). It creates a list of changes based on labels in merged `Pull Requests`. You can see labels (aka `categories`) in [`release-drafter.yml`](https://github.com/tZ3ma/zettelkasten/blob/master/.github/release-drafter.yml). Works perfectly with [Semantic Versions](https://semver.org/) specification.\n\nFor creating your open source community:\n\n- Ready-to-use [Pull Requests templates](https://github.com/tZ3ma/zettelkasten/blob/master/.github/PULL_REQUEST_TEMPLATE.md) and several [Issue templates](https://github.com/tZ3ma/zettelkasten/tree/master/.github/ISSUE_TEMPLATE).\n- Files such as: `LICENSE`, `CONTRIBUTING.md`, `CODE_OF_CONDUCT.md`, and `SECURITY.md` are generated automatically.\n- [`Stale bot`](https://github.com/apps/stale) that closes abandoned issues after a period of inactivity. (You will only [need to setup free plan](https://github.com/marketplace/stale)). Configuration is [here](https://github.com/tZ3ma/zettelkasten/blob/master/.github/.stale.yml).\n- [Semantic Versions](https://semver.org/) specification with [`Release Drafter`](https://github.com/marketplace/actions/release-drafter).\n\n## Installation\n\n```bash\npip install -U zettelkasten\n```\n\nor install with `Poetry`\n\n```bash\npoetry add zettelkasten\n```\n\nThen you can run\n\n```bash\nzettelkasten --help\n```\n\n```bash\nzettelkasten --name Roman\n```\n\nor if installed with `Poetry`:\n\n```bash\npoetry run zettelkasten --help\n```\n\n```bash\npoetry run zettelkasten --name Roman\n```\n\n### Makefile usage\n\n[`Makefile`](https://github.com/tZ3ma/zettelkasten/blob/master/Makefile) contains many functions for fast assembling and convenient work.\n\n<details>\n<summary>1. Download Poetry</summary>\n<p>\n\n```bash\nmake download-poetry\n```\n\n</p>\n</details>\n\n<details>\n<summary>2. Install all dependencies and pre-commit hooks</summary>\n<p>\n\n```bash\nmake install\n```\n\nIf you do not want to install pre-commit hooks, run the command with the NO_PRE_COMMIT flag:\n\n```bash\nmake install NO_PRE_COMMIT=1\n```\n\n</p>\n</details>\n\n<details>\n<summary>3. Check the security of your code</summary>\n<p>\n\n```bash\nmake check-safety\n```\n\nThis command launches a `Poetry` and `Pip` integrity check as well as identifies security issues with `Safety` and `Bandit`. By default, the build will not crash if any of the items fail. But you can set `STRICT=1` for the entire build, or you can configure strictness for each item separately.\n\n```bash\nmake check-safety STRICT=1\n```\n\nor only for `safety`:\n\n```bash\nmake check-safety SAFETY_STRICT=1\n```\n\nmultiple\n\n```bash\nmake check-safety PIP_STRICT=1 SAFETY_STRICT=1\n```\n\n> List of flags for `check-safety` (can be set to `1` or `0`): `STRICT`, `POETRY_STRICT`, `PIP_STRICT`, `SAFETY_STRICT`, `BANDIT_STRICT`.\n\n</p>\n</details>\n\n<details>\n<summary>4. Check the codestyle</summary>\n<p>\n\nThe command is similar to `check-safety` but to check the code style, obviously. It uses `Black`, `Darglint`, `Isort`, and `Mypy` inside.\n\n```bash\nmake check-style\n```\n\nIt may also contain the `STRICT` flag.\n\n```bash\nmake check-style STRICT=1\n```\n\n> List of flags for `check-style` (can be set to `1` or `0`): `STRICT`, `BLACK_STRICT`, `DARGLINT_STRICT`, `ISORT_STRICT`, `MYPY_STRICT`.\n\n</p>\n</details>\n\n<details>\n<summary>5. Run all the codestyle formaters</summary>\n<p>\n\nCodestyle uses `pre-commit` hooks, so ensure you\'ve run `make install` before.\n\n```bash\nmake codestyle\n```\n\n</p>\n</details>\n\n<details>\n<summary>6. Run tests</summary>\n<p>\n\n```bash\nmake test\n```\n\n</p>\n</details>\n\n<details>\n<summary>7. Run all the linters</summary>\n<p>\n\n```bash\nmake lint\n```\n\nthe same as:\n\n```bash\nmake test && make check-safety && make check-style\n```\n\n> List of flags for `lint` (can be set to `1` or `0`): `STRICT`, `POETRY_STRICT`, `PIP_STRICT`, `SAFETY_STRICT`, `BANDIT_STRICT`, `BLACK_STRICT`, `DARGLINT_STRICT`, `ISORT_STRICT`, `MYPY_STRICT`.\n\n</p>\n</details>\n\n<details>\n<summary>8. Build docker</summary>\n<p>\n\n```bash\nmake docker\n```\n\nwhich is equivalent to:\n\n```bash\nmake docker VERSION=latest\n```\n\nMore information [here](https://github.com/tZ3ma/zettelkasten/tree/master/docker).\n\n</p>\n</details>\n\n<details>\n<summary>9. Cleanup docker</summary>\n<p>\n\n```bash\nmake clean_docker\n```\n\nor to remove all build\n\n```bash\nmake clean\n```\n\nMore information [here](https://github.com/tZ3ma/zettelkasten/tree/master/docker).\n\n</p>\n</details>\n\n## 📈 Releases\n\nYou can see the list of available releases on the [GitHub Releases](https://github.com/tZ3ma/zettelkasten/releases) page.\n\nWe follow [Semantic Versions](https://semver.org/) specification.\n\nWe use [`Release Drafter`](https://github.com/marketplace/actions/release-drafter). As pull requests are merged, a draft release is kept up-to-date listing the changes, ready to publish when you’re ready. With the categories option, you can categorize pull requests in release notes using labels.\n\nFor Pull Request this labels are configured, by default:\n\n|               **Label**               |  **Title in Releases**  |\n| :-----------------------------------: | :---------------------: |\n|       `enhancement`, `feature`        |       🚀 Features       |\n| `bug`, `refactoring`, `bugfix`, `fix` | 🔧 Fixes & Refactoring  |\n|       `build`, `ci`, `testing`        | 📦 Build System & CI/CD |\n|              `breaking`               |   💥 Breaking Changes   |\n|            `documentation`            |    📝 Documentation     |\n|            `dependencies`             | ⬆️ Dependencies updates |\n\nYou can update it in [`release-drafter.yml`](https://github.com/tZ3ma/zettelkasten/blob/master/.github/release-drafter.yml).\n\nGitHub creates the `bug`, `enhancement`, and `documentation` labels for you. Dependabot creates the `dependencies` label. Create the remaining labels on the Issues tab of your GitHub repository, when you need them.\n\n## 🛡 License\n\n[![License](https://img.shields.io/github/license/tZ3ma/zettelkasten)](https://github.com/tZ3ma/zettelkasten/blob/master/LICENSE)\n\nThis project is licensed under the terms of the `MIT` license. See [LICENSE](https://github.com/tZ3ma/zettelkasten/blob/master/LICENSE) for more details.\n\n## 📃 Citation\n\n```\n@misc{zettelkasten,\n  author = {tZ3ma},\n  title = {Folder based zettelkasten with a bibtex reference system and emacs org-mode file zettels},\n  year = {2021},\n  publisher = {GitHub},\n  journal = {GitHub repository},\n  howpublished = {\\url{https://github.com/tZ3ma/zettelkasten}}\n}\n```\n\n## Credits\n\nThis project was generated with [`python-package-template`](https://github.com/TezRomacH/python-package-template).\n',
    'author': 'tZ3ma',
    'author_email': 'mathias.ammon@tuhh.de',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/tZ3ma/zettelkasten',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'entry_points': entry_points,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
