/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.areafilter.v0_6;

import java.io.File;
import org.openstreetmap.osmosis.areafilter.v0_6.AreaFilterTaskManagerFactory;
import org.openstreetmap.osmosis.areafilter.v0_6.PolygonFilter;
import org.openstreetmap.osmosis.core.filter.common.IdTrackerType;
import org.openstreetmap.osmosis.core.pipeline.common.TaskConfiguration;
import org.openstreetmap.osmosis.core.pipeline.common.TaskManager;
import org.openstreetmap.osmosis.core.pipeline.v0_6.SinkSourceManager;
import org.openstreetmap.osmosis.core.task.v0_6.SinkSource;

public class PolygonFilterFactory
extends AreaFilterTaskManagerFactory {
    private static final String ARG_FILE = "file";
    private static final String DEFAULT_FILE = "polygon.txt";
    private static final String ARG_CLIP_INCOMPLETE_ENTITIES = "clipIncompleteEntities";
    private static final String ARG_COMPLETE_WAYS = "completeWays";
    private static final String ARG_COMPLETE_RELATIONS = "completeRelations";
    private static final String ARG_CASCADING_RELATIONS = "cascadingRelations";
    private static final boolean DEFAULT_CLIP_INCOMPLETE_ENTITIES = false;
    private static final boolean DEFAULT_COMPLETE_WAYS = false;
    private static final boolean DEFAULT_COMPLETE_RELATIONS = false;
    private static final boolean DEFAULT_CASCADING_RELATIONS = false;

    protected TaskManager createTaskManagerImpl(TaskConfiguration taskConfig) {
        IdTrackerType idTrackerType = this.getIdTrackerType(taskConfig);
        String fileName = this.getStringArgument(taskConfig, ARG_FILE, DEFAULT_FILE);
        boolean clipIncompleteEntities = this.getBooleanArgument(taskConfig, ARG_CLIP_INCOMPLETE_ENTITIES, false);
        boolean completeWays = this.getBooleanArgument(taskConfig, ARG_COMPLETE_WAYS, false);
        boolean completeRelations = this.getBooleanArgument(taskConfig, ARG_COMPLETE_RELATIONS, false);
        boolean cascadingRelations = this.getBooleanArgument(taskConfig, ARG_CASCADING_RELATIONS, false);
        File file = new File(fileName);
        return new SinkSourceManager(taskConfig.getId(), (SinkSource)new PolygonFilter(idTrackerType, file, clipIncompleteEntities, completeWays, completeRelations, cascadingRelations), taskConfig.getPipeArgs());
    }
}

