/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.replication.v0_6;

import java.io.File;
import java.text.MessageFormat;
import java.util.logging.Logger;
import org.openstreetmap.osmosis.core.OsmosisRuntimeException;
import org.openstreetmap.osmosis.core.task.common.RunnableTask;
import org.openstreetmap.osmosis.core.util.FileBasedLock;
import org.openstreetmap.osmosis.core.util.PropertiesPersister;
import org.openstreetmap.osmosis.replication.common.ReplicationState;
import org.openstreetmap.osmosis.replication.common.ServerStateReader;
import org.openstreetmap.osmosis.replication.v0_6.impl.ReplicationDownloaderConfiguration;

public class ReplicationLagReader
implements RunnableTask {
    private static final Logger LOG = Logger.getLogger(ReplicationLagReader.class.getName());
    private static final String LOCK_FILE_NAME = "download.lock";
    private static final String CONFIG_FILE = "configuration.txt";
    private static final String LOCAL_STATE_FILE = "state.txt";
    private boolean humanReadable;
    private File workingDirectory;
    private ServerStateReader serverStateReader;

    public ReplicationLagReader(File workingDirectory, boolean humanReadable) {
        this.workingDirectory = workingDirectory;
        this.humanReadable = humanReadable;
        this.serverStateReader = new ServerStateReader();
    }

    private void getLag() {
        ReplicationDownloaderConfiguration configuration = new ReplicationDownloaderConfiguration(new File(this.workingDirectory, CONFIG_FILE));
        LOG.fine("Reading current server state.");
        ReplicationState serverState = this.serverStateReader.getServerState(configuration.getBaseUrl());
        PropertiesPersister localStatePersistor = new PropertiesPersister(new File(this.workingDirectory, LOCAL_STATE_FILE));
        if (!localStatePersistor.exists()) {
            throw new OsmosisRuntimeException("Can't read local state.");
        }
        ReplicationState localState = new ReplicationState(localStatePersistor.loadMap());
        long local = localState.getTimestamp().getTime();
        long server = serverState.getTimestamp().getTime();
        long lag = (server - local) / 1000L;
        if (this.humanReadable) {
            if (lag > 86400L) {
                Object[] args = new Object[]{new Long(lag / 86400L), new Long(lag % 86400L / 3600L)};
                System.out.println(new MessageFormat("{0} day(s) and {1} hour(s)").format(args));
            } else if (lag > 3600L) {
                Object[] args = new Object[]{new Long(lag / 3600L), new Long(lag % 3600L / 60L)};
                System.out.println(new MessageFormat("{0} hour(s) and {1} minute(s)").format(args));
            } else if (lag > 60L) {
                Object[] args = new Object[]{new Long(lag / 60L), new Long(lag % 60L)};
                System.out.println(new MessageFormat("{0} minute(s) and {1} second(s)").format(args));
            } else {
                Object[] args = new Object[]{new Long(lag)};
                System.out.println(new MessageFormat("{0} second(s)").format(args));
            }
        } else {
            System.out.println(lag);
        }
    }

    public void run() {
        try (FileBasedLock fileLock = new FileBasedLock(new File(this.workingDirectory, LOCK_FILE_NAME));){
            fileLock.lock();
            this.getLag();
            fileLock.unlock();
        }
    }
}

