/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.core.domain.v0_6;

import org.openstreetmap.osmosis.core.domain.v0_6.EntityType;
import org.openstreetmap.osmosis.core.store.StoreClassRegister;
import org.openstreetmap.osmosis.core.store.StoreReader;
import org.openstreetmap.osmosis.core.store.StoreWriter;
import org.openstreetmap.osmosis.core.store.Storeable;

public class RelationMember
implements Comparable<RelationMember>,
Storeable {
    private long memberId;
    private EntityType memberType;
    private String memberRole;

    public RelationMember(long memberId, EntityType memberType, String memberRole) {
        this.memberId = memberId;
        this.memberType = memberType;
        this.memberRole = memberRole;
        if (memberType == null) {
            throw new IllegalArgumentException("null type given for relation-member");
        }
        if (memberRole == null) {
            throw new IllegalArgumentException("null role given for relation-member");
        }
    }

    public RelationMember(StoreReader sr, StoreClassRegister scr) {
        this(sr.readLong(), EntityType.valueOf(sr.readString()), sr.readString());
    }

    @Override
    public void store(StoreWriter sw, StoreClassRegister scr) {
        sw.writeLong(this.memberId);
        sw.writeString(this.memberType.toString());
        sw.writeString(this.memberRole);
    }

    @Override
    public int compareTo(RelationMember relationMember) {
        long result = this.memberType.compareTo(relationMember.memberType);
        if (result > 0L) {
            return 1;
        }
        if (result < 0L) {
            return -1;
        }
        result = this.memberId - relationMember.memberId;
        if (result > 0L) {
            return 1;
        }
        if (result < 0L) {
            return -1;
        }
        result = this.memberRole.compareTo(relationMember.memberRole);
        if (result > 0L) {
            return 1;
        }
        if (result < 0L) {
            return -1;
        }
        return 0;
    }

    public long getMemberId() {
        return this.memberId;
    }

    public EntityType getMemberType() {
        return this.memberType;
    }

    public String getMemberRole() {
        return this.memberRole;
    }

    public String toString() {
        return "RelationMember(" + (Object)((Object)this.getMemberType()) + " with id " + this.getMemberId() + " in the role '" + this.getMemberRole() + "')";
    }
}

