/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.xml.v0_6.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import javax.xml.parsers.SAXParser;
import org.openstreetmap.osmosis.core.OsmosisRuntimeException;
import org.openstreetmap.osmosis.xml.common.CompressionActivator;
import org.openstreetmap.osmosis.xml.common.CompressionMethod;
import org.openstreetmap.osmosis.xml.common.SaxParserFactory;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class BaseXMLReader {
    private final File file;
    private final boolean enableDateParsing;
    private final CompressionMethod method;

    public BaseXMLReader(File file, boolean enableDateParsing, CompressionMethod method) {
        this.file = file;
        this.enableDateParsing = enableDateParsing;
        this.method = method;
    }

    public boolean isEnableDateParsing() {
        return this.enableDateParsing;
    }

    protected void parseXML(InputStream stream, DefaultHandler handler) throws SAXException, IOException {
        SAXParser parser = SaxParserFactory.createParser();
        parser.parse(stream, handler);
    }

    protected void handleXML(DefaultHandler handler) {
        try (InputStream stream = this.getInputStream();
             InputStream compressionStream = new CompressionActivator(this.method).createCompressionInputStream(stream);){
            this.parseXML(compressionStream, handler);
        }
        catch (SAXParseException e) {
            this.unzipParse(handler);
        }
        catch (SAXException e) {
            throw new OsmosisRuntimeException("Unable to parse XML.", (Throwable)e);
        }
        catch (IOException e) {
            throw new OsmosisRuntimeException("Unable to read XML file " + this.file + ".", (Throwable)e);
        }
    }

    private void unzipParse(DefaultHandler handler) {
        File tempFile;
        try {
            tempFile = File.createTempFile(this.getTempFilePrefix(), null);
        }
        catch (IOException e) {
            throw new OsmosisRuntimeException("Failed to create temporary file.", (Throwable)e);
        }
        try (InputStream fis = this.getInputStream();
             GZIPInputStream gzipStream = new GZIPInputStream(fis);
             FileOutputStream fos = new FileOutputStream(tempFile);){
            int length;
            byte[] buffer = new byte[1024];
            while ((length = gzipStream.read(buffer)) > 0) {
                fos.write(buffer, 0, length);
            }
        }
        catch (IOException e) {
            throw new OsmosisRuntimeException("Unable to unzip gz file " + this.file + ".", (Throwable)e);
        }
        try (FileInputStream unzippedStream = new FileInputStream(tempFile);){
            this.parseXML(unzippedStream, handler);
        }
        catch (SAXParseException e) {
            throw new OsmosisRuntimeException("Unable to parse xml file " + this.file + ".  publicId=(" + e.getPublicId() + "), systemId=(" + e.getSystemId() + "), lineNumber=" + e.getLineNumber() + ", columnNumber=" + e.getColumnNumber() + ".", (Throwable)e);
        }
        catch (SAXException e) {
            throw new OsmosisRuntimeException("Unable to parse XML.", (Throwable)e);
        }
        catch (IOException e) {
            throw new OsmosisRuntimeException("Unable to read XML file " + this.file + ".", (Throwable)e);
        }
    }

    private InputStream getInputStream() throws FileNotFoundException {
        if (this.file.getName().equals("-")) {
            return System.in;
        }
        return new FileInputStream(this.file);
    }

    private String getTempFilePrefix() {
        return this.file.getName() + "_" + System.currentTimeMillis();
    }
}

