/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.xml.v0_6;

import java.io.File;
import org.openstreetmap.osmosis.core.pipeline.common.TaskConfiguration;
import org.openstreetmap.osmosis.core.pipeline.common.TaskManager;
import org.openstreetmap.osmosis.core.pipeline.v0_6.RunnableSourceManager;
import org.openstreetmap.osmosis.core.task.v0_6.RunnableSource;
import org.openstreetmap.osmosis.xml.common.CompressionMethod;
import org.openstreetmap.osmosis.xml.common.XmlTaskManagerFactory;
import org.openstreetmap.osmosis.xml.v0_6.FastXmlReader;

public class FastXmlReaderFactory
extends XmlTaskManagerFactory {
    private static final String ARG_FILE_NAME = "file";
    private static final String DEFAULT_FILE_NAME = "dump.osm";
    private static final String ARG_ENABLE_DATE_PARSING = "enableDateParsing";
    private static final boolean DEFAULT_ENABLE_DATE_PARSING = true;

    protected TaskManager createTaskManagerImpl(TaskConfiguration taskConfig) {
        String fileName = this.getStringArgument(taskConfig, ARG_FILE_NAME, this.getDefaultStringArgument(taskConfig, DEFAULT_FILE_NAME));
        boolean enableDateParsing = this.getBooleanArgument(taskConfig, ARG_ENABLE_DATE_PARSING, true);
        CompressionMethod compressionMethod = this.getCompressionMethodArgument(taskConfig, fileName);
        File file = new File(fileName);
        FastXmlReader task = new FastXmlReader(file, enableDateParsing, compressionMethod);
        return new RunnableSourceManager(taskConfig.getId(), (RunnableSource)task, taskConfig.getPipeArgs());
    }
}

