/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.pgsimple.v0_6.impl;

import java.util.ArrayList;
import java.util.Collections;
import org.openstreetmap.osmosis.core.database.DbOrderedFeature;
import org.openstreetmap.osmosis.core.domain.v0_6.Way;
import org.openstreetmap.osmosis.core.domain.v0_6.WayNode;
import org.openstreetmap.osmosis.core.store.PeekableIterator;
import org.openstreetmap.osmosis.pgsimple.common.DatabaseContext;
import org.openstreetmap.osmosis.pgsimple.v0_6.impl.DbOrderedFeatureComparator;
import org.openstreetmap.osmosis.pgsimple.v0_6.impl.EntityFeatureTableReader;
import org.openstreetmap.osmosis.pgsimple.v0_6.impl.EntityReader;
import org.openstreetmap.osmosis.pgsimple.v0_6.impl.WayMapper;
import org.openstreetmap.osmosis.pgsimple.v0_6.impl.WayNodeMapper;

public class WayReader
extends EntityReader<Way> {
    private PeekableIterator<DbOrderedFeature<WayNode>> wayNodeReader;

    public WayReader(DatabaseContext dbCtx) {
        super(dbCtx, new WayMapper());
        this.wayNodeReader = new PeekableIterator(new EntityFeatureTableReader(dbCtx, new WayNodeMapper()));
    }

    public WayReader(DatabaseContext dbCtx, String constraintTable) {
        super(dbCtx, new WayMapper(), constraintTable);
        this.wayNodeReader = new PeekableIterator(new EntityFeatureTableReader(dbCtx, new WayNodeMapper(), constraintTable));
    }

    @Override
    protected void populateEntityFeatures(Way entity) {
        DbOrderedFeature wayNode;
        super.populateEntityFeatures(entity);
        long wayId = entity.getId();
        while (this.wayNodeReader.hasNext() && (wayNode = (DbOrderedFeature)this.wayNodeReader.peekNext()).getEntityId() < wayId) {
            this.wayNodeReader.next();
        }
        ArrayList<DbOrderedFeature> wayNodes = new ArrayList<DbOrderedFeature>();
        while (this.wayNodeReader.hasNext() && ((DbOrderedFeature)this.wayNodeReader.peekNext()).getEntityId() == wayId) {
            wayNodes.add((DbOrderedFeature)this.wayNodeReader.next());
        }
        Collections.sort(wayNodes, new DbOrderedFeatureComparator());
        for (DbOrderedFeature dbWayNode : wayNodes) {
            entity.getWayNodes().add((WayNode)dbWayNode.getFeature());
        }
    }

    @Override
    public void close() {
        super.close();
        this.wayNodeReader.close();
    }
}

