/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.replicationhttp.v0_6.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.LinkedList;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.WriteCompletionEvent;
import org.jboss.netty.handler.codec.http.DefaultHttpChunk;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.util.CharsetUtil;
import org.openstreetmap.osmosis.core.OsmosisRuntimeException;
import org.openstreetmap.osmosis.core.util.PropertiesPersister;
import org.openstreetmap.osmosis.replication.common.ReplicationSequenceFormatter;
import org.openstreetmap.osmosis.replication.common.ReplicationState;
import org.openstreetmap.osmosis.replicationhttp.v0_6.impl.SequenceServerControl;
import org.openstreetmap.osmosis.replicationhttp.v0_6.impl.SequenceServerHandler;

public class ReplicationDataServerHandler
extends SequenceServerHandler {
    private static final Logger LOG = Logger.getLogger(ReplicationDataServerHandler.class.getName());
    private static final String REQUEST_DATE_FORMAT = "yyyy-MM-dd-HH-mm-ss";
    private static final int CHUNK_SIZE = 4096;
    private File dataDirectory;
    private ReplicationSequenceFormatter sequenceFormatter;
    private FileChannel chunkedFileChannel;
    private boolean fileSizeSent;
    private boolean includeData;
    private ChannelFuture sequenceFuture;

    public ReplicationDataServerHandler(SequenceServerControl control, File dataDirectory) {
        super(control);
        this.dataDirectory = dataDirectory;
        this.sequenceFormatter = new ReplicationSequenceFormatter(9, 3);
    }

    private DateFormat getRequestDateParser() {
        SimpleDateFormat dateParser = new SimpleDateFormat(REQUEST_DATE_FORMAT);
        GregorianCalendar calendar = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        dateParser.setCalendar(calendar);
        return dateParser;
    }

    private File getStateFile(long sequenceNumber) {
        return new File(this.dataDirectory, this.sequenceFormatter.getFormattedName(sequenceNumber, ".state.txt"));
    }

    private File getDataFile(long sequenceNumber) {
        return new File(this.dataDirectory, this.sequenceFormatter.getFormattedName(sequenceNumber, ".osc.gz"));
    }

    private ReplicationState getReplicationState(long sequenceNumber) {
        PropertiesPersister persister = new PropertiesPersister(this.getStateFile(sequenceNumber));
        ReplicationState state = new ReplicationState();
        state.load(persister.loadMap());
        return state;
    }

    private long getNextSequenceNumberByDate(Date lastDate) {
        long startBound = 0L;
        long endBound = this.getControl().getLatestSequenceNumber();
        if (lastDate.compareTo(this.getReplicationState(endBound).getTimestamp()) >= 0) {
            return endBound;
        }
        while (endBound - startBound > 1L) {
            long midPoint = startBound + (endBound - startBound) / 2L;
            if (!this.getStateFile(midPoint).exists()) {
                startBound = midPoint;
                continue;
            }
            int comparison = lastDate.compareTo(this.getReplicationState(midPoint).getTimestamp());
            if (comparison == 0) {
                return midPoint;
            }
            if (comparison < 0) {
                endBound = midPoint;
                continue;
            }
            startBound = midPoint;
        }
        if (this.getStateFile(startBound).exists() && lastDate.compareTo(this.getReplicationState(startBound).getTimestamp()) >= 0) {
            return startBound;
        }
        throw new SequenceServerHandler.ResourceGoneException();
    }

    private FileChannel openFileChannel(File file) {
        try {
            return new FileInputStream(file).getChannel();
        }
        catch (FileNotFoundException e) {
            throw new OsmosisRuntimeException("Unable to open file " + file, (Throwable)e);
        }
    }

    private ChannelBuffer readFromFile(FileChannel fileChannel, int bytesToRead) {
        try {
            int lastBytesRead;
            byte[] rawBuffer = new byte[bytesToRead];
            ByteBuffer nioBuffer = ByteBuffer.wrap(rawBuffer);
            for (int bytesRead = 0; bytesRead < bytesToRead; bytesRead += lastBytesRead) {
                lastBytesRead = fileChannel.read(nioBuffer);
                if (lastBytesRead < 0) {
                    throw new OsmosisRuntimeException("Unexpectedly reached the end of the replication data file");
                }
                if (lastBytesRead != 0) continue;
                throw new OsmosisRuntimeException("Last read of the replication data file returned 0 bytes");
            }
            return ChannelBuffers.wrappedBuffer((byte[])rawBuffer);
        }
        catch (IOException e) {
            throw new OsmosisRuntimeException("Unable to read from the replication data file", (Throwable)e);
        }
    }

    private ChannelBuffer loadFile(File file) {
        ChannelBuffer channelBuffer;
        block9: {
            FileChannel fileChannel = this.openFileChannel(file);
            try {
                if (fileChannel.size() > Integer.MAX_VALUE) {
                    throw new OsmosisRuntimeException("Maximum file size supported is 2147483647 bytes");
                }
                int fileSize = (int)fileChannel.size();
                ChannelBuffer buffer = this.readFromFile(fileChannel, fileSize);
                fileChannel.close();
                channelBuffer = buffer;
                if (fileChannel == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (fileChannel != null) {
                        try {
                            fileChannel.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new OsmosisRuntimeException("Unable to read from file " + file, (Throwable)e);
                }
            }
            fileChannel.close();
        }
        return channelBuffer;
    }

    private ChannelBuffer getFileChunk() {
        try {
            long remaining = this.chunkedFileChannel.size() - this.chunkedFileChannel.position();
            if (remaining > 4096L) {
                remaining = 4096L;
            }
            ChannelBuffer buffer = this.readFromFile(this.chunkedFileChannel, (int)remaining);
            if (this.chunkedFileChannel.position() >= this.chunkedFileChannel.size()) {
                this.chunkedFileChannel.close();
                this.chunkedFileChannel = null;
            }
            return buffer;
        }
        catch (IOException e) {
            throw new OsmosisRuntimeException("Unable to read from the replication data file", (Throwable)e);
        }
    }

    private ChannelBuffer buildChunkHeader(long chunkSize) {
        return ChannelBuffers.copiedBuffer((CharSequence)(Long.toString(chunkSize) + "\r\n"), (Charset)CharsetUtil.UTF_8);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void handleRequest(ChannelHandlerContext ctx, HttpRequest request) {
        boolean follow;
        long nextSequenceNumber;
        String contentType;
        String replicationStateUri = "replicationState";
        String replicationDataUri = "replicationData";
        String textContentType = "text/plain";
        String dataContentType = "application/octet-stream";
        String uri = request.getUri();
        if (!uri.startsWith("/")) {
            throw new OsmosisRuntimeException("Uri doesn't start with a / character: " + uri);
        }
        LinkedList<String> uriElements = new LinkedList<String>(Arrays.asList(uri.split("/")));
        uriElements.remove();
        if (uriElements.isEmpty()) {
            throw new SequenceServerHandler.ResourceNotFoundException();
        }
        String requestTypeString = (String)uriElements.remove();
        if ("replicationState".equals(requestTypeString)) {
            contentType = "text/plain";
            this.includeData = false;
        } else {
            if (!"replicationData".equals(requestTypeString)) throw new SequenceServerHandler.ResourceNotFoundException();
            contentType = "application/octet-stream";
            this.includeData = true;
        }
        if (uriElements.isEmpty()) {
            throw new SequenceServerHandler.ResourceNotFoundException();
        }
        String sequenceStartString = (String)uriElements.remove();
        if ("current".equals(sequenceStartString)) {
            nextSequenceNumber = this.getControl().getLatestSequenceNumber();
        } else {
            try {
                nextSequenceNumber = Long.parseLong(sequenceStartString);
            }
            catch (NumberFormatException e) {
                try {
                    Date lastDate = this.getRequestDateParser().parse(sequenceStartString);
                    nextSequenceNumber = this.getNextSequenceNumberByDate(lastDate);
                }
                catch (ParseException e1) {
                    throw new SequenceServerHandler.BadRequestException("Requested sequence number of " + sequenceStartString + " is not a number, or a date in format yyyy-MM-dd-HH-mm-ss.");
                }
            }
        }
        if (!uriElements.isEmpty()) {
            String tailElement = (String)uriElements.remove();
            if (!"tail".equals(tailElement)) throw new SequenceServerHandler.ResourceNotFoundException();
            follow = true;
        } else {
            follow = false;
        }
        if (!uriElements.isEmpty()) {
            throw new SequenceServerHandler.ResourceNotFoundException();
        }
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("New request details, includeData=" + this.includeData + ", sequenceNumber=" + nextSequenceNumber + ", tail=" + follow);
        }
        this.initiateSequenceWriting(ctx, contentType, nextSequenceNumber, follow);
    }

    @Override
    protected void writeSequence(ChannelHandlerContext ctx, ChannelFuture future, long sequenceNumber) {
        if (this.chunkedFileChannel != null) {
            throw new OsmosisRuntimeException("We cannot send new replication data until the previous write has completed");
        }
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("Sequence being written, includeData=" + this.includeData + ", sequenceNumber=" + sequenceNumber);
        }
        this.sequenceFuture = future;
        File stateFile = this.getStateFile(sequenceNumber);
        File dataFile = this.getDataFile(sequenceNumber);
        ChannelBuffer stateFileBuffer = this.loadFile(stateFile);
        stateFileBuffer = ChannelBuffers.wrappedBuffer((ChannelBuffer[])new ChannelBuffer[]{this.buildChunkHeader(stateFileBuffer.readableBytes()), stateFileBuffer});
        if (this.includeData && sequenceNumber > 0L) {
            this.chunkedFileChannel = this.openFileChannel(dataFile);
            this.fileSizeSent = false;
        }
        ChannelFuture writeFuture = this.chunkedFileChannel != null ? Channels.future((Channel)ctx.getChannel()) : this.sequenceFuture;
        Channels.write((ChannelHandlerContext)ctx, (ChannelFuture)writeFuture, (Object)new DefaultHttpChunk(stateFileBuffer));
    }

    public void writeComplete(ChannelHandlerContext ctx, WriteCompletionEvent e) throws Exception {
        if (this.chunkedFileChannel != null) {
            ChannelBuffer buffer;
            ChannelFuture future;
            if (!this.fileSizeSent) {
                ChannelBuffer fileSizeBuffer = this.buildChunkHeader(this.chunkedFileChannel.size());
                this.fileSizeSent = true;
                future = Channels.future((Channel)ctx.getChannel());
                buffer = fileSizeBuffer;
            } else {
                buffer = this.getFileChunk();
                future = this.chunkedFileChannel != null ? Channels.future((Channel)ctx.getChannel()) : this.sequenceFuture;
            }
            Channels.write((ChannelHandlerContext)ctx, (ChannelFuture)future, (Object)new DefaultHttpChunk(buffer));
        } else {
            super.writeComplete(ctx, e);
        }
    }

    public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        if (this.chunkedFileChannel != null) {
            try {
                this.chunkedFileChannel.close();
            }
            catch (IOException ex) {
                LOG.log(Level.WARNING, "Unable to close the replication data file.", ex);
            }
            this.chunkedFileChannel = null;
        }
        super.channelClosed(ctx, e);
    }
}

