/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.apidb.v0_6.impl;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openstreetmap.osmosis.apidb.v0_6.impl.EntityDao;
import org.openstreetmap.osmosis.apidb.v0_6.impl.FeatureHistoryPopulator;
import org.openstreetmap.osmosis.apidb.v0_6.impl.WayNodeRowMapper;
import org.openstreetmap.osmosis.apidb.v0_6.impl.WayRowMapper;
import org.openstreetmap.osmosis.core.container.v0_6.EntityContainerFactory;
import org.openstreetmap.osmosis.core.container.v0_6.WayContainerFactory;
import org.openstreetmap.osmosis.core.database.DbFeatureHistory;
import org.openstreetmap.osmosis.core.database.DbFeatureHistoryRowMapper;
import org.openstreetmap.osmosis.core.database.DbFeatureRowMapper;
import org.openstreetmap.osmosis.core.database.DbOrderedFeature;
import org.openstreetmap.osmosis.core.database.DbOrderedFeatureHistoryComparator;
import org.openstreetmap.osmosis.core.database.DbOrderedFeatureRowMapper;
import org.openstreetmap.osmosis.core.database.RowMapperListener;
import org.openstreetmap.osmosis.core.database.SortingStoreRowMapperListener;
import org.openstreetmap.osmosis.core.database.WayNodeCollectionLoader;
import org.openstreetmap.osmosis.core.domain.v0_6.CommonEntityData;
import org.openstreetmap.osmosis.core.domain.v0_6.Way;
import org.openstreetmap.osmosis.core.domain.v0_6.WayNode;
import org.openstreetmap.osmosis.core.lifecycle.Closeable;
import org.openstreetmap.osmosis.core.lifecycle.ReleasableIterator;
import org.openstreetmap.osmosis.core.sort.common.FileBasedSort;
import org.openstreetmap.osmosis.core.store.ObjectSerializationFactory;
import org.openstreetmap.osmosis.core.store.SingleClassObjectSerializationFactory;
import org.openstreetmap.osmosis.core.store.StoreReleasingIterator;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

public class WayDao
extends EntityDao<Way> {
    private static final Logger LOG = Logger.getLogger(WayDao.class.getName());
    private static final String[] TYPE_SPECIFIC_FIELD_NAMES = new String[0];

    public WayDao(JdbcTemplate jdbcTemplate) {
        super(jdbcTemplate, "way");
    }

    @Override
    protected RowMapperListener<CommonEntityData> getEntityRowMapper(RowMapperListener<Way> entityListener) {
        return new WayRowMapper(entityListener);
    }

    @Override
    protected String[] getTypeSpecificFieldNames() {
        return TYPE_SPECIFIC_FIELD_NAMES;
    }

    @Override
    protected EntityContainerFactory<Way> getContainerFactory() {
        return new WayContainerFactory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReleasableIterator<DbFeatureHistory<DbOrderedFeature<WayNode>>> getWayNodeHistory(String selectedEntityStatement, SqlParameterSource parameterSource) {
        try (FileBasedSort sortingStore = new FileBasedSort((ObjectSerializationFactory)new SingleClassObjectSerializationFactory(DbFeatureHistory.class), (Comparator)new DbOrderedFeatureHistoryComparator(), true);){
            String sql = "SELECT wn.way_id AS id, wn.node_id, wn.version, wn.sequence_id FROM way_nodes wn INNER JOIN " + selectedEntityStatement + " t ON wn.way_id = t.way_id AND wn.version = t.version";
            LOG.log(Level.FINER, "Way node history query: " + sql);
            SortingStoreRowMapperListener storeListener = new SortingStoreRowMapperListener(sortingStore);
            DbFeatureHistoryRowMapper dbFeatureHistoryRowMapper = new DbFeatureHistoryRowMapper((RowMapperListener)storeListener);
            DbOrderedFeatureRowMapper dbOrderedFeatureRowMapper = new DbOrderedFeatureRowMapper((RowMapperListener)dbFeatureHistoryRowMapper);
            DbFeatureRowMapper dbFeatureRowMapper = new DbFeatureRowMapper((RowMapperListener)dbOrderedFeatureRowMapper);
            WayNodeRowMapper wayNodeRowMapper = new WayNodeRowMapper((RowMapperListener<WayNode>)dbFeatureRowMapper);
            this.getNamedParamJdbcTemplate().query(sql, parameterSource, (RowCallbackHandler)wayNodeRowMapper);
            StoreReleasingIterator resultIterator = new StoreReleasingIterator(sortingStore.iterate(), (Closeable)sortingStore);
            sortingStore = null;
            StoreReleasingIterator storeReleasingIterator = resultIterator;
            return storeReleasingIterator;
        }
    }

    @Override
    protected List<FeatureHistoryPopulator<Way, ?, ?>> getFeatureHistoryPopulators(String selectedEntityStatement, MapSqlParameterSource parameterSource) {
        ArrayList featurePopulators = new ArrayList();
        ReleasableIterator<DbFeatureHistory<DbOrderedFeature<WayNode>>> wayNodeIterator = this.getWayNodeHistory(selectedEntityStatement, (SqlParameterSource)parameterSource);
        featurePopulators.add(new FeatureHistoryPopulator(wayNodeIterator, new WayNodeCollectionLoader()));
        return featurePopulators;
    }
}

