/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.apidb.v0_6;

import org.openstreetmap.osmosis.apidb.common.DatabaseContext2;
import org.openstreetmap.osmosis.apidb.v0_6.ApidbVersionConstants;
import org.openstreetmap.osmosis.apidb.v0_6.impl.AllEntityDao;
import org.openstreetmap.osmosis.apidb.v0_6.impl.Replicator;
import org.openstreetmap.osmosis.apidb.v0_6.impl.SchemaVersionValidator;
import org.openstreetmap.osmosis.apidb.v0_6.impl.TimeDao;
import org.openstreetmap.osmosis.apidb.v0_6.impl.TransactionDao;
import org.openstreetmap.osmosis.core.database.DatabaseLocker;
import org.openstreetmap.osmosis.core.database.DatabaseLoginCredentials;
import org.openstreetmap.osmosis.core.database.DatabasePreferences;
import org.openstreetmap.osmosis.core.task.v0_6.ChangeSink;
import org.openstreetmap.osmosis.core.task.v0_6.RunnableChangeSource;

public class ApidbFileReplicator
implements RunnableChangeSource {
    private DatabaseLoginCredentials loginCredentials;
    private DatabasePreferences preferences;
    private int iterations;
    private int minInterval;
    private int maxInterval;
    private ChangeSink changeSink;

    public ApidbFileReplicator(DatabaseLoginCredentials loginCredentials, DatabasePreferences preferences, int iterations, int minInterval, int maxInterval) {
        this.loginCredentials = loginCredentials;
        this.preferences = preferences;
        this.iterations = iterations;
        this.minInterval = minInterval;
        this.maxInterval = maxInterval;
    }

    public void setChangeSink(ChangeSink changeSink) {
        this.changeSink = changeSink;
    }

    protected void runImpl(DatabaseContext2 dbCtx) {
        new SchemaVersionValidator(this.loginCredentials, this.preferences).validateVersion(ApidbVersionConstants.SCHEMA_MIGRATIONS);
        AllEntityDao source = new AllEntityDao(dbCtx.getJdbcTemplate());
        TransactionDao txnSnapshotLoader = new TransactionDao(dbCtx);
        TimeDao systemTimeLoader = new TimeDao(dbCtx.getJdbcTemplate());
        Replicator replicator = new Replicator(source, this.changeSink, txnSnapshotLoader, systemTimeLoader, this.iterations, this.minInterval, this.maxInterval);
        replicator.replicate();
    }

    public void run() {
        try (DatabaseContext2 dbCtx = new DatabaseContext2(this.loginCredentials);
             DatabaseLocker locker = new DatabaseLocker(dbCtx.getDataSource(), false);){
            locker.lockDatabase(this.getClass().getSimpleName());
            this.runImpl(dbCtx);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

