# This code is part of Quinteng.
#
# (C) Copyright IBM 2018, 2019.
#
# This code is licensed under the Apache License, Version 2.0. You may
# obtain a copy of this license in the LICENSE.txt file in the root directory
# of this source tree or at http://www.apache.org/licenses/LICENSE-2.0.
#
# Any modifications or derivative works of this code must retain this
# copyright notice, and modified files need to carry a notice indicating
# that they have been altered from the originals.

"""
===========================================================
Circuit Extensions (:mod:`quinteng.providers.app.extensions`)
===========================================================

.. currentmodule:: quinteng.providers.app.extensions

Snapshots
=========

.. deprecated:: 0.9.0

    Adding nonlocal noise to a noise model is deprecated as of quinteng-app
    0.9.0 and will be removed no earlier than 3 months from that release date.
    They have been superceded by the save instructions in the
    :mod:`quinteng.providers.app.library` module.

Snapshot instructions allow taking a snapshot of the current state of the
simulator without effecting the outcome of the simulation. These can be
used with the `QasmSimulator` backend to return the expectation value of
an operator or the probability of measurement outcomes.

.. autosummary::
    :toctree: ../stubs/

    Snapshot
    SnapshotProbabilities
    SnapshotExpectationValue
    SnapshotStatevector
    SnapshotDensityMatrix
    SnapshotStabilizer
"""

from .snapshot import *
from .snapshot_statevector import *
from .snapshot_stabilizer import *
from .snapshot_density_matrix import *
from .snapshot_probabilities import *
from .snapshot_expectation_value import *
