---
marp: true
theme: default
paginate: true
header: "![width:150px](path/to/your/logo.png)"
transition: slide
style: |
  .logos {
    position: absolute;
    bottom: 20px;
    right: 20px;
  }
  section header {
    top: 20px;
    right: 20px;
  }
  /* Add animation classes */
  .animate-fade-in {
    animation: fadeIn 0.5s ease-in;
  }
  @keyframes fadeIn {
    from { opacity: 0; }
    to { opacity: 1; }
  }
---

<!-- _class: lead -->
<!-- _transition: fade -->

# Climate Change: A Global Challenge
## Understanding Our Changing Planet

<div class="logos">
  ![width:100px](path/to/specific-logo.png)
</div>

---

<!-- _transition: slide -->
# What is Climate Change?

## Definition
- Long-term shift in global weather patterns
- Average temperature changes over decades
- Natural and human-induced variations in Earth's climate

## Key Characteristics
- Sustained changes lasting decades or longer
- Global scope with regional variations
- Affects all aspects of Earth's systems

## Scientific Evidence
- Temperature records dating back centuries
- Ice core samples revealing climate history
- Satellite data showing global patterns
- Ocean temperature measurements

## Distinguishing Features
- Different from normal weather variations
- Systematic changes in long-term patterns
- Measurable impact on global ecosystems

---

# Key Indicators

- Global temperature rise
- Sea level rise
- Ocean acidification
- Arctic ice melt
- Extreme weather events

---

# Main Causes

1. Greenhouse Gas Emissions
   - Carbon dioxide (CO2)
   - Methane
   - Nitrous oxide

2. Deforestation
3. Industrial activities

---

# Impact on Ecosystems

- Loss of biodiversity
- Coral reef bleaching
- Changes in migration patterns
- Habitat destruction
- Species extinction

---

# Human Impact

- Food security challenges
- Water scarcity
- Health risks
- Economic consequences
- Displacement of communities

---

# Solutions

## Individual Actions
- Reduce energy consumption
- Use sustainable transportation
- Choose renewable energy
- Minimize waste

## Global Efforts
- Paris Agreement
- Renewable energy transition
- Carbon pricing
- Forest conservation

---

# Call to Action

- Support climate policies
- Make sustainable choices
- Spread awareness
- Get involved in local initiatives

---

# Thank You

For more information:
- IPCC: www.ipcc.ch
- NASA Climate: climate.nasa.gov
- UN Climate Action: www.un.org/climatechange