# AUTOGENERATED! DO NOT EDIT! File to edit: notebooks/02c_pds.apps.ipynb (unless otherwise specified).

__all__ = ['find_indexes', 'get_index', 'find_instruments']

# Cell
from ..config import config
from .indexes import Index

# Cell

def find_indexes(instrument):
    """Find existing indexes for an instrument.

    Parameters
    ----------
    instrument: str
        Dotted mission.instrument key, e.g. cassini.iss

    Returns
    -------
    list
        List of configured index names
    """
    return config.list_indexes(instrument)

# Cell

def get_index(key):
    """example key: cassini.iss.indexes.index

    Parameters
    ----------
    key: str
        Dotted index in form of cassini.iss.indexes.index

    Returns
    -------
    pandas.DataFrame
        The PDS index converted to a pandas DataFrame.
    """
    index = Index(key)
    if not index.local_table_path.exists():
        index.download()
        index.convert_to_hdf()
    return index.df

# Cell

def find_instruments(mission):
    """Find existing instruments for a mission.

    Parameters
    ----------
    mission: str
        E.g. 'cassini'

    Returns
    -------
    list
        List of configured instrument names
    """
    return config.list_instruments(mission)