/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.core.model.data.helper;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Objects;
import org.javarosa.core.model.QuestionDef;
import org.javarosa.core.model.SelectChoice;
import org.javarosa.core.util.externalizable.ExtUtil;
import org.javarosa.core.util.externalizable.Externalizable;
import org.javarosa.core.util.externalizable.PrototypeFactory;
import org.javarosa.xpath.XPathTypeMismatchException;

public class Selection
implements Externalizable {
    public String xmlValue = null;
    public int index = -1;
    public SelectChoice choice;

    public Selection() {
    }

    public Selection(SelectChoice choice) {
        this.attachChoice(choice);
    }

    public Selection(String xmlValue) {
        this.xmlValue = xmlValue;
    }

    public Selection(int index) {
        this.index = index;
    }

    public Selection clone() {
        Selection s = new Selection();
        s.choice = this.choice;
        s.xmlValue = this.xmlValue;
        s.index = this.index;
        return s;
    }

    public void attachChoice(SelectChoice choice) {
        this.choice = choice;
        this.xmlValue = choice.getValue();
        this.index = choice.getIndex();
    }

    public void attachChoice(QuestionDef q) {
        if (q.getDynamicChoices() != null) {
            return;
        }
        SelectChoice choice = null;
        if (this.index != -1 && this.index < q.getNumChoices()) {
            choice = q.getChoice(this.index);
        } else if (this.xmlValue != null && this.xmlValue.length() > 0) {
            choice = q.getChoiceForValue(this.xmlValue);
        }
        if (choice == null) {
            throw new XPathTypeMismatchException("value " + this.xmlValue + " could not be loaded into question " + q.getTextID() + ".  Check to see if value " + this.xmlValue + " is a valid option for question " + q.getTextID() + ".");
        }
        this.attachChoice(choice);
    }

    public String getValue() {
        if (this.xmlValue != null && this.xmlValue.length() > 0) {
            return this.xmlValue;
        }
        throw new RuntimeException("This choice is not valid. If you are using an external file, please make sure it has the expected columns (usually name and label).");
    }

    @Override
    public void readExternal(DataInputStream in, PrototypeFactory pf) throws IOException {
        this.xmlValue = ExtUtil.readString(in);
        this.index = ExtUtil.readInt(in);
    }

    @Override
    public void writeExternal(DataOutputStream out) throws IOException {
        ExtUtil.writeString(out, this.getValue());
        ExtUtil.writeNumeric(out, this.index);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Selection selection = (Selection)o;
        return this.index == selection.index && Objects.equals(this.xmlValue, selection.xmlValue) && Objects.equals(this.choice, selection.choice);
    }

    public int hashCode() {
        return Objects.hash(this.xmlValue, this.index, this.choice);
    }
}

