/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.core.model;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.javarosa.core.model.FormElementStateListener;
import org.javarosa.core.model.IDataReference;
import org.javarosa.core.model.IFormElement;
import org.javarosa.core.model.actions.ActionController;
import org.javarosa.core.model.instance.FormInstance;
import org.javarosa.core.model.instance.TreeElement;
import org.javarosa.core.model.instance.TreeReference;
import org.javarosa.core.model.utils.DateUtils;
import org.javarosa.core.services.locale.Localizable;
import org.javarosa.core.services.locale.Localizer;
import org.javarosa.core.util.externalizable.DeserializationException;
import org.javarosa.core.util.externalizable.ExtUtil;
import org.javarosa.core.util.externalizable.ExtWrapListPoly;
import org.javarosa.core.util.externalizable.ExtWrapNullable;
import org.javarosa.core.util.externalizable.ExtWrapTagged;
import org.javarosa.core.util.externalizable.PrototypeFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupDef
implements IFormElement,
Localizable {
    private static final Logger logger = LoggerFactory.getLogger(GroupDef.class);
    private List<IFormElement> children;
    private boolean repeat;
    private int id;
    private IDataReference binding;
    private List<TreeElement> additionalAttributes = new ArrayList<TreeElement>(0);
    private String labelInnerText;
    private String appearanceAttr;
    private String textID;
    public String chooseCaption;
    public String addCaption;
    public String delCaption;
    public String doneCaption;
    public String addEmptyCaption;
    public String doneEmptyCaption;
    public String entryHeader;
    public String delHeader;
    public String mainHeader;
    List<FormElementStateListener> observers;
    public boolean noAddRemove = false;
    public IDataReference count = null;
    private ActionController actionController;

    public GroupDef() {
        this(-1, null, false);
    }

    public GroupDef(int id, List<IFormElement> children, boolean repeat) {
        this.setID(id);
        this.setChildren(children);
        this.setRepeat(repeat);
        this.observers = new ArrayList<FormElementStateListener>(0);
        this.actionController = new ActionController();
    }

    @Override
    public int getID() {
        return this.id;
    }

    @Override
    public void setID(int id) {
        this.id = id;
    }

    @Override
    public IDataReference getBind() {
        return this.binding;
    }

    public void setBind(IDataReference binding) {
        this.binding = binding;
    }

    @Override
    public void setAdditionalAttribute(String namespace, String name, String value) {
        TreeElement.setAttribute(null, this.additionalAttributes, namespace, name, value);
    }

    @Override
    public String getAdditionalAttribute(String namespace, String name) {
        TreeElement e = TreeElement.getAttribute(this.additionalAttributes, namespace, name);
        if (e != null) {
            return e.getAttributeValue();
        }
        return null;
    }

    @Override
    public List<TreeElement> getAdditionalAttributes() {
        return this.additionalAttributes;
    }

    @Override
    public List<IFormElement> getChildren() {
        return this.children;
    }

    @Override
    public void setChildren(List<IFormElement> children) {
        this.children = children == null ? new ArrayList(0) : children;
    }

    @Override
    public void addChild(IFormElement fe) {
        this.children.add(fe);
    }

    @Override
    public IFormElement getChild(int i) {
        if (this.children == null || i >= this.children.size()) {
            return null;
        }
        return this.children.get(i);
    }

    public boolean getRepeat() {
        return this.repeat;
    }

    public void setRepeat(boolean repeat) {
        this.repeat = repeat;
    }

    @Override
    public String getLabelInnerText() {
        return this.labelInnerText;
    }

    public void setLabelInnerText(String lit) {
        this.labelInnerText = lit;
    }

    @Override
    public String getAppearanceAttr() {
        return this.appearanceAttr;
    }

    @Override
    public void setAppearanceAttr(String appearanceAttr) {
        this.appearanceAttr = appearanceAttr;
    }

    @Override
    public ActionController getActionController() {
        return this.actionController;
    }

    @Override
    public void localeChanged(String locale, Localizer localizer) {
        for (IFormElement child : this.children) {
            child.localeChanged(locale, localizer);
        }
    }

    public IDataReference getCountReference() {
        return this.count;
    }

    public TreeReference getConextualizedCountReference(TreeReference context) {
        return FormInstance.unpackReference(this.count).contextualize(context);
    }

    public String toString() {
        return "<group>";
    }

    @Override
    public int getDeepChildCount() {
        int total = 0;
        for (IFormElement child : this.children) {
            total += child.getDeepChildCount();
        }
        return total;
    }

    @Override
    public void readExternal(DataInputStream dis, PrototypeFactory pf) throws IOException, DeserializationException {
        try {
            this.setID(ExtUtil.readInt(dis));
            this.setAppearanceAttr((String)ExtUtil.read(dis, new ExtWrapNullable(String.class), pf));
            this.setBind((IDataReference)ExtUtil.read(dis, new ExtWrapTagged(), pf));
            this.setTextID((String)ExtUtil.read(dis, new ExtWrapNullable(String.class), pf));
            this.setLabelInnerText((String)ExtUtil.read(dis, new ExtWrapNullable(String.class), pf));
            this.setRepeat(ExtUtil.readBool(dis));
            this.setChildren((List)ExtUtil.read(dis, new ExtWrapListPoly(), pf));
            this.noAddRemove = ExtUtil.readBool(dis);
            this.count = (IDataReference)ExtUtil.read(dis, new ExtWrapNullable(new ExtWrapTagged()), pf);
            this.chooseCaption = ExtUtil.nullIfEmpty(ExtUtil.readString(dis));
            this.addCaption = ExtUtil.nullIfEmpty(ExtUtil.readString(dis));
            this.delCaption = ExtUtil.nullIfEmpty(ExtUtil.readString(dis));
            this.doneCaption = ExtUtil.nullIfEmpty(ExtUtil.readString(dis));
            this.addEmptyCaption = ExtUtil.nullIfEmpty(ExtUtil.readString(dis));
            this.doneEmptyCaption = ExtUtil.nullIfEmpty(ExtUtil.readString(dis));
            this.entryHeader = ExtUtil.nullIfEmpty(ExtUtil.readString(dis));
            this.delHeader = ExtUtil.nullIfEmpty(ExtUtil.readString(dis));
            this.mainHeader = ExtUtil.nullIfEmpty(ExtUtil.readString(dis));
            this.additionalAttributes = ExtUtil.readAttributes(dis, null);
            this.actionController = (ActionController)ExtUtil.read(dis, new ExtWrapNullable(ActionController.class), pf);
        }
        catch (OutOfMemoryError e) {
            throw new DeserializationException("serialization format change caused misalignment and out-of-memory error");
        }
    }

    @Override
    public void writeExternal(DataOutputStream dos) throws IOException {
        ExtUtil.writeNumeric(dos, this.getID());
        ExtUtil.write(dos, new ExtWrapNullable(this.getAppearanceAttr()));
        ExtUtil.write(dos, new ExtWrapTagged(this.getBind()));
        ExtUtil.write(dos, new ExtWrapNullable(this.getTextID()));
        ExtUtil.write(dos, new ExtWrapNullable(this.getLabelInnerText()));
        ExtUtil.writeBool(dos, this.getRepeat());
        ExtUtil.write(dos, new ExtWrapListPoly(this.getChildren()));
        ExtUtil.writeBool(dos, this.noAddRemove);
        ExtUtil.write(dos, new ExtWrapNullable(this.count != null ? new ExtWrapTagged(this.count) : null));
        ExtUtil.writeString(dos, ExtUtil.emptyIfNull(this.chooseCaption));
        ExtUtil.writeString(dos, ExtUtil.emptyIfNull(this.addCaption));
        ExtUtil.writeString(dos, ExtUtil.emptyIfNull(this.delCaption));
        ExtUtil.writeString(dos, ExtUtil.emptyIfNull(this.doneCaption));
        ExtUtil.writeString(dos, ExtUtil.emptyIfNull(this.addEmptyCaption));
        ExtUtil.writeString(dos, ExtUtil.emptyIfNull(this.doneEmptyCaption));
        ExtUtil.writeString(dos, ExtUtil.emptyIfNull(this.entryHeader));
        ExtUtil.writeString(dos, ExtUtil.emptyIfNull(this.delHeader));
        ExtUtil.writeString(dos, ExtUtil.emptyIfNull(this.mainHeader));
        ExtUtil.writeAttributes(dos, this.additionalAttributes);
        ExtUtil.write(dos, new ExtWrapNullable(this.actionController));
    }

    @Override
    public void registerStateObserver(FormElementStateListener qsl) {
        if (!this.observers.contains(qsl)) {
            this.observers.add(qsl);
        }
    }

    @Override
    public void unregisterStateObserver(FormElementStateListener qsl) {
        this.observers.remove(qsl);
    }

    @Override
    public String getTextID() {
        return this.textID;
    }

    @Override
    public void setTextID(String textID) {
        if (textID == null) {
            this.textID = null;
            return;
        }
        if (DateUtils.stringContains(textID, ";")) {
            logger.warn("TextID contains ;form modifier:: \"{}\"... will be stripped.", (Object)textID.substring(textID.indexOf(";")));
            textID = textID.substring(0, textID.indexOf(";"));
        }
        this.textID = textID;
    }
}

