# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import errno
from setuptools import setup, find_packages
from setuptools.command.install import install
from subprocess import check_call


VERSION = "0.1.21"
PLUGIN_VERSION = "0.1.21"

class InstallPluginCommand(install):
    def run(self):
        install.run(self)
        try:
            check_call(['pulumi', 'plugin', 'install', 'resource', 'docker-buildkit', PLUGIN_VERSION, '--server', 'https://github.com/MaterializeInc/pulumi-docker-buildkit/releases/download/v0.1.21/'])
        except OSError as error:
            if error.errno == errno.ENOENT:
                print(f"""
                There was an error installing the docker-buildkit resource provider plugin.
                It looks like `pulumi` is not installed on your system.
                Please visit https://pulumi.com/ to install the Pulumi CLI.
                You may try manually installing the plugin by running
                `pulumi plugin install resource docker-buildkit {PLUGIN_VERSION}`
                """)
            else:
                raise


def readme():
    try:
        with open('README.md', encoding='utf-8') as f:
            return f.read()
    except FileNotFoundError:
        return "docker-buildkit Pulumi Package - Development Version"


setup(name='pulumi_docker_buildkit',
      version=VERSION,
      description="A Pulumi package for building Docker images with Buildkit.",
      long_description=readme(),
      long_description_content_type='text/markdown',
      cmdclass={
          'install': InstallPluginCommand,
      },
      project_urls={
          'Repository': 'https://github.com/MaterializeInc/pulumi-docker-buildkit'
      },
      license='Apache-2.0',
      packages=find_packages(),
      package_data={
          'pulumi_docker_buildkit': [
              'py.typed',
              'pulumi-plugin.json',
          ]
      },
      install_requires=[
          'parver>=0.2.1',
          'pulumi',
          'semver>=2.8.1'
      ],
      zip_safe=False)
